package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCdnDeliverTask invokes the cdn.CreateCdnDeliverTask API synchronously
func (client *Client) CreateCdnDeliverTask(request *CreateCdnDeliverTaskRequest) (response *CreateCdnDeliverTaskResponse, err error) {
	response = CreateCreateCdnDeliverTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCdnDeliverTaskWithChan invokes the cdn.CreateCdnDeliverTask API asynchronously
func (client *Client) CreateCdnDeliverTaskWithChan(request *CreateCdnDeliverTaskRequest) (<-chan *CreateCdnDeliverTaskResponse, <-chan error) {
	responseChan := make(chan *CreateCdnDeliverTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCdnDeliverTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCdnDeliverTaskWithCallback invokes the cdn.CreateCdnDeliverTask API asynchronously
func (client *Client) CreateCdnDeliverTaskWithCallback(request *CreateCdnDeliverTaskRequest, callback func(response *CreateCdnDeliverTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCdnDeliverTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateCdnDeliverTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCdnDeliverTaskRequest is the request struct for api CreateCdnDeliverTask
type CreateCdnDeliverTaskRequest struct {
	*requests.RpcRequest
	Reports    string           `position:"Body" name:"Reports"`
	Deliver    string           `position:"Body" name:"Deliver"`
	DomainName string           `position:"Body" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Schedule   string           `position:"Body" name:"Schedule"`
	Name       string           `position:"Body" name:"Name"`
}

// CreateCdnDeliverTaskResponse is the response struct for api CreateCdnDeliverTask
type CreateCdnDeliverTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateCdnDeliverTaskRequest creates a request to invoke CreateCdnDeliverTask API
func CreateCreateCdnDeliverTaskRequest() (request *CreateCdnDeliverTaskRequest) {
	request = &CreateCdnDeliverTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "CreateCdnDeliverTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateCdnDeliverTaskResponse creates a response to parse from CreateCdnDeliverTask response
func CreateCreateCdnDeliverTaskResponse() (response *CreateCdnDeliverTaskResponse) {
	response = &CreateCdnDeliverTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
