package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveTestPhoneNumber invokes the cloudcallcenter.RemoveTestPhoneNumber API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removetestphonenumber.html
func (client *Client) RemoveTestPhoneNumber(request *RemoveTestPhoneNumberRequest) (response *RemoveTestPhoneNumberResponse, err error) {
	response = CreateRemoveTestPhoneNumberResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveTestPhoneNumberWithChan invokes the cloudcallcenter.RemoveTestPhoneNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removetestphonenumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveTestPhoneNumberWithChan(request *RemoveTestPhoneNumberRequest) (<-chan *RemoveTestPhoneNumberResponse, <-chan error) {
	responseChan := make(chan *RemoveTestPhoneNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveTestPhoneNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveTestPhoneNumberWithCallback invokes the cloudcallcenter.RemoveTestPhoneNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removetestphonenumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveTestPhoneNumberWithCallback(request *RemoveTestPhoneNumberRequest, callback func(response *RemoveTestPhoneNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveTestPhoneNumberResponse
		var err error
		defer close(result)
		response, err = client.RemoveTestPhoneNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveTestPhoneNumberRequest is the request struct for api RemoveTestPhoneNumber
type RemoveTestPhoneNumberRequest struct {
	*requests.RpcRequest
	PhoneNumberId string `position:"Query" name:"PhoneNumberId"`
}

// RemoveTestPhoneNumberResponse is the response struct for api RemoveTestPhoneNumber
type RemoveTestPhoneNumberResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateRemoveTestPhoneNumberRequest creates a request to invoke RemoveTestPhoneNumber API
func CreateRemoveTestPhoneNumberRequest() (request *RemoveTestPhoneNumberRequest) {
	request = &RemoveTestPhoneNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "RemoveTestPhoneNumber", "", "")
	request.Method = requests.POST
	return
}

// CreateRemoveTestPhoneNumberResponse creates a response to parse from RemoveTestPhoneNumber response
func CreateRemoveTestPhoneNumberResponse() (response *RemoveTestPhoneNumberResponse) {
	response = &RemoveTestPhoneNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
