package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveApPortalConfig invokes the cloudwf.SaveApPortalConfig API synchronously
// api document: https://help.aliyun.com/api/cloudwf/saveapportalconfig.html
func (client *Client) SaveApPortalConfig(request *SaveApPortalConfigRequest) (response *SaveApPortalConfigResponse, err error) {
	response = CreateSaveApPortalConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SaveApPortalConfigWithChan invokes the cloudwf.SaveApPortalConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveapportalconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveApPortalConfigWithChan(request *SaveApPortalConfigRequest) (<-chan *SaveApPortalConfigResponse, <-chan error) {
	responseChan := make(chan *SaveApPortalConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveApPortalConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveApPortalConfigWithCallback invokes the cloudwf.SaveApPortalConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveapportalconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveApPortalConfigWithCallback(request *SaveApPortalConfigRequest, callback func(response *SaveApPortalConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveApPortalConfigResponse
		var err error
		defer close(result)
		response, err = client.SaveApPortalConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveApPortalConfigRequest is the request struct for api SaveApPortalConfig
type SaveApPortalConfigRequest struct {
	*requests.RpcRequest
	AuthKey      string           `position:"Query" name:"AuthKey"`
	PortalUrl    string           `position:"Query" name:"PortalUrl"`
	PortalStatus requests.Boolean `position:"Query" name:"PortalStatus"`
	Whitelist    string           `position:"Query" name:"Whitelist"`
	CheckUrl     string           `position:"Query" name:"CheckUrl"`
	ApConfigId   requests.Integer `position:"Query" name:"ApConfigId"`
	AuthSecret   string           `position:"Query" name:"AuthSecret"`
	WebAuthUrl   string           `position:"Query" name:"WebAuthUrl"`
	Network      requests.Integer `position:"Query" name:"Network"`
}

// SaveApPortalConfigResponse is the response struct for api SaveApPortalConfig
type SaveApPortalConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateSaveApPortalConfigRequest creates a request to invoke SaveApPortalConfig API
func CreateSaveApPortalConfigRequest() (request *SaveApPortalConfigRequest) {
	request = &SaveApPortalConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "SaveApPortalConfig", "cloudwf", "openAPI")
	return
}

// CreateSaveApPortalConfigResponse creates a response to parse from SaveApPortalConfig response
func CreateSaveApPortalConfigResponse() (response *SaveApPortalConfigResponse) {
	response = &SaveApPortalConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
