package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFile invokes the codeup.CreateFile API synchronously
func (client *Client) CreateFile(request *CreateFileRequest) (response *CreateFileResponse, err error) {
	response = CreateCreateFileResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFileWithChan invokes the codeup.CreateFile API asynchronously
func (client *Client) CreateFileWithChan(request *CreateFileRequest) (<-chan *CreateFileResponse, <-chan error) {
	responseChan := make(chan *CreateFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFileWithCallback invokes the codeup.CreateFile API asynchronously
func (client *Client) CreateFileWithCallback(request *CreateFileRequest, callback func(response *CreateFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFileResponse
		var err error
		defer close(result)
		response, err = client.CreateFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFileRequest is the request struct for api CreateFile
type CreateFileRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	SubUserId      string           `position:"Query" name:"SubUserId"`
	ClientToken    string           `position:"Query" name:"ClientToken"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// CreateFileResponse is the response struct for api CreateFile
type CreateFileResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateCreateFileRequest creates a request to invoke CreateFile API
func CreateCreateFileRequest() (request *CreateFileRequest) {
	request = &CreateFileRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "CreateFile", "/api/v3/projects/[ProjectId]/repository/files", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateFileResponse creates a response to parse from CreateFile response
func CreateCreateFileResponse() (response *CreateFileResponse) {
	response = &CreateFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
