package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRemediations invokes the config.ListRemediations API synchronously
func (client *Client) ListRemediations(request *ListRemediationsRequest) (response *ListRemediationsResponse, err error) {
	response = CreateListRemediationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListRemediationsWithChan invokes the config.ListRemediations API asynchronously
func (client *Client) ListRemediationsWithChan(request *ListRemediationsRequest) (<-chan *ListRemediationsResponse, <-chan error) {
	responseChan := make(chan *ListRemediationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRemediations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRemediationsWithCallback invokes the config.ListRemediations API asynchronously
func (client *Client) ListRemediationsWithCallback(request *ListRemediationsRequest, callback func(response *ListRemediationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRemediationsResponse
		var err error
		defer close(result)
		response, err = client.ListRemediations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRemediationsRequest is the request struct for api ListRemediations
type ListRemediationsRequest struct {
	*requests.RpcRequest
	ConfigRuleIds string `position:"Query" name:"ConfigRuleIds"`
}

// ListRemediationsResponse is the response struct for api ListRemediations
type ListRemediationsResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	Remediations []Remediation `json:"Remediations" xml:"Remediations"`
}

// CreateListRemediationsRequest creates a request to invoke ListRemediations API
func CreateListRemediationsRequest() (request *ListRemediationsRequest) {
	request = &ListRemediationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "ListRemediations", "", "")
	request.Method = requests.POST
	return
}

// CreateListRemediationsResponse creates a response to parse from ListRemediations response
func CreateListRemediationsResponse() (response *ListRemediationsResponse) {
	response = &ListRemediationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
