package csb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateServiceQPS invokes the csb.UpdateServiceQPS API synchronously
// api document: https://help.aliyun.com/api/csb/updateserviceqps.html
func (client *Client) UpdateServiceQPS(request *UpdateServiceQPSRequest) (response *UpdateServiceQPSResponse, err error) {
	response = CreateUpdateServiceQPSResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateServiceQPSWithChan invokes the csb.UpdateServiceQPS API asynchronously
// api document: https://help.aliyun.com/api/csb/updateserviceqps.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateServiceQPSWithChan(request *UpdateServiceQPSRequest) (<-chan *UpdateServiceQPSResponse, <-chan error) {
	responseChan := make(chan *UpdateServiceQPSResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateServiceQPS(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateServiceQPSWithCallback invokes the csb.UpdateServiceQPS API asynchronously
// api document: https://help.aliyun.com/api/csb/updateserviceqps.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateServiceQPSWithCallback(request *UpdateServiceQPSRequest, callback func(response *UpdateServiceQPSResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateServiceQPSResponse
		var err error
		defer close(result)
		response, err = client.UpdateServiceQPS(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateServiceQPSRequest is the request struct for api UpdateServiceQPS
type UpdateServiceQPSRequest struct {
	*requests.RpcRequest
	Qps       string           `position:"Query" name:"Qps"`
	ServiceId requests.Integer `position:"Query" name:"ServiceId"`
}

// UpdateServiceQPSResponse is the response struct for api UpdateServiceQPS
type UpdateServiceQPSResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateServiceQPSRequest creates a request to invoke UpdateServiceQPS API
func CreateUpdateServiceQPSRequest() (request *UpdateServiceQPSRequest) {
	request = &UpdateServiceQPSRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CSB", "2017-11-18", "UpdateServiceQPS", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateServiceQPSResponse creates a response to parse from UpdateServiceQPS response
func CreateUpdateServiceQPSResponse() (response *UpdateServiceQPSResponse) {
	response = &UpdateServiceQPSResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
