package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQualityFollower invokes the dataworks_public.GetQualityFollower API synchronously
func (client *Client) GetQualityFollower(request *GetQualityFollowerRequest) (response *GetQualityFollowerResponse, err error) {
	response = CreateGetQualityFollowerResponse()
	err = client.DoAction(request, response)
	return
}

// GetQualityFollowerWithChan invokes the dataworks_public.GetQualityFollower API asynchronously
func (client *Client) GetQualityFollowerWithChan(request *GetQualityFollowerRequest) (<-chan *GetQualityFollowerResponse, <-chan error) {
	responseChan := make(chan *GetQualityFollowerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQualityFollower(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQualityFollowerWithCallback invokes the dataworks_public.GetQualityFollower API asynchronously
func (client *Client) GetQualityFollowerWithCallback(request *GetQualityFollowerRequest, callback func(response *GetQualityFollowerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQualityFollowerResponse
		var err error
		defer close(result)
		response, err = client.GetQualityFollower(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQualityFollowerRequest is the request struct for api GetQualityFollower
type GetQualityFollowerRequest struct {
	*requests.RpcRequest
	ProjectName string           `position:"Body" name:"ProjectName"`
	EntityId    requests.Integer `position:"Body" name:"EntityId"`
}

// GetQualityFollowerResponse is the response struct for api GetQualityFollower
type GetQualityFollowerResponse struct {
	*responses.BaseResponse
	ErrorCode      string     `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool       `json:"Success" xml:"Success"`
	ErrorMessage   string     `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Data           []Follower `json:"Data" xml:"Data"`
}

// CreateGetQualityFollowerRequest creates a request to invoke GetQualityFollower API
func CreateGetQualityFollowerRequest() (request *GetQualityFollowerRequest) {
	request = &GetQualityFollowerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetQualityFollower", "", "")
	request.Method = requests.POST
	return
}

// CreateGetQualityFollowerResponse creates a response to parse from GetQualityFollower response
func CreateGetQualityFollowerResponse() (response *GetQualityFollowerResponse) {
	response = &GetQualityFollowerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
