package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ScanSensitiveData invokes the dataworks_public.ScanSensitiveData API synchronously
func (client *Client) ScanSensitiveData(request *ScanSensitiveDataRequest) (response *ScanSensitiveDataResponse, err error) {
	response = CreateScanSensitiveDataResponse()
	err = client.DoAction(request, response)
	return
}

// ScanSensitiveDataWithChan invokes the dataworks_public.ScanSensitiveData API asynchronously
func (client *Client) ScanSensitiveDataWithChan(request *ScanSensitiveDataRequest) (<-chan *ScanSensitiveDataResponse, <-chan error) {
	responseChan := make(chan *ScanSensitiveDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ScanSensitiveData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ScanSensitiveDataWithCallback invokes the dataworks_public.ScanSensitiveData API asynchronously
func (client *Client) ScanSensitiveDataWithCallback(request *ScanSensitiveDataRequest, callback func(response *ScanSensitiveDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ScanSensitiveDataResponse
		var err error
		defer close(result)
		response, err = client.ScanSensitiveData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ScanSensitiveDataRequest is the request struct for api ScanSensitiveData
type ScanSensitiveDataRequest struct {
	*requests.RpcRequest
	Data string `position:"Query" name:"Data"`
}

// ScanSensitiveDataResponse is the response struct for api ScanSensitiveData
type ScanSensitiveDataResponse struct {
	*responses.BaseResponse
	RequestId  string                 `json:"RequestId" xml:"RequestId"`
	Sensitives map[string]interface{} `json:"Sensitives" xml:"Sensitives"`
}

// CreateScanSensitiveDataRequest creates a request to invoke ScanSensitiveData API
func CreateScanSensitiveDataRequest() (request *ScanSensitiveDataRequest) {
	request = &ScanSensitiveDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ScanSensitiveData", "", "")
	request.Method = requests.GET
	return
}

// CreateScanSensitiveDataResponse creates a response to parse from ScanSensitiveData response
func CreateScanSensitiveDataResponse() (response *ScanSensitiveDataResponse) {
	response = &ScanSensitiveDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
