package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFlowProject invokes the emr.ListFlowProject API synchronously
func (client *Client) ListFlowProject(request *ListFlowProjectRequest) (response *ListFlowProjectResponse, err error) {
	response = CreateListFlowProjectResponse()
	err = client.DoAction(request, response)
	return
}

// ListFlowProjectWithChan invokes the emr.ListFlowProject API asynchronously
func (client *Client) ListFlowProjectWithChan(request *ListFlowProjectRequest) (<-chan *ListFlowProjectResponse, <-chan error) {
	responseChan := make(chan *ListFlowProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFlowProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFlowProjectWithCallback invokes the emr.ListFlowProject API asynchronously
func (client *Client) ListFlowProjectWithCallback(request *ListFlowProjectRequest, callback func(response *ListFlowProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFlowProjectResponse
		var err error
		defer close(result)
		response, err = client.ListFlowProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFlowProjectRequest is the request struct for api ListFlowProject
type ListFlowProjectRequest struct {
	*requests.RpcRequest
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ProductType     string           `position:"Query" name:"ProductType"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	Name            string           `position:"Query" name:"Name"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ProjectId       string           `position:"Query" name:"ProjectId"`
}

// ListFlowProjectResponse is the response struct for api ListFlowProject
type ListFlowProjectResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	PageNumber int      `json:"PageNumber" xml:"PageNumber"`
	PageSize   int      `json:"PageSize" xml:"PageSize"`
	Total      int      `json:"Total" xml:"Total"`
	Projects   Projects `json:"Projects" xml:"Projects"`
}

// CreateListFlowProjectRequest creates a request to invoke ListFlowProject API
func CreateListFlowProjectRequest() (request *ListFlowProjectRequest) {
	request = &ListFlowProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListFlowProject", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListFlowProjectResponse creates a response to parse from ListFlowProject response
func CreateListFlowProjectResponse() (response *ListFlowProjectResponse) {
	response = &ListFlowProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
