package faas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFpgaInstances invokes the faas.DescribeFpgaInstances API synchronously
// api document: https://help.aliyun.com/api/faas/describefpgainstances.html
func (client *Client) DescribeFpgaInstances(request *DescribeFpgaInstancesRequest) (response *DescribeFpgaInstancesResponse, err error) {
	response = CreateDescribeFpgaInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFpgaInstancesWithChan invokes the faas.DescribeFpgaInstances API asynchronously
// api document: https://help.aliyun.com/api/faas/describefpgainstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFpgaInstancesWithChan(request *DescribeFpgaInstancesRequest) (<-chan *DescribeFpgaInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeFpgaInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFpgaInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFpgaInstancesWithCallback invokes the faas.DescribeFpgaInstances API asynchronously
// api document: https://help.aliyun.com/api/faas/describefpgainstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFpgaInstancesWithCallback(request *DescribeFpgaInstancesRequest, callback func(response *DescribeFpgaInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFpgaInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeFpgaInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFpgaInstancesRequest is the request struct for api DescribeFpgaInstances
type DescribeFpgaInstancesRequest struct {
	*requests.RpcRequest
	InstanceId    string `position:"Query" name:"InstanceId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	RoleArn       string `position:"Query" name:"RoleArn"`
}

// DescribeFpgaInstancesResponse is the response struct for api DescribeFpgaInstances
type DescribeFpgaInstancesResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Instances Instances `json:"Instances" xml:"Instances"`
}

// CreateDescribeFpgaInstancesRequest creates a request to invoke DescribeFpgaInstances API
func CreateDescribeFpgaInstancesRequest() (request *DescribeFpgaInstancesRequest) {
	request = &DescribeFpgaInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("faas", "2017-08-24", "DescribeFpgaInstances", "faas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeFpgaInstancesResponse creates a response to parse from DescribeFpgaInstances response
func CreateDescribeFpgaInstancesResponse() (response *DescribeFpgaInstancesResponse) {
	response = &DescribeFpgaInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
