package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEndpointGroups invokes the ga.ListEndpointGroups API synchronously
func (client *Client) ListEndpointGroups(request *ListEndpointGroupsRequest) (response *ListEndpointGroupsResponse, err error) {
	response = CreateListEndpointGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListEndpointGroupsWithChan invokes the ga.ListEndpointGroups API asynchronously
func (client *Client) ListEndpointGroupsWithChan(request *ListEndpointGroupsRequest) (<-chan *ListEndpointGroupsResponse, <-chan error) {
	responseChan := make(chan *ListEndpointGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEndpointGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEndpointGroupsWithCallback invokes the ga.ListEndpointGroups API asynchronously
func (client *Client) ListEndpointGroupsWithCallback(request *ListEndpointGroupsRequest, callback func(response *ListEndpointGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEndpointGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListEndpointGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEndpointGroupsRequest is the request struct for api ListEndpointGroups
type ListEndpointGroupsRequest struct {
	*requests.RpcRequest
	PageNumber        requests.Integer `position:"Query" name:"PageNumber"`
	ListenerId        string           `position:"Query" name:"ListenerId"`
	EndpointGroupType string           `position:"Query" name:"EndpointGroupType"`
	AccessLogSwitch   string           `position:"Query" name:"AccessLogSwitch"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	AcceleratorId     string           `position:"Query" name:"AcceleratorId"`
	EndpointGroupId   string           `position:"Query" name:"EndpointGroupId"`
}

// ListEndpointGroupsResponse is the response struct for api ListEndpointGroups
type ListEndpointGroupsResponse struct {
	*responses.BaseResponse
	TotalCount     int                  `json:"TotalCount" xml:"TotalCount"`
	RequestId      string               `json:"RequestId" xml:"RequestId"`
	PageSize       int                  `json:"PageSize" xml:"PageSize"`
	PageNumber     int                  `json:"PageNumber" xml:"PageNumber"`
	EndpointGroups []EndpointGroupsItem `json:"EndpointGroups" xml:"EndpointGroups"`
}

// CreateListEndpointGroupsRequest creates a request to invoke ListEndpointGroups API
func CreateListEndpointGroupsRequest() (request *ListEndpointGroupsRequest) {
	request = &ListEndpointGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "ListEndpointGroups", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListEndpointGroupsResponse creates a response to parse from ListEndpointGroups response
func CreateListEndpointGroupsResponse() (response *ListEndpointGroupsResponse) {
	response = &ListEndpointGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
