package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TextAsyncManualScanResults invokes the green.TextAsyncManualScanResults API synchronously
func (client *Client) TextAsyncManualScanResults(request *TextAsyncManualScanResultsRequest) (response *TextAsyncManualScanResultsResponse, err error) {
	response = CreateTextAsyncManualScanResultsResponse()
	err = client.DoAction(request, response)
	return
}

// TextAsyncManualScanResultsWithChan invokes the green.TextAsyncManualScanResults API asynchronously
func (client *Client) TextAsyncManualScanResultsWithChan(request *TextAsyncManualScanResultsRequest) (<-chan *TextAsyncManualScanResultsResponse, <-chan error) {
	responseChan := make(chan *TextAsyncManualScanResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TextAsyncManualScanResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TextAsyncManualScanResultsWithCallback invokes the green.TextAsyncManualScanResults API asynchronously
func (client *Client) TextAsyncManualScanResultsWithCallback(request *TextAsyncManualScanResultsRequest, callback func(response *TextAsyncManualScanResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TextAsyncManualScanResultsResponse
		var err error
		defer close(result)
		response, err = client.TextAsyncManualScanResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TextAsyncManualScanResultsRequest is the request struct for api TextAsyncManualScanResults
type TextAsyncManualScanResultsRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// TextAsyncManualScanResultsResponse is the response struct for api TextAsyncManualScanResults
type TextAsyncManualScanResultsResponse struct {
	*responses.BaseResponse
}

// CreateTextAsyncManualScanResultsRequest creates a request to invoke TextAsyncManualScanResults API
func CreateTextAsyncManualScanResultsRequest() (request *TextAsyncManualScanResultsRequest) {
	request = &TextAsyncManualScanResultsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "TextAsyncManualScanResults", "/green/text/manual/scan/results", "", "")
	request.Method = requests.POST
	return
}

// CreateTextAsyncManualScanResultsResponse creates a response to parse from TextAsyncManualScanResults response
func CreateTextAsyncManualScanResultsResponse() (response *TextAsyncManualScanResultsResponse) {
	response = &TextAsyncManualScanResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
