package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDetection invokes the idrsservice.GetDetection API synchronously
func (client *Client) GetDetection(request *GetDetectionRequest) (response *GetDetectionResponse, err error) {
	response = CreateGetDetectionResponse()
	err = client.DoAction(request, response)
	return
}

// GetDetectionWithChan invokes the idrsservice.GetDetection API asynchronously
func (client *Client) GetDetectionWithChan(request *GetDetectionRequest) (<-chan *GetDetectionResponse, <-chan error) {
	responseChan := make(chan *GetDetectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDetection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDetectionWithCallback invokes the idrsservice.GetDetection API asynchronously
func (client *Client) GetDetectionWithCallback(request *GetDetectionRequest, callback func(response *GetDetectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDetectionResponse
		var err error
		defer close(result)
		response, err = client.GetDetection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDetectionRequest is the request struct for api GetDetection
type GetDetectionRequest struct {
	*requests.RpcRequest
	Id string `position:"Query" name:"Id"`
}

// GetDetectionResponse is the response struct for api GetDetection
type GetDetectionResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetDetectionRequest creates a request to invoke GetDetection API
func CreateGetDetectionRequest() (request *GetDetectionRequest) {
	request = &GetDetectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "GetDetection", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDetectionResponse creates a response to parse from GetDetection response
func CreateGetDetectionResponse() (response *GetDetectionResponse) {
	response = &GetDetectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
