package ivpd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EraseLogoInVideo invokes the ivpd.EraseLogoInVideo API synchronously
// api document: https://help.aliyun.com/api/ivpd/eraselogoinvideo.html
func (client *Client) EraseLogoInVideo(request *EraseLogoInVideoRequest) (response *EraseLogoInVideoResponse, err error) {
	response = CreateEraseLogoInVideoResponse()
	err = client.DoAction(request, response)
	return
}

// EraseLogoInVideoWithChan invokes the ivpd.EraseLogoInVideo API asynchronously
// api document: https://help.aliyun.com/api/ivpd/eraselogoinvideo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EraseLogoInVideoWithChan(request *EraseLogoInVideoRequest) (<-chan *EraseLogoInVideoResponse, <-chan error) {
	responseChan := make(chan *EraseLogoInVideoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EraseLogoInVideo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EraseLogoInVideoWithCallback invokes the ivpd.EraseLogoInVideo API asynchronously
// api document: https://help.aliyun.com/api/ivpd/eraselogoinvideo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EraseLogoInVideoWithCallback(request *EraseLogoInVideoRequest, callback func(response *EraseLogoInVideoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EraseLogoInVideoResponse
		var err error
		defer close(result)
		response, err = client.EraseLogoInVideo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EraseLogoInVideoRequest is the request struct for api EraseLogoInVideo
type EraseLogoInVideoRequest struct {
	*requests.RpcRequest
	Boxes    *[]EraseLogoInVideoBoxes `position:"Body" name:"Boxes"  type:"Repeated"`
	Async    requests.Boolean         `position:"Body" name:"Async"`
	JobId    string                   `position:"Body" name:"JobId"`
	VideoUrl string                   `position:"Body" name:"VideoUrl"`
}

// EraseLogoInVideoBoxes is a repeated param struct in EraseLogoInVideoRequest
type EraseLogoInVideoBoxes struct {
	W string `name:"W"`
	H string `name:"H"`
	X string `name:"X"`
	Y string `name:"Y"`
}

// EraseLogoInVideoResponse is the response struct for api EraseLogoInVideo
type EraseLogoInVideoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateEraseLogoInVideoRequest creates a request to invoke EraseLogoInVideo API
func CreateEraseLogoInVideoRequest() (request *EraseLogoInVideoRequest) {
	request = &EraseLogoInVideoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivpd", "2019-06-25", "EraseLogoInVideo", "ivpd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEraseLogoInVideoResponse creates a response to parse from EraseLogoInVideo response
func CreateEraseLogoInVideoResponse() (response *EraseLogoInVideoResponse) {
	response = &EraseLogoInVideoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
