package jarvis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeResetRecordQueryCount invokes the jarvis.DescribeResetRecordQueryCount API synchronously
// api document: https://help.aliyun.com/api/jarvis/describeresetrecordquerycount.html
func (client *Client) DescribeResetRecordQueryCount(request *DescribeResetRecordQueryCountRequest) (response *DescribeResetRecordQueryCountResponse, err error) {
	response = CreateDescribeResetRecordQueryCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeResetRecordQueryCountWithChan invokes the jarvis.DescribeResetRecordQueryCount API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describeresetrecordquerycount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeResetRecordQueryCountWithChan(request *DescribeResetRecordQueryCountRequest) (<-chan *DescribeResetRecordQueryCountResponse, <-chan error) {
	responseChan := make(chan *DescribeResetRecordQueryCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeResetRecordQueryCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeResetRecordQueryCountWithCallback invokes the jarvis.DescribeResetRecordQueryCount API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describeresetrecordquerycount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeResetRecordQueryCountWithCallback(request *DescribeResetRecordQueryCountRequest, callback func(response *DescribeResetRecordQueryCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeResetRecordQueryCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeResetRecordQueryCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeResetRecordQueryCountRequest is the request struct for api DescribeResetRecordQueryCount
type DescribeResetRecordQueryCountRequest struct {
	*requests.RpcRequest
	SourceIp   string `position:"Query" name:"SourceIp"`
	Lang       string `position:"Query" name:"Lang"`
	SourceCode string `position:"Query" name:"SourceCode"`
}

// DescribeResetRecordQueryCountResponse is the response struct for api DescribeResetRecordQueryCount
type DescribeResetRecordQueryCountResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	QueryCount int    `json:"QueryCount" xml:"QueryCount"`
	Module     string `json:"Module" xml:"Module"`
}

// CreateDescribeResetRecordQueryCountRequest creates a request to invoke DescribeResetRecordQueryCount API
func CreateDescribeResetRecordQueryCountRequest() (request *DescribeResetRecordQueryCountRequest) {
	request = &DescribeResetRecordQueryCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis", "2018-02-06", "DescribeResetRecordQueryCount", "jarvis", "openAPI")
	return
}

// CreateDescribeResetRecordQueryCountResponse creates a response to parse from DescribeResetRecordQueryCount response
func CreateDescribeResetRecordQueryCountResponse() (response *DescribeResetRecordQueryCountResponse) {
	response = &DescribeResetRecordQueryCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
