package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMcuTemplate invokes the mts.UpdateMcuTemplate API synchronously
func (client *Client) UpdateMcuTemplate(request *UpdateMcuTemplateRequest) (response *UpdateMcuTemplateResponse, err error) {
	response = CreateUpdateMcuTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMcuTemplateWithChan invokes the mts.UpdateMcuTemplate API asynchronously
func (client *Client) UpdateMcuTemplateWithChan(request *UpdateMcuTemplateRequest) (<-chan *UpdateMcuTemplateResponse, <-chan error) {
	responseChan := make(chan *UpdateMcuTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMcuTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMcuTemplateWithCallback invokes the mts.UpdateMcuTemplate API asynchronously
func (client *Client) UpdateMcuTemplateWithCallback(request *UpdateMcuTemplateRequest, callback func(response *UpdateMcuTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMcuTemplateResponse
		var err error
		defer close(result)
		response, err = client.UpdateMcuTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMcuTemplateRequest is the request struct for api UpdateMcuTemplate
type UpdateMcuTemplateRequest struct {
	*requests.RpcRequest
	Template             string           `position:"Query" name:"Template"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId           string           `position:"Query" name:"TemplateId"`
}

// UpdateMcuTemplateResponse is the response struct for api UpdateMcuTemplate
type UpdateMcuTemplateResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TemplateId string `json:"TemplateId" xml:"TemplateId"`
}

// CreateUpdateMcuTemplateRequest creates a request to invoke UpdateMcuTemplate API
func CreateUpdateMcuTemplateRequest() (request *UpdateMcuTemplateRequest) {
	request = &UpdateMcuTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "UpdateMcuTemplate", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateMcuTemplateResponse creates a response to parse from UpdateMcuTemplate response
func CreateUpdateMcuTemplateResponse() (response *UpdateMcuTemplateResponse) {
	response = &UpdateMcuTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
