package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMediaWorkflowTriggerMode invokes the mts.UpdateMediaWorkflowTriggerMode API synchronously
func (client *Client) UpdateMediaWorkflowTriggerMode(request *UpdateMediaWorkflowTriggerModeRequest) (response *UpdateMediaWorkflowTriggerModeResponse, err error) {
	response = CreateUpdateMediaWorkflowTriggerModeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMediaWorkflowTriggerModeWithChan invokes the mts.UpdateMediaWorkflowTriggerMode API asynchronously
func (client *Client) UpdateMediaWorkflowTriggerModeWithChan(request *UpdateMediaWorkflowTriggerModeRequest) (<-chan *UpdateMediaWorkflowTriggerModeResponse, <-chan error) {
	responseChan := make(chan *UpdateMediaWorkflowTriggerModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMediaWorkflowTriggerMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMediaWorkflowTriggerModeWithCallback invokes the mts.UpdateMediaWorkflowTriggerMode API asynchronously
func (client *Client) UpdateMediaWorkflowTriggerModeWithCallback(request *UpdateMediaWorkflowTriggerModeRequest, callback func(response *UpdateMediaWorkflowTriggerModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMediaWorkflowTriggerModeResponse
		var err error
		defer close(result)
		response, err = client.UpdateMediaWorkflowTriggerMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMediaWorkflowTriggerModeRequest is the request struct for api UpdateMediaWorkflowTriggerMode
type UpdateMediaWorkflowTriggerModeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	MediaWorkflowId      string           `position:"Query" name:"MediaWorkflowId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TriggerMode          string           `position:"Query" name:"TriggerMode"`
}

// UpdateMediaWorkflowTriggerModeResponse is the response struct for api UpdateMediaWorkflowTriggerMode
type UpdateMediaWorkflowTriggerModeResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	MediaWorkflow MediaWorkflow `json:"MediaWorkflow" xml:"MediaWorkflow"`
}

// CreateUpdateMediaWorkflowTriggerModeRequest creates a request to invoke UpdateMediaWorkflowTriggerMode API
func CreateUpdateMediaWorkflowTriggerModeRequest() (request *UpdateMediaWorkflowTriggerModeRequest) {
	request = &UpdateMediaWorkflowTriggerModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "UpdateMediaWorkflowTriggerMode", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateMediaWorkflowTriggerModeResponse creates a response to parse from UpdateMediaWorkflowTriggerMode response
func CreateUpdateMediaWorkflowTriggerModeResponse() (response *UpdateMediaWorkflowTriggerModeResponse) {
	response = &UpdateMediaWorkflowTriggerModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
