package ons

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OnsDLQMessagePageQueryByGroupId invokes the ons.OnsDLQMessagePageQueryByGroupId API synchronously
func (client *Client) OnsDLQMessagePageQueryByGroupId(request *OnsDLQMessagePageQueryByGroupIdRequest) (response *OnsDLQMessagePageQueryByGroupIdResponse, err error) {
	response = CreateOnsDLQMessagePageQueryByGroupIdResponse()
	err = client.DoAction(request, response)
	return
}

// OnsDLQMessagePageQueryByGroupIdWithChan invokes the ons.OnsDLQMessagePageQueryByGroupId API asynchronously
func (client *Client) OnsDLQMessagePageQueryByGroupIdWithChan(request *OnsDLQMessagePageQueryByGroupIdRequest) (<-chan *OnsDLQMessagePageQueryByGroupIdResponse, <-chan error) {
	responseChan := make(chan *OnsDLQMessagePageQueryByGroupIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OnsDLQMessagePageQueryByGroupId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OnsDLQMessagePageQueryByGroupIdWithCallback invokes the ons.OnsDLQMessagePageQueryByGroupId API asynchronously
func (client *Client) OnsDLQMessagePageQueryByGroupIdWithCallback(request *OnsDLQMessagePageQueryByGroupIdRequest, callback func(response *OnsDLQMessagePageQueryByGroupIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OnsDLQMessagePageQueryByGroupIdResponse
		var err error
		defer close(result)
		response, err = client.OnsDLQMessagePageQueryByGroupId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OnsDLQMessagePageQueryByGroupIdRequest is the request struct for api OnsDLQMessagePageQueryByGroupId
type OnsDLQMessagePageQueryByGroupIdRequest struct {
	*requests.RpcRequest
	GroupId     string           `position:"Query" name:"GroupId"`
	EndTime     requests.Integer `position:"Query" name:"EndTime"`
	BeginTime   requests.Integer `position:"Query" name:"BeginTime"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	InstanceId  string           `position:"Query" name:"InstanceId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	TaskId      string           `position:"Query" name:"TaskId"`
}

// OnsDLQMessagePageQueryByGroupIdResponse is the response struct for api OnsDLQMessagePageQueryByGroupId
type OnsDLQMessagePageQueryByGroupIdResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	HelpUrl    string     `json:"HelpUrl" xml:"HelpUrl"`
	MsgFoundDo MsgFoundDo `json:"MsgFoundDo" xml:"MsgFoundDo"`
}

// CreateOnsDLQMessagePageQueryByGroupIdRequest creates a request to invoke OnsDLQMessagePageQueryByGroupId API
func CreateOnsDLQMessagePageQueryByGroupIdRequest() (request *OnsDLQMessagePageQueryByGroupIdRequest) {
	request = &OnsDLQMessagePageQueryByGroupIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ons", "2019-02-14", "OnsDLQMessagePageQueryByGroupId", "ons", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOnsDLQMessagePageQueryByGroupIdResponse creates a response to parse from OnsDLQMessagePageQueryByGroupId response
func CreateOnsDLQMessagePageQueryByGroupIdResponse() (response *OnsDLQMessagePageQueryByGroupIdResponse) {
	response = &OnsDLQMessagePageQueryByGroupIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
