package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPartition invokes the openanalytics_open.GetPartition API synchronously
func (client *Client) GetPartition(request *GetPartitionRequest) (response *GetPartitionResponse, err error) {
	response = CreateGetPartitionResponse()
	err = client.DoAction(request, response)
	return
}

// GetPartitionWithChan invokes the openanalytics_open.GetPartition API asynchronously
func (client *Client) GetPartitionWithChan(request *GetPartitionRequest) (<-chan *GetPartitionResponse, <-chan error) {
	responseChan := make(chan *GetPartitionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPartition(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPartitionWithCallback invokes the openanalytics_open.GetPartition API asynchronously
func (client *Client) GetPartitionWithCallback(request *GetPartitionRequest, callback func(response *GetPartitionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPartitionResponse
		var err error
		defer close(result)
		response, err = client.GetPartition(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPartitionRequest is the request struct for api GetPartition
type GetPartitionRequest struct {
	*requests.RpcRequest
	DbName    string `position:"Query" name:"DbName"`
	Values    string `position:"Query" name:"Values"`
	TableName string `position:"Query" name:"TableName"`
}

// GetPartitionResponse is the response struct for api GetPartition
type GetPartitionResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Message        string         `json:"Message" xml:"Message"`
	Code           string         `json:"Code" xml:"Code"`
	Success        bool           `json:"Success" xml:"Success"`
	PartitionModel PartitionModel `json:"PartitionModel" xml:"PartitionModel"`
}

// CreateGetPartitionRequest creates a request to invoke GetPartition API
func CreateGetPartitionRequest() (request *GetPartitionRequest) {
	request = &GetPartitionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2020-09-28", "GetPartition", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetPartitionResponse creates a response to parse from GetPartition response
func CreateGetPartitionResponse() (response *GetPartitionResponse) {
	response = &GetPartitionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
