package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeResolverRules invokes the pvtz.DescribeResolverRules API synchronously
func (client *Client) DescribeResolverRules(request *DescribeResolverRulesRequest) (response *DescribeResolverRulesResponse, err error) {
	response = CreateDescribeResolverRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeResolverRulesWithChan invokes the pvtz.DescribeResolverRules API asynchronously
func (client *Client) DescribeResolverRulesWithChan(request *DescribeResolverRulesRequest) (<-chan *DescribeResolverRulesResponse, <-chan error) {
	responseChan := make(chan *DescribeResolverRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeResolverRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeResolverRulesWithCallback invokes the pvtz.DescribeResolverRules API asynchronously
func (client *Client) DescribeResolverRulesWithCallback(request *DescribeResolverRulesRequest, callback func(response *DescribeResolverRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeResolverRulesResponse
		var err error
		defer close(result)
		response, err = client.DescribeResolverRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeResolverRulesRequest is the request struct for api DescribeResolverRules
type DescribeResolverRulesRequest struct {
	*requests.RpcRequest
	EndpointId           string           `position:"Query" name:"EndpointId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	UserClientIp         string           `position:"Query" name:"UserClientIp"`
	Keyword              string           `position:"Query" name:"Keyword"`
	Lang                 string           `position:"Query" name:"Lang"`
	NeedDetailAttributes requests.Boolean `position:"Query" name:"NeedDetailAttributes"`
}

// DescribeResolverRulesResponse is the response struct for api DescribeResolverRules
type DescribeResolverRulesResponse struct {
	*responses.BaseResponse
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	TotalPages int    `json:"TotalPages" xml:"TotalPages"`
	TotalItems int    `json:"TotalItems" xml:"TotalItems"`
	Rules      []Rule `json:"Rules" xml:"Rules"`
}

// CreateDescribeResolverRulesRequest creates a request to invoke DescribeResolverRules API
func CreateDescribeResolverRulesRequest() (request *DescribeResolverRulesRequest) {
	request = &DescribeResolverRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "DescribeResolverRules", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeResolverRulesResponse creates a response to parse from DescribeResolverRules response
func CreateDescribeResolverRulesResponse() (response *DescribeResolverRulesResponse) {
	response = &DescribeResolverRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
