package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDedicatedInstance invokes the r_kvstore.CreateDedicatedInstance API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/creatededicatedinstance.html
func (client *Client) CreateDedicatedInstance(request *CreateDedicatedInstanceRequest) (response *CreateDedicatedInstanceResponse, err error) {
	response = CreateCreateDedicatedInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDedicatedInstanceWithChan invokes the r_kvstore.CreateDedicatedInstance API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/creatededicatedinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDedicatedInstanceWithChan(request *CreateDedicatedInstanceRequest) (<-chan *CreateDedicatedInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateDedicatedInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDedicatedInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDedicatedInstanceWithCallback invokes the r_kvstore.CreateDedicatedInstance API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/creatededicatedinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDedicatedInstanceWithCallback(request *CreateDedicatedInstanceRequest, callback func(response *CreateDedicatedInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDedicatedInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateDedicatedInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDedicatedInstanceRequest is the request struct for api CreateDedicatedInstance
type CreateDedicatedInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NodeType             string           `position:"Query" name:"NodeType"`
	NetworkType          string           `position:"Query" name:"NetworkType"`
	EngineVersion        string           `position:"Query" name:"EngineVersion"`
	InstanceClass        string           `position:"Query" name:"InstanceClass"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	Password             string           `position:"Query" name:"Password"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	InstanceType         string           `position:"Query" name:"InstanceType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	SrcDBInstanceId      string           `position:"Query" name:"SrcDBInstanceId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	BackupId             string           `position:"Query" name:"BackupId"`
	ClusterId            string           `position:"Query" name:"ClusterId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	VSwitchId            string           `position:"Query" name:"VSwitchId"`
	PrivateIpAddress     string           `position:"Query" name:"PrivateIpAddress"`
	InstanceName         string           `position:"Query" name:"InstanceName"`
	VpcId                string           `position:"Query" name:"VpcId"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
	Config               string           `position:"Query" name:"Config"`
}

// CreateDedicatedInstanceResponse is the response struct for api CreateDedicatedInstance
type CreateDedicatedInstanceResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	InstanceId       string `json:"InstanceId" xml:"InstanceId"`
	InstanceName     string `json:"InstanceName" xml:"InstanceName"`
	ConnectionDomain string `json:"ConnectionDomain" xml:"ConnectionDomain"`
	Port             int    `json:"Port" xml:"Port"`
	UserName         string `json:"UserName" xml:"UserName"`
	InstanceStatus   string `json:"InstanceStatus" xml:"InstanceStatus"`
	RegionId         string `json:"RegionId" xml:"RegionId"`
	Capacity         bool   `json:"Capacity" xml:"Capacity"`
	QPS              string `json:"QPS" xml:"QPS"`
	Bandwidth        int    `json:"Bandwidth" xml:"Bandwidth"`
	Connections      int    `json:"Connections" xml:"Connections"`
	ZoneId           bool   `json:"ZoneId" xml:"ZoneId"`
	Config           string `json:"Config" xml:"Config"`
	NodeType         string `json:"NodeType" xml:"NodeType"`
	NetworkType      string `json:"NetworkType" xml:"NetworkType"`
	VpcId            string `json:"VpcId" xml:"VpcId"`
	VSwitchId        string `json:"VSwitchId" xml:"VSwitchId"`
	PrivateIpAddr    string `json:"PrivateIpAddr" xml:"PrivateIpAddr"`
}

// CreateCreateDedicatedInstanceRequest creates a request to invoke CreateDedicatedInstance API
func CreateCreateDedicatedInstanceRequest() (request *CreateDedicatedInstanceRequest) {
	request = &CreateDedicatedInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "CreateDedicatedInstance", "redisa", "openAPI")
	return
}

// CreateCreateDedicatedInstanceResponse creates a response to parse from CreateDedicatedInstance response
func CreateCreateDedicatedInstanceResponse() (response *CreateDedicatedInstanceResponse) {
	response = &CreateDedicatedInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
