package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCluster invokes the retailcloud.ListCluster API synchronously
func (client *Client) ListCluster(request *ListClusterRequest) (response *ListClusterResponse, err error) {
	response = CreateListClusterResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterWithChan invokes the retailcloud.ListCluster API asynchronously
func (client *Client) ListClusterWithChan(request *ListClusterRequest) (<-chan *ListClusterResponse, <-chan error) {
	responseChan := make(chan *ListClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterWithCallback invokes the retailcloud.ListCluster API asynchronously
func (client *Client) ListClusterWithCallback(request *ListClusterRequest, callback func(response *ListClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterResponse
		var err error
		defer close(result)
		response, err = client.ListCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterRequest is the request struct for api ListCluster
type ListClusterRequest struct {
	*requests.RpcRequest
	BusinessCode string           `position:"Query" name:"BusinessCode"`
	EnvType      string           `position:"Query" name:"EnvType"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	PageNum      requests.Integer `position:"Query" name:"PageNum"`
}

// ListClusterResponse is the response struct for api ListCluster
type ListClusterResponse struct {
	*responses.BaseResponse
	Code       int           `json:"Code" xml:"Code"`
	ErrorMsg   string        `json:"ErrorMsg" xml:"ErrorMsg"`
	PageNumber int           `json:"PageNumber" xml:"PageNumber"`
	PageSize   int           `json:"PageSize" xml:"PageSize"`
	RequestId  string        `json:"RequestId" xml:"RequestId"`
	TotalCount int64         `json:"TotalCount" xml:"TotalCount"`
	Data       []ClusterInfo `json:"Data" xml:"Data"`
}

// CreateListClusterRequest creates a request to invoke ListCluster API
func CreateListClusterRequest() (request *ListClusterRequest) {
	request = &ListClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "ListCluster", "", "")
	request.Method = requests.GET
	return
}

// CreateListClusterResponse creates a response to parse from ListCluster response
func CreateListClusterResponse() (response *ListClusterResponse) {
	response = &ListClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
