package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLoginBaseConfig invokes the sas.DeleteLoginBaseConfig API synchronously
func (client *Client) DeleteLoginBaseConfig(request *DeleteLoginBaseConfigRequest) (response *DeleteLoginBaseConfigResponse, err error) {
	response = CreateDeleteLoginBaseConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLoginBaseConfigWithChan invokes the sas.DeleteLoginBaseConfig API asynchronously
func (client *Client) DeleteLoginBaseConfigWithChan(request *DeleteLoginBaseConfigRequest) (<-chan *DeleteLoginBaseConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteLoginBaseConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLoginBaseConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLoginBaseConfigWithCallback invokes the sas.DeleteLoginBaseConfig API asynchronously
func (client *Client) DeleteLoginBaseConfigWithCallback(request *DeleteLoginBaseConfigRequest, callback func(response *DeleteLoginBaseConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLoginBaseConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteLoginBaseConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLoginBaseConfigRequest is the request struct for api DeleteLoginBaseConfig
type DeleteLoginBaseConfigRequest struct {
	*requests.RpcRequest
	Type     string `position:"Query" name:"Type"`
	Target   string `position:"Query" name:"Target"`
	SourceIp string `position:"Query" name:"SourceIp"`
	Config   string `position:"Query" name:"Config"`
}

// DeleteLoginBaseConfigResponse is the response struct for api DeleteLoginBaseConfig
type DeleteLoginBaseConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLoginBaseConfigRequest creates a request to invoke DeleteLoginBaseConfig API
func CreateDeleteLoginBaseConfigRequest() (request *DeleteLoginBaseConfigRequest) {
	request = &DeleteLoginBaseConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DeleteLoginBaseConfig", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLoginBaseConfigResponse creates a response to parse from DeleteLoginBaseConfig response
func CreateDeleteLoginBaseConfigResponse() (response *DeleteLoginBaseConfigResponse) {
	response = &DeleteLoginBaseConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
