package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnRefreshTasks invokes the scdn.DescribeScdnRefreshTasks API synchronously
func (client *Client) DescribeScdnRefreshTasks(request *DescribeScdnRefreshTasksRequest) (response *DescribeScdnRefreshTasksResponse, err error) {
	response = CreateDescribeScdnRefreshTasksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnRefreshTasksWithChan invokes the scdn.DescribeScdnRefreshTasks API asynchronously
func (client *Client) DescribeScdnRefreshTasksWithChan(request *DescribeScdnRefreshTasksRequest) (<-chan *DescribeScdnRefreshTasksResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnRefreshTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnRefreshTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnRefreshTasksWithCallback invokes the scdn.DescribeScdnRefreshTasks API asynchronously
func (client *Client) DescribeScdnRefreshTasksWithCallback(request *DescribeScdnRefreshTasksRequest, callback func(response *DescribeScdnRefreshTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnRefreshTasksResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnRefreshTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnRefreshTasksRequest is the request struct for api DescribeScdnRefreshTasks
type DescribeScdnRefreshTasksRequest struct {
	*requests.RpcRequest
	ObjectPath      string           `position:"Query" name:"ObjectPath"`
	StartTime       string           `position:"Query" name:"StartTime"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SecurityToken   string           `position:"Query" name:"SecurityToken"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ObjectType      string           `position:"Query" name:"ObjectType"`
	TaskId          string           `position:"Query" name:"TaskId"`
	DomainName      string           `position:"Query" name:"DomainName"`
	EndTime         string           `position:"Query" name:"EndTime"`
	OwnerId         requests.Integer `position:"Query" name:"OwnerId"`
	Status          string           `position:"Query" name:"Status"`
}

// DescribeScdnRefreshTasksResponse is the response struct for api DescribeScdnRefreshTasks
type DescribeScdnRefreshTasksResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	PageNumber int64  `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64  `json:"PageSize" xml:"PageSize"`
	TotalCount int64  `json:"TotalCount" xml:"TotalCount"`
	Tasks      Tasks  `json:"Tasks" xml:"Tasks"`
}

// CreateDescribeScdnRefreshTasksRequest creates a request to invoke DescribeScdnRefreshTasks API
func CreateDescribeScdnRefreshTasksRequest() (request *DescribeScdnRefreshTasksRequest) {
	request = &DescribeScdnRefreshTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnRefreshTasks", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeScdnRefreshTasksResponse creates a response to parse from DescribeScdnRefreshTasks response
func CreateDescribeScdnRefreshTasksResponse() (response *DescribeScdnRefreshTasksResponse) {
	response = &DescribeScdnRefreshTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
