package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckBlockVolumeName invokes the sgw.CheckBlockVolumeName API synchronously
func (client *Client) CheckBlockVolumeName(request *CheckBlockVolumeNameRequest) (response *CheckBlockVolumeNameResponse, err error) {
	response = CreateCheckBlockVolumeNameResponse()
	err = client.DoAction(request, response)
	return
}

// CheckBlockVolumeNameWithChan invokes the sgw.CheckBlockVolumeName API asynchronously
func (client *Client) CheckBlockVolumeNameWithChan(request *CheckBlockVolumeNameRequest) (<-chan *CheckBlockVolumeNameResponse, <-chan error) {
	responseChan := make(chan *CheckBlockVolumeNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckBlockVolumeName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckBlockVolumeNameWithCallback invokes the sgw.CheckBlockVolumeName API asynchronously
func (client *Client) CheckBlockVolumeNameWithCallback(request *CheckBlockVolumeNameRequest, callback func(response *CheckBlockVolumeNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckBlockVolumeNameResponse
		var err error
		defer close(result)
		response, err = client.CheckBlockVolumeName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckBlockVolumeNameRequest is the request struct for api CheckBlockVolumeName
type CheckBlockVolumeNameRequest struct {
	*requests.RpcRequest
	VolumeName     string `position:"Query" name:"VolumeName"`
	BucketEndpoint string `position:"Query" name:"BucketEndpoint"`
	SecurityToken  string `position:"Query" name:"SecurityToken"`
	BucketName     string `position:"Query" name:"BucketName"`
}

// CheckBlockVolumeNameResponse is the response struct for api CheckBlockVolumeName
type CheckBlockVolumeNameResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	Success           bool   `json:"Success" xml:"Success"`
	Code              string `json:"Code" xml:"Code"`
	Message           string `json:"Message" xml:"Message"`
	IsRequireRecovery string `json:"IsRequireRecovery" xml:"IsRequireRecovery"`
}

// CreateCheckBlockVolumeNameRequest creates a request to invoke CheckBlockVolumeName API
func CreateCheckBlockVolumeNameRequest() (request *CheckBlockVolumeNameRequest) {
	request = &CheckBlockVolumeNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "CheckBlockVolumeName", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckBlockVolumeNameResponse creates a response to parse from CheckBlockVolumeName response
func CreateCheckBlockVolumeNameResponse() (response *CheckBlockVolumeNameResponse) {
	response = &CheckBlockVolumeNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
