package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetGatewayPassword invokes the sgw.ResetGatewayPassword API synchronously
func (client *Client) ResetGatewayPassword(request *ResetGatewayPasswordRequest) (response *ResetGatewayPasswordResponse, err error) {
	response = CreateResetGatewayPasswordResponse()
	err = client.DoAction(request, response)
	return
}

// ResetGatewayPasswordWithChan invokes the sgw.ResetGatewayPassword API asynchronously
func (client *Client) ResetGatewayPasswordWithChan(request *ResetGatewayPasswordRequest) (<-chan *ResetGatewayPasswordResponse, <-chan error) {
	responseChan := make(chan *ResetGatewayPasswordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetGatewayPassword(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetGatewayPasswordWithCallback invokes the sgw.ResetGatewayPassword API asynchronously
func (client *Client) ResetGatewayPasswordWithCallback(request *ResetGatewayPasswordRequest, callback func(response *ResetGatewayPasswordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetGatewayPasswordResponse
		var err error
		defer close(result)
		response, err = client.ResetGatewayPassword(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetGatewayPasswordRequest is the request struct for api ResetGatewayPassword
type ResetGatewayPasswordRequest struct {
	*requests.RpcRequest
	Password      string `position:"Query" name:"Password"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
	Username      string `position:"Query" name:"Username"`
}

// ResetGatewayPasswordResponse is the response struct for api ResetGatewayPassword
type ResetGatewayPasswordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateResetGatewayPasswordRequest creates a request to invoke ResetGatewayPassword API
func CreateResetGatewayPasswordRequest() (request *ResetGatewayPasswordRequest) {
	request = &ResetGatewayPasswordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "ResetGatewayPassword", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateResetGatewayPasswordResponse creates a response to parse from ResetGatewayPassword response
func CreateResetGatewayPasswordResponse() (response *ResetGatewayPasswordResponse) {
	response = &ResetGatewayPasswordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
