package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCloudConnectNetworkUseLimit invokes the smartag.GetCloudConnectNetworkUseLimit API synchronously
func (client *Client) GetCloudConnectNetworkUseLimit(request *GetCloudConnectNetworkUseLimitRequest) (response *GetCloudConnectNetworkUseLimitResponse, err error) {
	response = CreateGetCloudConnectNetworkUseLimitResponse()
	err = client.DoAction(request, response)
	return
}

// GetCloudConnectNetworkUseLimitWithChan invokes the smartag.GetCloudConnectNetworkUseLimit API asynchronously
func (client *Client) GetCloudConnectNetworkUseLimitWithChan(request *GetCloudConnectNetworkUseLimitRequest) (<-chan *GetCloudConnectNetworkUseLimitResponse, <-chan error) {
	responseChan := make(chan *GetCloudConnectNetworkUseLimitResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCloudConnectNetworkUseLimit(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCloudConnectNetworkUseLimitWithCallback invokes the smartag.GetCloudConnectNetworkUseLimit API asynchronously
func (client *Client) GetCloudConnectNetworkUseLimitWithCallback(request *GetCloudConnectNetworkUseLimitRequest, callback func(response *GetCloudConnectNetworkUseLimitResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCloudConnectNetworkUseLimitResponse
		var err error
		defer close(result)
		response, err = client.GetCloudConnectNetworkUseLimit(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCloudConnectNetworkUseLimitRequest is the request struct for api GetCloudConnectNetworkUseLimit
type GetCloudConnectNetworkUseLimitRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// GetCloudConnectNetworkUseLimitResponse is the response struct for api GetCloudConnectNetworkUseLimit
type GetCloudConnectNetworkUseLimitResponse struct {
	*responses.BaseResponse
	UsedAmount  int    `json:"UsedAmount" xml:"UsedAmount"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	TotalAmount int    `json:"TotalAmount" xml:"TotalAmount"`
}

// CreateGetCloudConnectNetworkUseLimitRequest creates a request to invoke GetCloudConnectNetworkUseLimit API
func CreateGetCloudConnectNetworkUseLimitRequest() (request *GetCloudConnectNetworkUseLimitRequest) {
	request = &GetCloudConnectNetworkUseLimitRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "GetCloudConnectNetworkUseLimit", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetCloudConnectNetworkUseLimitResponse creates a response to parse from GetCloudConnectNetworkUseLimit response
func CreateGetCloudConnectNetworkUseLimitResponse() (response *GetCloudConnectNetworkUseLimitResponse) {
	response = &GetCloudConnectNetworkUseLimitResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
