package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySagRouteProtocolOspf invokes the smartag.ModifySagRouteProtocolOspf API synchronously
func (client *Client) ModifySagRouteProtocolOspf(request *ModifySagRouteProtocolOspfRequest) (response *ModifySagRouteProtocolOspfResponse, err error) {
	response = CreateModifySagRouteProtocolOspfResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySagRouteProtocolOspfWithChan invokes the smartag.ModifySagRouteProtocolOspf API asynchronously
func (client *Client) ModifySagRouteProtocolOspfWithChan(request *ModifySagRouteProtocolOspfRequest) (<-chan *ModifySagRouteProtocolOspfResponse, <-chan error) {
	responseChan := make(chan *ModifySagRouteProtocolOspfResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySagRouteProtocolOspf(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySagRouteProtocolOspfWithCallback invokes the smartag.ModifySagRouteProtocolOspf API asynchronously
func (client *Client) ModifySagRouteProtocolOspfWithCallback(request *ModifySagRouteProtocolOspfRequest, callback func(response *ModifySagRouteProtocolOspfResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySagRouteProtocolOspfResponse
		var err error
		defer close(result)
		response, err = client.ModifySagRouteProtocolOspf(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySagRouteProtocolOspfRequest is the request struct for api ModifySagRouteProtocolOspf
type ModifySagRouteProtocolOspfRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AuthenticationType   string           `position:"Query" name:"AuthenticationType"`
	Password             string           `position:"Query" name:"Password"`
	AreaId               requests.Integer `position:"Query" name:"AreaId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Md5KeyId             requests.Integer `position:"Query" name:"Md5KeyId"`
	RouterId             string           `position:"Query" name:"RouterId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
	DeadTime             requests.Integer `position:"Query" name:"DeadTime"`
	Md5Key               string           `position:"Query" name:"Md5Key"`
	HelloTime            requests.Integer `position:"Query" name:"HelloTime"`
}

// ModifySagRouteProtocolOspfResponse is the response struct for api ModifySagRouteProtocolOspf
type ModifySagRouteProtocolOspfResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySagRouteProtocolOspfRequest creates a request to invoke ModifySagRouteProtocolOspf API
func CreateModifySagRouteProtocolOspfRequest() (request *ModifySagRouteProtocolOspfRequest) {
	request = &ModifySagRouteProtocolOspfRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifySagRouteProtocolOspf", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifySagRouteProtocolOspfResponse creates a response to parse from ModifySagRouteProtocolOspf response
func CreateModifySagRouteProtocolOspfResponse() (response *ModifySagRouteProtocolOspfResponse) {
	response = &ModifySagRouteProtocolOspfResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
