package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTenantInfo invokes the unimkt.ModifyTenantInfo API synchronously
func (client *Client) ModifyTenantInfo(request *ModifyTenantInfoRequest) (response *ModifyTenantInfoResponse, err error) {
	response = CreateModifyTenantInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTenantInfoWithChan invokes the unimkt.ModifyTenantInfo API asynchronously
func (client *Client) ModifyTenantInfoWithChan(request *ModifyTenantInfoRequest) (<-chan *ModifyTenantInfoResponse, <-chan error) {
	responseChan := make(chan *ModifyTenantInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTenantInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTenantInfoWithCallback invokes the unimkt.ModifyTenantInfo API asynchronously
func (client *Client) ModifyTenantInfoWithCallback(request *ModifyTenantInfoRequest, callback func(response *ModifyTenantInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTenantInfoResponse
		var err error
		defer close(result)
		response, err = client.ModifyTenantInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTenantInfoRequest is the request struct for api ModifyTenantInfo
type ModifyTenantInfoRequest struct {
	*requests.RpcRequest
	Business         string `position:"Query" name:"Business"`
	UserId           string `position:"Query" name:"UserId"`
	OriginSiteUserId string `position:"Query" name:"OriginSiteUserId"`
	Environment      string `position:"Query" name:"Environment"`
	AppName          string `position:"Query" name:"AppName"`
	TenantId         string `position:"Query" name:"TenantId"`
	UserSite         string `position:"Query" name:"UserSite"`
	Tenant           string `position:"Body" name:"Tenant"`
}

// ModifyTenantInfoResponse is the response struct for api ModifyTenantInfo
type ModifyTenantInfoResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Model     Model  `json:"Model" xml:"Model"`
}

// CreateModifyTenantInfoRequest creates a request to invoke ModifyTenantInfo API
func CreateModifyTenantInfoRequest() (request *ModifyTenantInfoRequest) {
	request = &ModifyTenantInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "ModifyTenantInfo", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTenantInfoResponse creates a response to parse from ModifyTenantInfo response
func CreateModifyTenantInfoResponse() (response *ModifyTenantInfoResponse) {
	response = &ModifyTenantInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
