package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyAsrVadConfig invokes the voicenavigator.ModifyAsrVadConfig API synchronously
func (client *Client) ModifyAsrVadConfig(request *ModifyAsrVadConfigRequest) (response *ModifyAsrVadConfigResponse, err error) {
	response = CreateModifyAsrVadConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyAsrVadConfigWithChan invokes the voicenavigator.ModifyAsrVadConfig API asynchronously
func (client *Client) ModifyAsrVadConfigWithChan(request *ModifyAsrVadConfigRequest) (<-chan *ModifyAsrVadConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyAsrVadConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyAsrVadConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyAsrVadConfigWithCallback invokes the voicenavigator.ModifyAsrVadConfig API asynchronously
func (client *Client) ModifyAsrVadConfigWithCallback(request *ModifyAsrVadConfigRequest, callback func(response *ModifyAsrVadConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyAsrVadConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyAsrVadConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyAsrVadConfigRequest is the request struct for api ModifyAsrVadConfig
type ModifyAsrVadConfigRequest struct {
	*requests.RpcRequest
	InstanceId           string `position:"Query" name:"InstanceId"`
	SpeechNoiseThreshold string `position:"Query" name:"SpeechNoiseThreshold"`
}

// ModifyAsrVadConfigResponse is the response struct for api ModifyAsrVadConfig
type ModifyAsrVadConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyAsrVadConfigRequest creates a request to invoke ModifyAsrVadConfig API
func CreateModifyAsrVadConfigRequest() (request *ModifyAsrVadConfigRequest) {
	request = &ModifyAsrVadConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "ModifyAsrVadConfig", "voicebot", "openAPI")
	request.Method = requests.GET
	return
}

// CreateModifyAsrVadConfigResponse creates a response to parse from ModifyAsrVadConfig response
func CreateModifyAsrVadConfigResponse() (response *ModifyAsrVadConfigResponse) {
	response = &ModifyAsrVadConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
