package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDeviceRecords invokes the vs.ListDeviceRecords API synchronously
func (client *Client) ListDeviceRecords(request *ListDeviceRecordsRequest) (response *ListDeviceRecordsResponse, err error) {
	response = CreateListDeviceRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDeviceRecordsWithChan invokes the vs.ListDeviceRecords API asynchronously
func (client *Client) ListDeviceRecordsWithChan(request *ListDeviceRecordsRequest) (<-chan *ListDeviceRecordsResponse, <-chan error) {
	responseChan := make(chan *ListDeviceRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDeviceRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDeviceRecordsWithCallback invokes the vs.ListDeviceRecords API asynchronously
func (client *Client) ListDeviceRecordsWithCallback(request *ListDeviceRecordsRequest, callback func(response *ListDeviceRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDeviceRecordsResponse
		var err error
		defer close(result)
		response, err = client.ListDeviceRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDeviceRecordsRequest is the request struct for api ListDeviceRecords
type ListDeviceRecordsRequest struct {
	*requests.RpcRequest
	PageNum        requests.Integer `position:"Query" name:"PageNum"`
	SearchCriteria string           `position:"Query" name:"SearchCriteria"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	ShowLog        string           `position:"Query" name:"ShowLog"`
	StreamId       string           `position:"Query" name:"StreamId"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	DeviceId       string           `position:"Query" name:"DeviceId"`
}

// ListDeviceRecordsResponse is the response struct for api ListDeviceRecords
type ListDeviceRecordsResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	PageSize   int64    `json:"PageSize" xml:"PageSize"`
	PageNum    int64    `json:"PageNum" xml:"PageNum"`
	PageCount  int64    `json:"PageCount" xml:"PageCount"`
	TotalCount int64    `json:"TotalCount" xml:"TotalCount"`
	Records    []Record `json:"Records" xml:"Records"`
}

// CreateListDeviceRecordsRequest creates a request to invoke ListDeviceRecords API
func CreateListDeviceRecordsRequest() (request *ListDeviceRecordsRequest) {
	request = &ListDeviceRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "ListDeviceRecords", "", "")
	request.Method = requests.POST
	return
}

// CreateListDeviceRecordsResponse creates a response to parse from ListDeviceRecords response
func CreateListDeviceRecordsResponse() (response *ListDeviceRecordsResponse) {
	response = &ListDeviceRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
