/*----------------------------------------------------------------------------------------
  Module header file for: dv module
----------------------------------------------------------------------------------------*/
#ifndef DVDATABASE_H

#define DVDATABASE_H

#if defined __cplusplus
extern "C" {
#endif

#ifndef DD_UTIL_H
#include "ddutil.h"
#endif

/* Class reference definitions */

#if (defined(DD_DEBUG) && !defined(DD_NOSTRICT)) || defined(DD_STRICT)
typedef struct _struct_dvRoot{char val;} *dvRoot;
#define dvRootNull ((dvRoot)(UINT32_MAX))
#define dvRoot2Index(Root) ((uint32)((Root) - (dvRoot)(0)))
#define dvRoot2ValidIndex(Root) ((uint32)(dvValidRoot(Root) - (dvRoot)(0)))
#define dvIndex2Root(xRoot) ((dvRoot)((xRoot) + (dvRoot)(0)))
typedef struct _struct_dvModpath{char val;} *dvModpath;
#define dvModpathNull ((dvModpath)(UINT32_MAX))
#define dvModpath2Index(Modpath) ((uint32)((Modpath) - (dvModpath)(0)))
#define dvModpath2ValidIndex(Modpath) ((uint32)(dvValidModpath(Modpath) - (dvModpath)(0)))
#define dvIndex2Modpath(xModpath) ((dvModpath)((xModpath) + (dvModpath)(0)))
typedef struct _struct_dvModule{char val;} *dvModule;
#define dvModuleNull ((dvModule)(UINT32_MAX))
#define dvModule2Index(Module) ((uint32)((Module) - (dvModule)(0)))
#define dvModule2ValidIndex(Module) ((uint32)(dvValidModule(Module) - (dvModule)(0)))
#define dvIndex2Module(xModule) ((dvModule)((xModule) + (dvModule)(0)))
typedef struct _struct_dvLink{char val;} *dvLink;
#define dvLinkNull ((dvLink)(UINT32_MAX))
#define dvLink2Index(Link) ((uint32)((Link) - (dvLink)(0)))
#define dvLink2ValidIndex(Link) ((uint32)(dvValidLink(Link) - (dvLink)(0)))
#define dvIndex2Link(xLink) ((dvLink)((xLink) + (dvLink)(0)))
typedef struct _struct_dvSchema{char val;} *dvSchema;
#define dvSchemaNull ((dvSchema)(UINT32_MAX))
#define dvSchema2Index(Schema) ((uint32)((Schema) - (dvSchema)(0)))
#define dvSchema2ValidIndex(Schema) ((uint32)(dvValidSchema(Schema) - (dvSchema)(0)))
#define dvIndex2Schema(xSchema) ((dvSchema)((xSchema) + (dvSchema)(0)))
typedef struct _struct_dvEnum{char val;} *dvEnum;
#define dvEnumNull ((dvEnum)(UINT32_MAX))
#define dvEnum2Index(Enum) ((uint32)((Enum) - (dvEnum)(0)))
#define dvEnum2ValidIndex(Enum) ((uint32)(dvValidEnum(Enum) - (dvEnum)(0)))
#define dvIndex2Enum(xEnum) ((dvEnum)((xEnum) + (dvEnum)(0)))
typedef struct _struct_dvEntry{char val;} *dvEntry;
#define dvEntryNull ((dvEntry)(UINT32_MAX))
#define dvEntry2Index(Entry) ((uint32)((Entry) - (dvEntry)(0)))
#define dvEntry2ValidIndex(Entry) ((uint32)(dvValidEntry(Entry) - (dvEntry)(0)))
#define dvIndex2Entry(xEntry) ((dvEntry)((xEntry) + (dvEntry)(0)))
typedef struct _struct_dvTypedef{char val;} *dvTypedef;
#define dvTypedefNull ((dvTypedef)(UINT32_MAX))
#define dvTypedef2Index(Typedef) ((uint32)((Typedef) - (dvTypedef)(0)))
#define dvTypedef2ValidIndex(Typedef) ((uint32)(dvValidTypedef(Typedef) - (dvTypedef)(0)))
#define dvIndex2Typedef(xTypedef) ((dvTypedef)((xTypedef) + (dvTypedef)(0)))
typedef struct _struct_dvClass{char val;} *dvClass;
#define dvClassNull ((dvClass)(UINT32_MAX))
#define dvClass2Index(Class) ((uint32)((Class) - (dvClass)(0)))
#define dvClass2ValidIndex(Class) ((uint32)(dvValidClass(Class) - (dvClass)(0)))
#define dvIndex2Class(xClass) ((dvClass)((xClass) + (dvClass)(0)))
typedef struct _struct_dvProperty{char val;} *dvProperty;
#define dvPropertyNull ((dvProperty)(UINT32_MAX))
#define dvProperty2Index(Property) ((uint32)((Property) - (dvProperty)(0)))
#define dvProperty2ValidIndex(Property) ((uint32)(dvValidProperty(Property) - (dvProperty)(0)))
#define dvIndex2Property(xProperty) ((dvProperty)((xProperty) + (dvProperty)(0)))
typedef struct _struct_dvSparsegroup{char val;} *dvSparsegroup;
#define dvSparsegroupNull ((dvSparsegroup)(UINT32_MAX))
#define dvSparsegroup2Index(Sparsegroup) ((uint32)((Sparsegroup) - (dvSparsegroup)(0)))
#define dvSparsegroup2ValidIndex(Sparsegroup) ((uint32)(dvValidSparsegroup(Sparsegroup) - (dvSparsegroup)(0)))
#define dvIndex2Sparsegroup(xSparsegroup) ((dvSparsegroup)((xSparsegroup) + (dvSparsegroup)(0)))
typedef struct _struct_dvRelationship{char val;} *dvRelationship;
#define dvRelationshipNull ((dvRelationship)(UINT32_MAX))
#define dvRelationship2Index(Relationship) ((uint32)((Relationship) - (dvRelationship)(0)))
#define dvRelationship2ValidIndex(Relationship) ((uint32)(dvValidRelationship(Relationship) - (dvRelationship)(0)))
#define dvIndex2Relationship(xRelationship) ((dvRelationship)((xRelationship) + (dvRelationship)(0)))
typedef struct _struct_dvKey{char val;} *dvKey;
#define dvKeyNull ((dvKey)(UINT32_MAX))
#define dvKey2Index(Key) ((uint32)((Key) - (dvKey)(0)))
#define dvKey2ValidIndex(Key) ((uint32)(dvValidKey(Key) - (dvKey)(0)))
#define dvIndex2Key(xKey) ((dvKey)((xKey) + (dvKey)(0)))
typedef struct _struct_dvUnion{char val;} *dvUnion;
#define dvUnionNull ((dvUnion)(UINT32_MAX))
#define dvUnion2Index(Union) ((uint32)((Union) - (dvUnion)(0)))
#define dvUnion2ValidIndex(Union) ((uint32)(dvValidUnion(Union) - (dvUnion)(0)))
#define dvIndex2Union(xUnion) ((dvUnion)((xUnion) + (dvUnion)(0)))
typedef struct _struct_dvCase{char val;} *dvCase;
#define dvCaseNull ((dvCase)(UINT32_MAX))
#define dvCase2Index(Case) ((uint32)((Case) - (dvCase)(0)))
#define dvCase2ValidIndex(Case) ((uint32)(dvValidCase(Case) - (dvCase)(0)))
#define dvIndex2Case(xCase) ((dvCase)((xCase) + (dvCase)(0)))
#else
typedef uint32 dvRoot;
#define dvRootNull UINT32_MAX
#define dvRoot2Index(Root) (Root)
#define dvRoot2ValidIndex(Root) (dvValidRoot(Root))
#define dvIndex2Root(xRoot) ((xRoot))
typedef uint32 dvModpath;
#define dvModpathNull UINT32_MAX
#define dvModpath2Index(Modpath) (Modpath)
#define dvModpath2ValidIndex(Modpath) (dvValidModpath(Modpath))
#define dvIndex2Modpath(xModpath) ((xModpath))
typedef uint32 dvModule;
#define dvModuleNull UINT32_MAX
#define dvModule2Index(Module) (Module)
#define dvModule2ValidIndex(Module) (dvValidModule(Module))
#define dvIndex2Module(xModule) ((xModule))
typedef uint32 dvLink;
#define dvLinkNull UINT32_MAX
#define dvLink2Index(Link) (Link)
#define dvLink2ValidIndex(Link) (dvValidLink(Link))
#define dvIndex2Link(xLink) ((xLink))
typedef uint32 dvSchema;
#define dvSchemaNull UINT32_MAX
#define dvSchema2Index(Schema) (Schema)
#define dvSchema2ValidIndex(Schema) (dvValidSchema(Schema))
#define dvIndex2Schema(xSchema) ((xSchema))
typedef uint32 dvEnum;
#define dvEnumNull UINT32_MAX
#define dvEnum2Index(Enum) (Enum)
#define dvEnum2ValidIndex(Enum) (dvValidEnum(Enum))
#define dvIndex2Enum(xEnum) ((xEnum))
typedef uint32 dvEntry;
#define dvEntryNull UINT32_MAX
#define dvEntry2Index(Entry) (Entry)
#define dvEntry2ValidIndex(Entry) (dvValidEntry(Entry))
#define dvIndex2Entry(xEntry) ((xEntry))
typedef uint32 dvTypedef;
#define dvTypedefNull UINT32_MAX
#define dvTypedef2Index(Typedef) (Typedef)
#define dvTypedef2ValidIndex(Typedef) (dvValidTypedef(Typedef))
#define dvIndex2Typedef(xTypedef) ((xTypedef))
typedef uint32 dvClass;
#define dvClassNull UINT32_MAX
#define dvClass2Index(Class) (Class)
#define dvClass2ValidIndex(Class) (dvValidClass(Class))
#define dvIndex2Class(xClass) ((xClass))
typedef uint32 dvProperty;
#define dvPropertyNull UINT32_MAX
#define dvProperty2Index(Property) (Property)
#define dvProperty2ValidIndex(Property) (dvValidProperty(Property))
#define dvIndex2Property(xProperty) ((xProperty))
typedef uint32 dvSparsegroup;
#define dvSparsegroupNull UINT32_MAX
#define dvSparsegroup2Index(Sparsegroup) (Sparsegroup)
#define dvSparsegroup2ValidIndex(Sparsegroup) (dvValidSparsegroup(Sparsegroup))
#define dvIndex2Sparsegroup(xSparsegroup) ((xSparsegroup))
typedef uint32 dvRelationship;
#define dvRelationshipNull UINT32_MAX
#define dvRelationship2Index(Relationship) (Relationship)
#define dvRelationship2ValidIndex(Relationship) (dvValidRelationship(Relationship))
#define dvIndex2Relationship(xRelationship) ((xRelationship))
typedef uint32 dvKey;
#define dvKeyNull UINT32_MAX
#define dvKey2Index(Key) (Key)
#define dvKey2ValidIndex(Key) (dvValidKey(Key))
#define dvIndex2Key(xKey) ((xKey))
typedef uint32 dvUnion;
#define dvUnionNull UINT32_MAX
#define dvUnion2Index(Union) (Union)
#define dvUnion2ValidIndex(Union) (dvValidUnion(Union))
#define dvIndex2Union(xUnion) ((xUnion))
typedef uint32 dvCase;
#define dvCaseNull UINT32_MAX
#define dvCase2Index(Case) (Case)
#define dvCase2ValidIndex(Case) (dvValidCase(Case))
#define dvIndex2Case(xCase) ((xCase))
#endif

/* RelationshipType enumerated type */
typedef enum {
    REL_LINKED_LIST = 0,
    REL_DOUBLY_LINKED = 1,
    REL_TAIL_LINKED = 2,
    REL_POINTER = 3,
    REL_ARRAY = 4,
    REL_HEAP = 5,
    REL_HASHED = 6,
    REL_UNBOUND = 7
} dvRelationshipType;

/* PropertyType enumerated type */
typedef enum {
    PROP_INT = 0,
    PROP_UINT = 1,
    PROP_FLOAT = 2,
    PROP_DOUBLE = 3,
    PROP_BIT = 4,
    PROP_BOOL = 5,
    PROP_CHAR = 6,
    PROP_ENUM = 7,
    PROP_TYPEDEF = 8,
    PROP_POINTER = 9,
    PROP_SYM = 10,
    PROP_UNBOUND = 11
} dvPropertyType;

/* MemoryStyle enumerated type */
typedef enum {
    MEM_CREATE_ONLY = 0,
    MEM_FREE_LIST = 1
} dvMemoryStyle;

/* Validate macros */
#if defined(DD_DEBUG)
#define dvValidRoot(Root) (utLikely((uint32)((Root) - (dvRoot)0) < \
    dvRootData.usedRoot)? (Root) : (utExit("Invalid Root"), (dvRoot)0))
#define dvValidModpath(Modpath) (utLikely((uint32)((Modpath) - (dvModpath)0) < \
    dvRootData.usedModpath)? (Modpath) : (utExit("Invalid Modpath"), (dvModpath)0))
#define dvValidModule(Module) (utLikely((uint32)((Module) - (dvModule)0) < \
    dvRootData.usedModule)? (Module) : (utExit("Invalid Module"), (dvModule)0))
#define dvValidLink(Link) (utLikely((uint32)((Link) - (dvLink)0) < \
    dvRootData.usedLink)? (Link) : (utExit("Invalid Link"), (dvLink)0))
#define dvValidSchema(Schema) (utLikely((uint32)((Schema) - (dvSchema)0) < \
    dvRootData.usedSchema)? (Schema) : (utExit("Invalid Schema"), (dvSchema)0))
#define dvValidEnum(Enum) (utLikely((uint32)((Enum) - (dvEnum)0) < \
    dvRootData.usedEnum)? (Enum) : (utExit("Invalid Enum"), (dvEnum)0))
#define dvValidEntry(Entry) (utLikely((uint32)((Entry) - (dvEntry)0) < \
    dvRootData.usedEntry)? (Entry) : (utExit("Invalid Entry"), (dvEntry)0))
#define dvValidTypedef(Typedef) (utLikely((uint32)((Typedef) - (dvTypedef)0) < \
    dvRootData.usedTypedef)? (Typedef) : (utExit("Invalid Typedef"), (dvTypedef)0))
#define dvValidClass(Class) (utLikely((uint32)((Class) - (dvClass)0) < \
    dvRootData.usedClass)? (Class) : (utExit("Invalid Class"), (dvClass)0))
#define dvValidProperty(Property) (utLikely((uint32)((Property) - (dvProperty)0) < \
    dvRootData.usedProperty)? (Property) : (utExit("Invalid Property"), (dvProperty)0))
#define dvValidSparsegroup(Sparsegroup) (utLikely((uint32)((Sparsegroup) - (dvSparsegroup)0) < \
    dvRootData.usedSparsegroup)? (Sparsegroup) : (utExit("Invalid Sparsegroup"), (dvSparsegroup)0))
#define dvValidRelationship(Relationship) (utLikely((uint32)((Relationship) - (dvRelationship)0) < \
    dvRootData.usedRelationship)? (Relationship) : (utExit("Invalid Relationship"), (dvRelationship)0))
#define dvValidKey(Key) (utLikely((uint32)((Key) - (dvKey)0) < \
    dvRootData.usedKey)? (Key) : (utExit("Invalid Key"), (dvKey)0))
#define dvValidUnion(Union) (utLikely((uint32)((Union) - (dvUnion)0) < \
    dvRootData.usedUnion)? (Union) : (utExit("Invalid Union"), (dvUnion)0))
#define dvValidCase(Case) (utLikely((uint32)((Case) - (dvCase)0) < \
    dvRootData.usedCase)? (Case) : (utExit("Invalid Case"), (dvCase)0))
#else
#define dvValidRoot(Root) (Root)
#define dvValidModpath(Modpath) (Modpath)
#define dvValidModule(Module) (Module)
#define dvValidLink(Link) (Link)
#define dvValidSchema(Schema) (Schema)
#define dvValidEnum(Enum) (Enum)
#define dvValidEntry(Entry) (Entry)
#define dvValidTypedef(Typedef) (Typedef)
#define dvValidClass(Class) (Class)
#define dvValidProperty(Property) (Property)
#define dvValidSparsegroup(Sparsegroup) (Sparsegroup)
#define dvValidRelationship(Relationship) (Relationship)
#define dvValidKey(Key) (Key)
#define dvValidUnion(Union) (Union)
#define dvValidCase(Case) (Case)
#endif

/*----------------------------------------------------------------------------------------
  Fields for class Root.
----------------------------------------------------------------------------------------*/
struct dvRootFields {
    dvModpath *FirstModpath;
    dvModpath *LastModpath;
    uint32 *ModpathTableIndex;
    uint32 *NumModpathTable;
    dvModpath *ModpathTable;
    uint32 *NumModpath;
    dvModule *FirstModule;
    dvModule *LastModule;
    uint32 *ModuleTableIndex;
    uint32 *NumModuleTable;
    dvModule *ModuleTable;
    uint32 *NumModule;
};
extern struct dvRootFields dvRoots;

#define dvRootGetFirstModpath(_Root) (dvRoots.FirstModpath[dvRoot2ValidIndex(_Root)])
#define dvRootSetFirstModpath(_Root, value) ((dvRoots.FirstModpath)[dvRoot2ValidIndex(_Root)] = (value))
#define dvRootGetLastModpath(_Root) (dvRoots.LastModpath[dvRoot2ValidIndex(_Root)])
#define dvRootSetLastModpath(_Root, value) ((dvRoots.LastModpath)[dvRoot2ValidIndex(_Root)] = (value))
#define dvRootGetModpathTableIndex(_Root) (dvRoots.ModpathTableIndex[dvRoot2ValidIndex(_Root)])
#define dvRootSetModpathTableIndex(_Root, value) ((dvRoots.ModpathTableIndex)[dvRoot2ValidIndex(_Root)] = (value))
#define dvRootGetNumModpathTable(_Root) (dvRoots.NumModpathTable[dvRoot2ValidIndex(_Root)])
#define dvRootSetNumModpathTable(_Root, value) ((dvRoots.NumModpathTable)[dvRoot2ValidIndex(_Root)] = (value))
#if defined(DD_DEBUG)
#define dvRootCheckModpathTableIndex(Root, x) ((uint32)(x) < dvRootGetNumModpathTable(Root)? (x) : \
    (utAssert(false),(x)))
#else
#define dvRootCheckModpathTableIndex(Root, x) (x)
#endif
#define dvRootGetiModpathTable(_Root, x) ((dvRoots.ModpathTable)[ \
    dvRootGetModpathTableIndex(_Root) + dvRootCheckModpathTableIndex(_Root, (x))])
#define dvRootGetModpathTable(Root) (dvRoots.ModpathTable + dvRootGetModpathTableIndex(Root))
#define dvRootGetModpathTables dvRootGetModpathTable
#define dvRootSetModpathTable(Root, valuePtr, numModpathTable) (dvRootResizeModpathTables(Root, numModpathTable), memcpy(dvRootGetModpathTables(Root), valuePtr, \
    numModpathTable*sizeof(dvModpath)))
#define dvRootSetiModpathTable(Root, x, value) ((dvRoots.ModpathTable)[ \
    dvRootGetModpathTableIndex(Root) + dvRootCheckModpathTableIndex(Root, (x))] = (value))
#define dvRootGetNumModpath(_Root) (dvRoots.NumModpath[dvRoot2ValidIndex(_Root)])
#define dvRootSetNumModpath(_Root, value) ((dvRoots.NumModpath)[dvRoot2ValidIndex(_Root)] = (value))
#define dvRootGetFirstModule(_Root) (dvRoots.FirstModule[dvRoot2ValidIndex(_Root)])
#define dvRootSetFirstModule(_Root, value) ((dvRoots.FirstModule)[dvRoot2ValidIndex(_Root)] = (value))
#define dvRootGetLastModule(_Root) (dvRoots.LastModule[dvRoot2ValidIndex(_Root)])
#define dvRootSetLastModule(_Root, value) ((dvRoots.LastModule)[dvRoot2ValidIndex(_Root)] = (value))
#define dvRootGetModuleTableIndex(_Root) (dvRoots.ModuleTableIndex[dvRoot2ValidIndex(_Root)])
#define dvRootSetModuleTableIndex(_Root, value) ((dvRoots.ModuleTableIndex)[dvRoot2ValidIndex(_Root)] = (value))
#define dvRootGetNumModuleTable(_Root) (dvRoots.NumModuleTable[dvRoot2ValidIndex(_Root)])
#define dvRootSetNumModuleTable(_Root, value) ((dvRoots.NumModuleTable)[dvRoot2ValidIndex(_Root)] = (value))
#if defined(DD_DEBUG)
#define dvRootCheckModuleTableIndex(Root, x) ((uint32)(x) < dvRootGetNumModuleTable(Root)? (x) : \
    (utAssert(false),(x)))
#else
#define dvRootCheckModuleTableIndex(Root, x) (x)
#endif
#define dvRootGetiModuleTable(_Root, x) ((dvRoots.ModuleTable)[ \
    dvRootGetModuleTableIndex(_Root) + dvRootCheckModuleTableIndex(_Root, (x))])
#define dvRootGetModuleTable(Root) (dvRoots.ModuleTable + dvRootGetModuleTableIndex(Root))
#define dvRootGetModuleTables dvRootGetModuleTable
#define dvRootSetModuleTable(Root, valuePtr, numModuleTable) (dvRootResizeModuleTables(Root, numModuleTable), memcpy(dvRootGetModuleTables(Root), valuePtr, \
    numModuleTable*sizeof(dvModule)))
#define dvRootSetiModuleTable(Root, x, value) ((dvRoots.ModuleTable)[ \
    dvRootGetModuleTableIndex(Root) + dvRootCheckModuleTableIndex(Root, (x))] = (value))
#define dvRootGetNumModule(_Root) (dvRoots.NumModule[dvRoot2ValidIndex(_Root)])
#define dvRootSetNumModule(_Root, value) ((dvRoots.NumModule)[dvRoot2ValidIndex(_Root)] = (value))
dvModpath dvRootFindModpath(dvRoot Root, utSym Sym);
void dvRootRenameModpath(dvRoot Root, dvModpath _Modpath, utSym sym);
#define dvModpathGetName(Modpath) utSymGetName(dvModpathGetSym(Modpath))
#define dvForeachRootModpath(pVar, cVar) \
    for(cVar = dvRootGetFirstModpath(pVar); cVar != dvModpathNull; \
        cVar = dvModpathGetNextRootModpath(cVar))
#define dvEndRootModpath
#define dvSafeForeachRootModpath(pVar, cVar) { \
    dvModpath _nextModpath; \
    for(cVar = dvRootGetFirstModpath(pVar); cVar != dvModpathNull; cVar = _nextModpath) { \
        _nextModpath = dvModpathGetNextRootModpath(cVar);
#define dvEndSafeRootModpath }}
dvModule dvRootFindModule(dvRoot Root, utSym Sym);
void dvRootRenameModule(dvRoot Root, dvModule _Module, utSym sym);
#define dvModuleGetName(Module) utSymGetName(dvModuleGetSym(Module))
#define dvForeachRootModule(pVar, cVar) \
    for(cVar = dvRootGetFirstModule(pVar); cVar != dvModuleNull; \
        cVar = dvModuleGetNextRootModule(cVar))
#define dvEndRootModule
#define dvSafeForeachRootModule(pVar, cVar) { \
    dvModule _nextModule; \
    for(cVar = dvRootGetFirstModule(pVar); cVar != dvModuleNull; cVar = _nextModule) { \
        _nextModule = dvModuleGetNextRootModule(cVar);
#define dvEndSafeRootModule }}
#define dvRootSetConstructorCallback(func) (dvRootConstructorCallback = (func))
#define dvRootGetConstructorCallback() (dvRootConstructorCallback)
#define dvFirstRoot() (dvRootData.usedRoot == 0? dvRootNull : dvIndex2Root(0))
#define dvLastRoot() (dvRootData.usedRoot == 0? dvRootNull : \
    dvIndex2Root(dvRootData.usedRoot - 1))
#define dvNextRoot(Root) (dvRoot2ValidIndex(Root) + 1 == dvRootData.usedRoot? dvRootNull : \
    (Root) + 1)
#define dvPrevRoot(Root) (dvRoot2ValidIndex(Root) == 0? dvRootNull : (Root) - 1)
#define dvForeachRoot(var) \
    for(var = dvIndex2Root(0); dvRoot2Index(var) != dvRootData.usedRoot; var++)
#define dvEndRoot
#define dvRootFreeAll() (dvSetUsedRoot(0), dvSetUsedRootModpathTable(0), dvSetUsedRootModuleTable(0))
#define dvRootAllocRaw() ( \
    dvRootData.usedRoot == dvRootData.allocatedRoot && (dvRootAllocMore(), true), \
    dvTemp_.Root = dvIndex2Root(dvRootData.usedRoot), \
    dvSetUsedRoot(dvUsedRoot() + 1), \
    dvTemp_.Root)
#define dvRootAlloc() ( \
    dvRootData.usedRoot == dvRootData.allocatedRoot && (dvRootAllocMore(), true), \
    dvTemp_.Root = dvIndex2Root(dvRootData.usedRoot), \
    dvSetUsedRoot(dvUsedRoot() + 1), \
    dvRootSetFirstModpath(dvTemp_.Root, dvModpathNull), \
    dvRootSetLastModpath(dvTemp_.Root, dvModpathNull), \
    dvRootSetModpathTableIndex(dvTemp_.Root, 0), \
    dvRootSetNumModpathTable(dvTemp_.Root, 0), \
    dvRootSetNumModpathTable(dvTemp_.Root, 0), \
    dvRootSetNumModpath(dvTemp_.Root, 0), \
    dvRootSetFirstModule(dvTemp_.Root, dvModuleNull), \
    dvRootSetLastModule(dvTemp_.Root, dvModuleNull), \
    dvRootSetModuleTableIndex(dvTemp_.Root, 0), \
    dvRootSetNumModuleTable(dvTemp_.Root, 0), \
    dvRootSetNumModuleTable(dvTemp_.Root, 0), \
    dvRootSetNumModule(dvTemp_.Root, 0), \
    dvRootConstructorCallback != NULL && (dvRootConstructorCallback(dvTemp_.Root), true), \
    dvTemp_.Root)

void dvRootAllocMore(void);
void dvRootCopyProps(dvRoot dvOldRoot, dvRoot dvNewRoot);
void dvRootAllocModpathTables(dvRoot Root, uint32 numModpathTables);
void dvRootResizeModpathTables(dvRoot Root, uint32 numModpathTables);
void dvRootFreeModpathTables(dvRoot Root);
void dvCompactRootModpathTables(void);
void dvRootAllocModuleTables(dvRoot Root, uint32 numModuleTables);
void dvRootResizeModuleTables(dvRoot Root, uint32 numModuleTables);
void dvRootFreeModuleTables(dvRoot Root);
void dvCompactRootModuleTables(void);
void dvRootInsertModpath(dvRoot Root, dvModpath _Modpath);
void dvRootRemoveModpath(dvRoot Root, dvModpath _Modpath);
void dvRootInsertAfterModpath(dvRoot Root, dvModpath prevModpath, dvModpath _Modpath);
void dvRootAppendModpath(dvRoot Root, dvModpath _Modpath);
void dvRootInsertModule(dvRoot Root, dvModule _Module);
void dvRootRemoveModule(dvRoot Root, dvModule _Module);
void dvRootInsertAfterModule(dvRoot Root, dvModule prevModule, dvModule _Module);
void dvRootAppendModule(dvRoot Root, dvModule _Module);

/*----------------------------------------------------------------------------------------
  Fields for class Modpath.
----------------------------------------------------------------------------------------*/
struct dvModpathFields {
    utSym *Sym;
    dvRoot *Root;
    dvModpath *NextRootModpath;
    dvModpath *PrevRootModpath;
    dvModpath *NextTableRootModpath;
};
extern struct dvModpathFields dvModpaths;

#define dvModpathGetSym(_Modpath) (dvModpaths.Sym[dvModpath2ValidIndex(_Modpath)])
#define dvModpathSetSym(_Modpath, value) ((dvModpaths.Sym)[dvModpath2ValidIndex(_Modpath)] = (value))
#define dvModpathGetRoot(_Modpath) (dvModpaths.Root[dvModpath2ValidIndex(_Modpath)])
#define dvModpathSetRoot(_Modpath, value) ((dvModpaths.Root)[dvModpath2ValidIndex(_Modpath)] = (value))
#define dvModpathGetNextRootModpath(_Modpath) (dvModpaths.NextRootModpath[dvModpath2ValidIndex(_Modpath)])
#define dvModpathSetNextRootModpath(_Modpath, value) ((dvModpaths.NextRootModpath)[dvModpath2ValidIndex(_Modpath)] = (value))
#define dvModpathGetPrevRootModpath(_Modpath) (dvModpaths.PrevRootModpath[dvModpath2ValidIndex(_Modpath)])
#define dvModpathSetPrevRootModpath(_Modpath, value) ((dvModpaths.PrevRootModpath)[dvModpath2ValidIndex(_Modpath)] = (value))
#define dvModpathGetNextTableRootModpath(_Modpath) (dvModpaths.NextTableRootModpath[dvModpath2ValidIndex(_Modpath)])
#define dvModpathSetNextTableRootModpath(_Modpath, value) ((dvModpaths.NextTableRootModpath)[dvModpath2ValidIndex(_Modpath)] = (value))
#define dvModpathSetConstructorCallback(func) (dvModpathConstructorCallback = (func))
#define dvModpathGetConstructorCallback() (dvModpathConstructorCallback)
#define dvFirstModpath() (dvRootData.usedModpath == 0? dvModpathNull : dvIndex2Modpath(0))
#define dvLastModpath() (dvRootData.usedModpath == 0? dvModpathNull : \
    dvIndex2Modpath(dvRootData.usedModpath - 1))
#define dvNextModpath(Modpath) (dvModpath2ValidIndex(Modpath) + 1 == dvRootData.usedModpath? dvModpathNull : \
    (Modpath) + 1)
#define dvPrevModpath(Modpath) (dvModpath2ValidIndex(Modpath) == 0? dvModpathNull : (Modpath) - 1)
#define dvForeachModpath(var) \
    for(var = dvIndex2Modpath(0); dvModpath2Index(var) != dvRootData.usedModpath; var++)
#define dvEndModpath
#define dvModpathFreeAll() (dvSetUsedModpath(0))
#define dvModpathAllocRaw() ( \
    dvRootData.usedModpath == dvRootData.allocatedModpath && (dvModpathAllocMore(), true), \
    dvTemp_.Modpath = dvIndex2Modpath(dvRootData.usedModpath), \
    dvSetUsedModpath(dvUsedModpath() + 1), \
    dvTemp_.Modpath)
#define dvModpathAlloc() ( \
    dvRootData.usedModpath == dvRootData.allocatedModpath && (dvModpathAllocMore(), true), \
    dvTemp_.Modpath = dvIndex2Modpath(dvRootData.usedModpath), \
    dvSetUsedModpath(dvUsedModpath() + 1), \
    dvModpathSetSym(dvTemp_.Modpath, utSymNull), \
    dvModpathSetRoot(dvTemp_.Modpath, dvRootNull), \
    dvModpathSetNextRootModpath(dvTemp_.Modpath, dvModpathNull), \
    dvModpathSetPrevRootModpath(dvTemp_.Modpath, dvModpathNull), \
    dvModpathSetNextTableRootModpath(dvTemp_.Modpath, dvModpathNull), \
    dvModpathConstructorCallback != NULL && (dvModpathConstructorCallback(dvTemp_.Modpath), true), \
    dvTemp_.Modpath)

void dvModpathAllocMore(void);
void dvModpathCopyProps(dvModpath dvOldModpath, dvModpath dvNewModpath);

/*----------------------------------------------------------------------------------------
  Fields for class Module.
----------------------------------------------------------------------------------------*/
struct dvModuleFields {
    utSym *Sym;
    utSym *PrefixSym;
    uint8 *Persistent;
    uint8 *UndoRedo;
    uint8 *HasSparseData;
    uint16 *NumFields;
    uint32 *NumClasses;
    uint32 *NumEnums;
    dvModule *NextRootModule;
    dvModule *PrevRootModule;
    dvModule *NextTableRootModule;
    dvClass *FirstClass;
    dvClass *LastClass;
    uint32 *ClassTableIndex;
    uint32 *NumClassTable;
    dvClass *ClassTable;
    uint32 *NumClass;
    dvEnum *FirstEnum;
    dvEnum *LastEnum;
    uint32 *EnumTableIndex;
    uint32 *NumEnumTable;
    dvEnum *EnumTable;
    uint32 *NumEnum;
    dvTypedef *FirstTypedef;
    dvTypedef *LastTypedef;
    uint32 *TypedefTableIndex;
    uint32 *NumTypedefTable;
    dvTypedef *TypedefTable;
    uint32 *NumTypedef;
    dvSchema *FirstSchema;
    dvSchema *LastSchema;
    uint32 *SchemaTableIndex;
    uint32 *NumSchemaTable;
    dvSchema *SchemaTable;
    uint32 *NumSchema;
    dvLink *FirstImportLink;
    dvLink *LastImportLink;
    dvLink *FirstExportLink;
    dvLink *LastExportLink;
};
extern struct dvModuleFields dvModules;

#define dvModuleGetSym(_Module) (dvModules.Sym[dvModule2ValidIndex(_Module)])
#define dvModuleSetSym(_Module, value) ((dvModules.Sym)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetPrefixSym(_Module) (dvModules.PrefixSym[dvModule2ValidIndex(_Module)])
#define dvModuleSetPrefixSym(_Module, value) ((dvModules.PrefixSym)[dvModule2ValidIndex(_Module)] = (value))
#define dvModulePersistent(_Module) (((dvModules.Persistent)[dvModule2ValidIndex(_Module) >> 3] >> \
    (dvModule2ValidIndex(_Module) & 7)) & 1)
#define dvModuleSetPersistent(_Module, value) ((dvModules.Persistent)[dvModule2ValidIndex(_Module) >> 3] = \
    (uint8)(((dvModules.Persistent)[dvModule2ValidIndex(_Module) >> 3] & ~(1 << (dvModule2ValidIndex(_Module) & 7))) | \
    (((value) != 0) << (dvModule2ValidIndex(_Module) & 7))))
#define dvModuleUndoRedo(_Module) (((dvModules.UndoRedo)[dvModule2ValidIndex(_Module) >> 3] >> \
    (dvModule2ValidIndex(_Module) & 7)) & 1)
#define dvModuleSetUndoRedo(_Module, value) ((dvModules.UndoRedo)[dvModule2ValidIndex(_Module) >> 3] = \
    (uint8)(((dvModules.UndoRedo)[dvModule2ValidIndex(_Module) >> 3] & ~(1 << (dvModule2ValidIndex(_Module) & 7))) | \
    (((value) != 0) << (dvModule2ValidIndex(_Module) & 7))))
#define dvModuleHasSparseData(_Module) (((dvModules.HasSparseData)[dvModule2ValidIndex(_Module) >> 3] >> \
    (dvModule2ValidIndex(_Module) & 7)) & 1)
#define dvModuleSetHasSparseData(_Module, value) ((dvModules.HasSparseData)[dvModule2ValidIndex(_Module) >> 3] = \
    (uint8)(((dvModules.HasSparseData)[dvModule2ValidIndex(_Module) >> 3] & ~(1 << (dvModule2ValidIndex(_Module) & 7))) | \
    (((value) != 0) << (dvModule2ValidIndex(_Module) & 7))))
#define dvModuleGetNumFields(_Module) (dvModules.NumFields[dvModule2ValidIndex(_Module)])
#define dvModuleSetNumFields(_Module, value) ((dvModules.NumFields)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetNumClasses(_Module) (dvModules.NumClasses[dvModule2ValidIndex(_Module)])
#define dvModuleSetNumClasses(_Module, value) ((dvModules.NumClasses)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetNumEnums(_Module) (dvModules.NumEnums[dvModule2ValidIndex(_Module)])
#define dvModuleSetNumEnums(_Module, value) ((dvModules.NumEnums)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetNextRootModule(_Module) (dvModules.NextRootModule[dvModule2ValidIndex(_Module)])
#define dvModuleSetNextRootModule(_Module, value) ((dvModules.NextRootModule)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetPrevRootModule(_Module) (dvModules.PrevRootModule[dvModule2ValidIndex(_Module)])
#define dvModuleSetPrevRootModule(_Module, value) ((dvModules.PrevRootModule)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetNextTableRootModule(_Module) (dvModules.NextTableRootModule[dvModule2ValidIndex(_Module)])
#define dvModuleSetNextTableRootModule(_Module, value) ((dvModules.NextTableRootModule)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetFirstClass(_Module) (dvModules.FirstClass[dvModule2ValidIndex(_Module)])
#define dvModuleSetFirstClass(_Module, value) ((dvModules.FirstClass)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetLastClass(_Module) (dvModules.LastClass[dvModule2ValidIndex(_Module)])
#define dvModuleSetLastClass(_Module, value) ((dvModules.LastClass)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetClassTableIndex(_Module) (dvModules.ClassTableIndex[dvModule2ValidIndex(_Module)])
#define dvModuleSetClassTableIndex(_Module, value) ((dvModules.ClassTableIndex)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetNumClassTable(_Module) (dvModules.NumClassTable[dvModule2ValidIndex(_Module)])
#define dvModuleSetNumClassTable(_Module, value) ((dvModules.NumClassTable)[dvModule2ValidIndex(_Module)] = (value))
#if defined(DD_DEBUG)
#define dvModuleCheckClassTableIndex(Module, x) ((uint32)(x) < dvModuleGetNumClassTable(Module)? (x) : \
    (utAssert(false),(x)))
#else
#define dvModuleCheckClassTableIndex(Module, x) (x)
#endif
#define dvModuleGetiClassTable(_Module, x) ((dvModules.ClassTable)[ \
    dvModuleGetClassTableIndex(_Module) + dvModuleCheckClassTableIndex(_Module, (x))])
#define dvModuleGetClassTable(Module) (dvModules.ClassTable + dvModuleGetClassTableIndex(Module))
#define dvModuleGetClassTables dvModuleGetClassTable
#define dvModuleSetClassTable(Module, valuePtr, numClassTable) (dvModuleResizeClassTables(Module, numClassTable), memcpy(dvModuleGetClassTables(Module), valuePtr, \
    numClassTable*sizeof(dvClass)))
#define dvModuleSetiClassTable(Module, x, value) ((dvModules.ClassTable)[ \
    dvModuleGetClassTableIndex(Module) + dvModuleCheckClassTableIndex(Module, (x))] = (value))
#define dvModuleGetNumClass(_Module) (dvModules.NumClass[dvModule2ValidIndex(_Module)])
#define dvModuleSetNumClass(_Module, value) ((dvModules.NumClass)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetFirstEnum(_Module) (dvModules.FirstEnum[dvModule2ValidIndex(_Module)])
#define dvModuleSetFirstEnum(_Module, value) ((dvModules.FirstEnum)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetLastEnum(_Module) (dvModules.LastEnum[dvModule2ValidIndex(_Module)])
#define dvModuleSetLastEnum(_Module, value) ((dvModules.LastEnum)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetEnumTableIndex(_Module) (dvModules.EnumTableIndex[dvModule2ValidIndex(_Module)])
#define dvModuleSetEnumTableIndex(_Module, value) ((dvModules.EnumTableIndex)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetNumEnumTable(_Module) (dvModules.NumEnumTable[dvModule2ValidIndex(_Module)])
#define dvModuleSetNumEnumTable(_Module, value) ((dvModules.NumEnumTable)[dvModule2ValidIndex(_Module)] = (value))
#if defined(DD_DEBUG)
#define dvModuleCheckEnumTableIndex(Module, x) ((uint32)(x) < dvModuleGetNumEnumTable(Module)? (x) : \
    (utAssert(false),(x)))
#else
#define dvModuleCheckEnumTableIndex(Module, x) (x)
#endif
#define dvModuleGetiEnumTable(_Module, x) ((dvModules.EnumTable)[ \
    dvModuleGetEnumTableIndex(_Module) + dvModuleCheckEnumTableIndex(_Module, (x))])
#define dvModuleGetEnumTable(Module) (dvModules.EnumTable + dvModuleGetEnumTableIndex(Module))
#define dvModuleGetEnumTables dvModuleGetEnumTable
#define dvModuleSetEnumTable(Module, valuePtr, numEnumTable) (dvModuleResizeEnumTables(Module, numEnumTable), memcpy(dvModuleGetEnumTables(Module), valuePtr, \
    numEnumTable*sizeof(dvEnum)))
#define dvModuleSetiEnumTable(Module, x, value) ((dvModules.EnumTable)[ \
    dvModuleGetEnumTableIndex(Module) + dvModuleCheckEnumTableIndex(Module, (x))] = (value))
#define dvModuleGetNumEnum(_Module) (dvModules.NumEnum[dvModule2ValidIndex(_Module)])
#define dvModuleSetNumEnum(_Module, value) ((dvModules.NumEnum)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetFirstTypedef(_Module) (dvModules.FirstTypedef[dvModule2ValidIndex(_Module)])
#define dvModuleSetFirstTypedef(_Module, value) ((dvModules.FirstTypedef)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetLastTypedef(_Module) (dvModules.LastTypedef[dvModule2ValidIndex(_Module)])
#define dvModuleSetLastTypedef(_Module, value) ((dvModules.LastTypedef)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetTypedefTableIndex(_Module) (dvModules.TypedefTableIndex[dvModule2ValidIndex(_Module)])
#define dvModuleSetTypedefTableIndex(_Module, value) ((dvModules.TypedefTableIndex)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetNumTypedefTable(_Module) (dvModules.NumTypedefTable[dvModule2ValidIndex(_Module)])
#define dvModuleSetNumTypedefTable(_Module, value) ((dvModules.NumTypedefTable)[dvModule2ValidIndex(_Module)] = (value))
#if defined(DD_DEBUG)
#define dvModuleCheckTypedefTableIndex(Module, x) ((uint32)(x) < dvModuleGetNumTypedefTable(Module)? (x) : \
    (utAssert(false),(x)))
#else
#define dvModuleCheckTypedefTableIndex(Module, x) (x)
#endif
#define dvModuleGetiTypedefTable(_Module, x) ((dvModules.TypedefTable)[ \
    dvModuleGetTypedefTableIndex(_Module) + dvModuleCheckTypedefTableIndex(_Module, (x))])
#define dvModuleGetTypedefTable(Module) (dvModules.TypedefTable + dvModuleGetTypedefTableIndex(Module))
#define dvModuleGetTypedefTables dvModuleGetTypedefTable
#define dvModuleSetTypedefTable(Module, valuePtr, numTypedefTable) (dvModuleResizeTypedefTables(Module, numTypedefTable), memcpy(dvModuleGetTypedefTables(Module), valuePtr, \
    numTypedefTable*sizeof(dvTypedef)))
#define dvModuleSetiTypedefTable(Module, x, value) ((dvModules.TypedefTable)[ \
    dvModuleGetTypedefTableIndex(Module) + dvModuleCheckTypedefTableIndex(Module, (x))] = (value))
#define dvModuleGetNumTypedef(_Module) (dvModules.NumTypedef[dvModule2ValidIndex(_Module)])
#define dvModuleSetNumTypedef(_Module, value) ((dvModules.NumTypedef)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetFirstSchema(_Module) (dvModules.FirstSchema[dvModule2ValidIndex(_Module)])
#define dvModuleSetFirstSchema(_Module, value) ((dvModules.FirstSchema)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetLastSchema(_Module) (dvModules.LastSchema[dvModule2ValidIndex(_Module)])
#define dvModuleSetLastSchema(_Module, value) ((dvModules.LastSchema)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetSchemaTableIndex(_Module) (dvModules.SchemaTableIndex[dvModule2ValidIndex(_Module)])
#define dvModuleSetSchemaTableIndex(_Module, value) ((dvModules.SchemaTableIndex)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetNumSchemaTable(_Module) (dvModules.NumSchemaTable[dvModule2ValidIndex(_Module)])
#define dvModuleSetNumSchemaTable(_Module, value) ((dvModules.NumSchemaTable)[dvModule2ValidIndex(_Module)] = (value))
#if defined(DD_DEBUG)
#define dvModuleCheckSchemaTableIndex(Module, x) ((uint32)(x) < dvModuleGetNumSchemaTable(Module)? (x) : \
    (utAssert(false),(x)))
#else
#define dvModuleCheckSchemaTableIndex(Module, x) (x)
#endif
#define dvModuleGetiSchemaTable(_Module, x) ((dvModules.SchemaTable)[ \
    dvModuleGetSchemaTableIndex(_Module) + dvModuleCheckSchemaTableIndex(_Module, (x))])
#define dvModuleGetSchemaTable(Module) (dvModules.SchemaTable + dvModuleGetSchemaTableIndex(Module))
#define dvModuleGetSchemaTables dvModuleGetSchemaTable
#define dvModuleSetSchemaTable(Module, valuePtr, numSchemaTable) (dvModuleResizeSchemaTables(Module, numSchemaTable), memcpy(dvModuleGetSchemaTables(Module), valuePtr, \
    numSchemaTable*sizeof(dvSchema)))
#define dvModuleSetiSchemaTable(Module, x, value) ((dvModules.SchemaTable)[ \
    dvModuleGetSchemaTableIndex(Module) + dvModuleCheckSchemaTableIndex(Module, (x))] = (value))
#define dvModuleGetNumSchema(_Module) (dvModules.NumSchema[dvModule2ValidIndex(_Module)])
#define dvModuleSetNumSchema(_Module, value) ((dvModules.NumSchema)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetFirstImportLink(_Module) (dvModules.FirstImportLink[dvModule2ValidIndex(_Module)])
#define dvModuleSetFirstImportLink(_Module, value) ((dvModules.FirstImportLink)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetLastImportLink(_Module) (dvModules.LastImportLink[dvModule2ValidIndex(_Module)])
#define dvModuleSetLastImportLink(_Module, value) ((dvModules.LastImportLink)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetFirstExportLink(_Module) (dvModules.FirstExportLink[dvModule2ValidIndex(_Module)])
#define dvModuleSetFirstExportLink(_Module, value) ((dvModules.FirstExportLink)[dvModule2ValidIndex(_Module)] = (value))
#define dvModuleGetLastExportLink(_Module) (dvModules.LastExportLink[dvModule2ValidIndex(_Module)])
#define dvModuleSetLastExportLink(_Module, value) ((dvModules.LastExportLink)[dvModule2ValidIndex(_Module)] = (value))
dvClass dvModuleFindClass(dvModule Module, utSym Sym);
void dvModuleRenameClass(dvModule Module, dvClass _Class, utSym sym);
#define dvClassGetName(Class) utSymGetName(dvClassGetSym(Class))
#define dvForeachModuleClass(pVar, cVar) \
    for(cVar = dvModuleGetFirstClass(pVar); cVar != dvClassNull; \
        cVar = dvClassGetNextModuleClass(cVar))
#define dvEndModuleClass
#define dvSafeForeachModuleClass(pVar, cVar) { \
    dvClass _nextClass; \
    for(cVar = dvModuleGetFirstClass(pVar); cVar != dvClassNull; cVar = _nextClass) { \
        _nextClass = dvClassGetNextModuleClass(cVar);
#define dvEndSafeModuleClass }}
dvEnum dvModuleFindEnum(dvModule Module, utSym Sym);
void dvModuleRenameEnum(dvModule Module, dvEnum _Enum, utSym sym);
#define dvEnumGetName(Enum) utSymGetName(dvEnumGetSym(Enum))
#define dvForeachModuleEnum(pVar, cVar) \
    for(cVar = dvModuleGetFirstEnum(pVar); cVar != dvEnumNull; \
        cVar = dvEnumGetNextModuleEnum(cVar))
#define dvEndModuleEnum
#define dvSafeForeachModuleEnum(pVar, cVar) { \
    dvEnum _nextEnum; \
    for(cVar = dvModuleGetFirstEnum(pVar); cVar != dvEnumNull; cVar = _nextEnum) { \
        _nextEnum = dvEnumGetNextModuleEnum(cVar);
#define dvEndSafeModuleEnum }}
dvTypedef dvModuleFindTypedef(dvModule Module, utSym Sym);
void dvModuleRenameTypedef(dvModule Module, dvTypedef _Typedef, utSym sym);
#define dvTypedefGetName(Typedef) utSymGetName(dvTypedefGetSym(Typedef))
#define dvForeachModuleTypedef(pVar, cVar) \
    for(cVar = dvModuleGetFirstTypedef(pVar); cVar != dvTypedefNull; \
        cVar = dvTypedefGetNextModuleTypedef(cVar))
#define dvEndModuleTypedef
#define dvSafeForeachModuleTypedef(pVar, cVar) { \
    dvTypedef _nextTypedef; \
    for(cVar = dvModuleGetFirstTypedef(pVar); cVar != dvTypedefNull; cVar = _nextTypedef) { \
        _nextTypedef = dvTypedefGetNextModuleTypedef(cVar);
#define dvEndSafeModuleTypedef }}
dvSchema dvModuleFindSchema(dvModule Module, utSym Sym);
void dvModuleRenameSchema(dvModule Module, dvSchema _Schema, utSym sym);
#define dvSchemaGetName(Schema) utSymGetName(dvSchemaGetSym(Schema))
#define dvForeachModuleSchema(pVar, cVar) \
    for(cVar = dvModuleGetFirstSchema(pVar); cVar != dvSchemaNull; \
        cVar = dvSchemaGetNextModuleSchema(cVar))
#define dvEndModuleSchema
#define dvSafeForeachModuleSchema(pVar, cVar) { \
    dvSchema _nextSchema; \
    for(cVar = dvModuleGetFirstSchema(pVar); cVar != dvSchemaNull; cVar = _nextSchema) { \
        _nextSchema = dvSchemaGetNextModuleSchema(cVar);
#define dvEndSafeModuleSchema }}
#define dvForeachModuleImportLink(pVar, cVar) \
    for(cVar = dvModuleGetFirstImportLink(pVar); cVar != dvLinkNull; \
        cVar = dvLinkGetNextModuleImportLink(cVar))
#define dvEndModuleImportLink
#define dvSafeForeachModuleImportLink(pVar, cVar) { \
    dvLink _nextLink; \
    for(cVar = dvModuleGetFirstImportLink(pVar); cVar != dvLinkNull; cVar = _nextLink) { \
        _nextLink = dvLinkGetNextModuleImportLink(cVar);
#define dvEndSafeModuleImportLink }}
#define dvForeachModuleExportLink(pVar, cVar) \
    for(cVar = dvModuleGetFirstExportLink(pVar); cVar != dvLinkNull; \
        cVar = dvLinkGetNextModuleExportLink(cVar))
#define dvEndModuleExportLink
#define dvSafeForeachModuleExportLink(pVar, cVar) { \
    dvLink _nextLink; \
    for(cVar = dvModuleGetFirstExportLink(pVar); cVar != dvLinkNull; cVar = _nextLink) { \
        _nextLink = dvLinkGetNextModuleExportLink(cVar);
#define dvEndSafeModuleExportLink }}
#define dvModuleSetConstructorCallback(func) (dvModuleConstructorCallback = (func))
#define dvModuleGetConstructorCallback() (dvModuleConstructorCallback)
#define dvFirstModule() (dvRootData.usedModule == 0? dvModuleNull : dvIndex2Module(0))
#define dvLastModule() (dvRootData.usedModule == 0? dvModuleNull : \
    dvIndex2Module(dvRootData.usedModule - 1))
#define dvNextModule(Module) (dvModule2ValidIndex(Module) + 1 == dvRootData.usedModule? dvModuleNull : \
    (Module) + 1)
#define dvPrevModule(Module) (dvModule2ValidIndex(Module) == 0? dvModuleNull : (Module) - 1)
#define dvForeachModule(var) \
    for(var = dvIndex2Module(0); dvModule2Index(var) != dvRootData.usedModule; var++)
#define dvEndModule
#define dvModuleFreeAll() (dvSetUsedModule(0), dvSetUsedModuleClassTable(0), dvSetUsedModuleEnumTable(0), dvSetUsedModuleTypedefTable(0), dvSetUsedModuleSchemaTable(0))
#define dvModuleAllocRaw() ( \
    dvRootData.usedModule == dvRootData.allocatedModule && (dvModuleAllocMore(), true), \
    dvTemp_.Module = dvIndex2Module(dvRootData.usedModule), \
    dvSetUsedModule(dvUsedModule() + 1), \
    dvTemp_.Module)
#define dvModuleAlloc() ( \
    dvRootData.usedModule == dvRootData.allocatedModule && (dvModuleAllocMore(), true), \
    dvTemp_.Module = dvIndex2Module(dvRootData.usedModule), \
    dvSetUsedModule(dvUsedModule() + 1), \
    dvModuleSetSym(dvTemp_.Module, utSymNull), \
    dvModuleSetPrefixSym(dvTemp_.Module, utSymNull), \
    dvModuleSetPersistent(dvTemp_.Module, 0), \
    dvModuleSetUndoRedo(dvTemp_.Module, 0), \
    dvModuleSetHasSparseData(dvTemp_.Module, 0), \
    dvModuleSetNumFields(dvTemp_.Module, 0), \
    dvModuleSetNumClasses(dvTemp_.Module, 0), \
    dvModuleSetNumEnums(dvTemp_.Module, 0), \
    dvModuleSetNextRootModule(dvTemp_.Module, dvModuleNull), \
    dvModuleSetPrevRootModule(dvTemp_.Module, dvModuleNull), \
    dvModuleSetNextTableRootModule(dvTemp_.Module, dvModuleNull), \
    dvModuleSetFirstClass(dvTemp_.Module, dvClassNull), \
    dvModuleSetLastClass(dvTemp_.Module, dvClassNull), \
    dvModuleSetClassTableIndex(dvTemp_.Module, 0), \
    dvModuleSetNumClassTable(dvTemp_.Module, 0), \
    dvModuleSetNumClassTable(dvTemp_.Module, 0), \
    dvModuleSetNumClass(dvTemp_.Module, 0), \
    dvModuleSetFirstEnum(dvTemp_.Module, dvEnumNull), \
    dvModuleSetLastEnum(dvTemp_.Module, dvEnumNull), \
    dvModuleSetEnumTableIndex(dvTemp_.Module, 0), \
    dvModuleSetNumEnumTable(dvTemp_.Module, 0), \
    dvModuleSetNumEnumTable(dvTemp_.Module, 0), \
    dvModuleSetNumEnum(dvTemp_.Module, 0), \
    dvModuleSetFirstTypedef(dvTemp_.Module, dvTypedefNull), \
    dvModuleSetLastTypedef(dvTemp_.Module, dvTypedefNull), \
    dvModuleSetTypedefTableIndex(dvTemp_.Module, 0), \
    dvModuleSetNumTypedefTable(dvTemp_.Module, 0), \
    dvModuleSetNumTypedefTable(dvTemp_.Module, 0), \
    dvModuleSetNumTypedef(dvTemp_.Module, 0), \
    dvModuleSetFirstSchema(dvTemp_.Module, dvSchemaNull), \
    dvModuleSetLastSchema(dvTemp_.Module, dvSchemaNull), \
    dvModuleSetSchemaTableIndex(dvTemp_.Module, 0), \
    dvModuleSetNumSchemaTable(dvTemp_.Module, 0), \
    dvModuleSetNumSchemaTable(dvTemp_.Module, 0), \
    dvModuleSetNumSchema(dvTemp_.Module, 0), \
    dvModuleSetFirstImportLink(dvTemp_.Module, dvLinkNull), \
    dvModuleSetLastImportLink(dvTemp_.Module, dvLinkNull), \
    dvModuleSetFirstExportLink(dvTemp_.Module, dvLinkNull), \
    dvModuleSetLastExportLink(dvTemp_.Module, dvLinkNull), \
    dvModuleConstructorCallback != NULL && (dvModuleConstructorCallback(dvTemp_.Module), true), \
    dvTemp_.Module)

void dvModuleAllocMore(void);
void dvModuleCopyProps(dvModule dvOldModule, dvModule dvNewModule);
void dvModuleSetBitfield(dvModule _Module, uint32 bitfield);
uint32 dvModuleGetBitfield(dvModule _Module);
void dvModuleAllocClassTables(dvModule Module, uint32 numClassTables);
void dvModuleResizeClassTables(dvModule Module, uint32 numClassTables);
void dvModuleFreeClassTables(dvModule Module);
void dvCompactModuleClassTables(void);
void dvModuleAllocEnumTables(dvModule Module, uint32 numEnumTables);
void dvModuleResizeEnumTables(dvModule Module, uint32 numEnumTables);
void dvModuleFreeEnumTables(dvModule Module);
void dvCompactModuleEnumTables(void);
void dvModuleAllocTypedefTables(dvModule Module, uint32 numTypedefTables);
void dvModuleResizeTypedefTables(dvModule Module, uint32 numTypedefTables);
void dvModuleFreeTypedefTables(dvModule Module);
void dvCompactModuleTypedefTables(void);
void dvModuleAllocSchemaTables(dvModule Module, uint32 numSchemaTables);
void dvModuleResizeSchemaTables(dvModule Module, uint32 numSchemaTables);
void dvModuleFreeSchemaTables(dvModule Module);
void dvCompactModuleSchemaTables(void);
void dvModuleInsertClass(dvModule Module, dvClass _Class);
void dvModuleRemoveClass(dvModule Module, dvClass _Class);
void dvModuleInsertAfterClass(dvModule Module, dvClass prevClass, dvClass _Class);
void dvModuleAppendClass(dvModule Module, dvClass _Class);
void dvModuleInsertEnum(dvModule Module, dvEnum _Enum);
void dvModuleRemoveEnum(dvModule Module, dvEnum _Enum);
void dvModuleInsertAfterEnum(dvModule Module, dvEnum prevEnum, dvEnum _Enum);
void dvModuleAppendEnum(dvModule Module, dvEnum _Enum);
void dvModuleInsertTypedef(dvModule Module, dvTypedef _Typedef);
void dvModuleRemoveTypedef(dvModule Module, dvTypedef _Typedef);
void dvModuleInsertAfterTypedef(dvModule Module, dvTypedef prevTypedef, dvTypedef _Typedef);
void dvModuleAppendTypedef(dvModule Module, dvTypedef _Typedef);
void dvModuleInsertSchema(dvModule Module, dvSchema _Schema);
void dvModuleRemoveSchema(dvModule Module, dvSchema _Schema);
void dvModuleInsertAfterSchema(dvModule Module, dvSchema prevSchema, dvSchema _Schema);
void dvModuleAppendSchema(dvModule Module, dvSchema _Schema);
void dvModuleInsertImportLink(dvModule Module, dvLink _Link);
void dvModuleRemoveImportLink(dvModule Module, dvLink _Link);
void dvModuleInsertAfterImportLink(dvModule Module, dvLink prevLink, dvLink _Link);
void dvModuleAppendImportLink(dvModule Module, dvLink _Link);
void dvModuleInsertExportLink(dvModule Module, dvLink _Link);
void dvModuleRemoveExportLink(dvModule Module, dvLink _Link);
void dvModuleInsertAfterExportLink(dvModule Module, dvLink prevLink, dvLink _Link);
void dvModuleAppendExportLink(dvModule Module, dvLink _Link);

/*----------------------------------------------------------------------------------------
  Fields for class Link.
----------------------------------------------------------------------------------------*/
struct dvLinkFields {
    dvModule *ImportModule;
    dvLink *NextModuleImportLink;
    dvModule *ExportModule;
    dvLink *NextModuleExportLink;
};
extern struct dvLinkFields dvLinks;

#define dvLinkGetImportModule(_Link) (dvLinks.ImportModule[dvLink2ValidIndex(_Link)])
#define dvLinkSetImportModule(_Link, value) ((dvLinks.ImportModule)[dvLink2ValidIndex(_Link)] = (value))
#define dvLinkGetNextModuleImportLink(_Link) (dvLinks.NextModuleImportLink[dvLink2ValidIndex(_Link)])
#define dvLinkSetNextModuleImportLink(_Link, value) ((dvLinks.NextModuleImportLink)[dvLink2ValidIndex(_Link)] = (value))
#define dvLinkGetExportModule(_Link) (dvLinks.ExportModule[dvLink2ValidIndex(_Link)])
#define dvLinkSetExportModule(_Link, value) ((dvLinks.ExportModule)[dvLink2ValidIndex(_Link)] = (value))
#define dvLinkGetNextModuleExportLink(_Link) (dvLinks.NextModuleExportLink[dvLink2ValidIndex(_Link)])
#define dvLinkSetNextModuleExportLink(_Link, value) ((dvLinks.NextModuleExportLink)[dvLink2ValidIndex(_Link)] = (value))
#define dvLinkSetConstructorCallback(func) (dvLinkConstructorCallback = (func))
#define dvLinkGetConstructorCallback() (dvLinkConstructorCallback)
#define dvFirstLink() (dvRootData.usedLink == 0? dvLinkNull : dvIndex2Link(0))
#define dvLastLink() (dvRootData.usedLink == 0? dvLinkNull : \
    dvIndex2Link(dvRootData.usedLink - 1))
#define dvNextLink(Link) (dvLink2ValidIndex(Link) + 1 == dvRootData.usedLink? dvLinkNull : \
    (Link) + 1)
#define dvPrevLink(Link) (dvLink2ValidIndex(Link) == 0? dvLinkNull : (Link) - 1)
#define dvForeachLink(var) \
    for(var = dvIndex2Link(0); dvLink2Index(var) != dvRootData.usedLink; var++)
#define dvEndLink
#define dvLinkFreeAll() (dvSetUsedLink(0))
#define dvLinkAllocRaw() ( \
    dvRootData.usedLink == dvRootData.allocatedLink && (dvLinkAllocMore(), true), \
    dvTemp_.Link = dvIndex2Link(dvRootData.usedLink), \
    dvSetUsedLink(dvUsedLink() + 1), \
    dvTemp_.Link)
#define dvLinkAlloc() ( \
    dvRootData.usedLink == dvRootData.allocatedLink && (dvLinkAllocMore(), true), \
    dvTemp_.Link = dvIndex2Link(dvRootData.usedLink), \
    dvSetUsedLink(dvUsedLink() + 1), \
    dvLinkSetImportModule(dvTemp_.Link, dvModuleNull), \
    dvLinkSetNextModuleImportLink(dvTemp_.Link, dvLinkNull), \
    dvLinkSetExportModule(dvTemp_.Link, dvModuleNull), \
    dvLinkSetNextModuleExportLink(dvTemp_.Link, dvLinkNull), \
    dvLinkConstructorCallback != NULL && (dvLinkConstructorCallback(dvTemp_.Link), true), \
    dvTemp_.Link)

void dvLinkAllocMore(void);
void dvLinkCopyProps(dvLink dvOldLink, dvLink dvNewLink);

/*----------------------------------------------------------------------------------------
  Fields for class Schema.
----------------------------------------------------------------------------------------*/
struct dvSchemaFields {
    utSym *Sym;
    dvModule *Module;
    dvSchema *NextModuleSchema;
    dvSchema *PrevModuleSchema;
    dvSchema *NextTableModuleSchema;
    dvRelationship *FirstRelationship;
    dvRelationship *LastRelationship;
};
extern struct dvSchemaFields dvSchemas;

#define dvSchemaGetSym(_Schema) (dvSchemas.Sym[dvSchema2ValidIndex(_Schema)])
#define dvSchemaSetSym(_Schema, value) ((dvSchemas.Sym)[dvSchema2ValidIndex(_Schema)] = (value))
#define dvSchemaGetModule(_Schema) (dvSchemas.Module[dvSchema2ValidIndex(_Schema)])
#define dvSchemaSetModule(_Schema, value) ((dvSchemas.Module)[dvSchema2ValidIndex(_Schema)] = (value))
#define dvSchemaGetNextModuleSchema(_Schema) (dvSchemas.NextModuleSchema[dvSchema2ValidIndex(_Schema)])
#define dvSchemaSetNextModuleSchema(_Schema, value) ((dvSchemas.NextModuleSchema)[dvSchema2ValidIndex(_Schema)] = (value))
#define dvSchemaGetPrevModuleSchema(_Schema) (dvSchemas.PrevModuleSchema[dvSchema2ValidIndex(_Schema)])
#define dvSchemaSetPrevModuleSchema(_Schema, value) ((dvSchemas.PrevModuleSchema)[dvSchema2ValidIndex(_Schema)] = (value))
#define dvSchemaGetNextTableModuleSchema(_Schema) (dvSchemas.NextTableModuleSchema[dvSchema2ValidIndex(_Schema)])
#define dvSchemaSetNextTableModuleSchema(_Schema, value) ((dvSchemas.NextTableModuleSchema)[dvSchema2ValidIndex(_Schema)] = (value))
#define dvSchemaGetFirstRelationship(_Schema) (dvSchemas.FirstRelationship[dvSchema2ValidIndex(_Schema)])
#define dvSchemaSetFirstRelationship(_Schema, value) ((dvSchemas.FirstRelationship)[dvSchema2ValidIndex(_Schema)] = (value))
#define dvSchemaGetLastRelationship(_Schema) (dvSchemas.LastRelationship[dvSchema2ValidIndex(_Schema)])
#define dvSchemaSetLastRelationship(_Schema, value) ((dvSchemas.LastRelationship)[dvSchema2ValidIndex(_Schema)] = (value))
#define dvForeachSchemaRelationship(pVar, cVar) \
    for(cVar = dvSchemaGetFirstRelationship(pVar); cVar != dvRelationshipNull; \
        cVar = dvRelationshipGetNextSchemaRelationship(cVar))
#define dvEndSchemaRelationship
#define dvSafeForeachSchemaRelationship(pVar, cVar) { \
    dvRelationship _nextRelationship; \
    for(cVar = dvSchemaGetFirstRelationship(pVar); cVar != dvRelationshipNull; cVar = _nextRelationship) { \
        _nextRelationship = dvRelationshipGetNextSchemaRelationship(cVar);
#define dvEndSafeSchemaRelationship }}
#define dvSchemaSetConstructorCallback(func) (dvSchemaConstructorCallback = (func))
#define dvSchemaGetConstructorCallback() (dvSchemaConstructorCallback)
#define dvFirstSchema() (dvRootData.usedSchema == 0? dvSchemaNull : dvIndex2Schema(0))
#define dvLastSchema() (dvRootData.usedSchema == 0? dvSchemaNull : \
    dvIndex2Schema(dvRootData.usedSchema - 1))
#define dvNextSchema(Schema) (dvSchema2ValidIndex(Schema) + 1 == dvRootData.usedSchema? dvSchemaNull : \
    (Schema) + 1)
#define dvPrevSchema(Schema) (dvSchema2ValidIndex(Schema) == 0? dvSchemaNull : (Schema) - 1)
#define dvForeachSchema(var) \
    for(var = dvIndex2Schema(0); dvSchema2Index(var) != dvRootData.usedSchema; var++)
#define dvEndSchema
#define dvSchemaFreeAll() (dvSetUsedSchema(0))
#define dvSchemaAllocRaw() ( \
    dvRootData.usedSchema == dvRootData.allocatedSchema && (dvSchemaAllocMore(), true), \
    dvTemp_.Schema = dvIndex2Schema(dvRootData.usedSchema), \
    dvSetUsedSchema(dvUsedSchema() + 1), \
    dvTemp_.Schema)
#define dvSchemaAlloc() ( \
    dvRootData.usedSchema == dvRootData.allocatedSchema && (dvSchemaAllocMore(), true), \
    dvTemp_.Schema = dvIndex2Schema(dvRootData.usedSchema), \
    dvSetUsedSchema(dvUsedSchema() + 1), \
    dvSchemaSetSym(dvTemp_.Schema, utSymNull), \
    dvSchemaSetModule(dvTemp_.Schema, dvModuleNull), \
    dvSchemaSetNextModuleSchema(dvTemp_.Schema, dvSchemaNull), \
    dvSchemaSetPrevModuleSchema(dvTemp_.Schema, dvSchemaNull), \
    dvSchemaSetNextTableModuleSchema(dvTemp_.Schema, dvSchemaNull), \
    dvSchemaSetFirstRelationship(dvTemp_.Schema, dvRelationshipNull), \
    dvSchemaSetLastRelationship(dvTemp_.Schema, dvRelationshipNull), \
    dvSchemaConstructorCallback != NULL && (dvSchemaConstructorCallback(dvTemp_.Schema), true), \
    dvTemp_.Schema)

void dvSchemaAllocMore(void);
void dvSchemaCopyProps(dvSchema dvOldSchema, dvSchema dvNewSchema);
void dvSchemaInsertRelationship(dvSchema Schema, dvRelationship _Relationship);
void dvSchemaRemoveRelationship(dvSchema Schema, dvRelationship _Relationship);
void dvSchemaInsertAfterRelationship(dvSchema Schema, dvRelationship prevRelationship, dvRelationship _Relationship);
void dvSchemaAppendRelationship(dvSchema Schema, dvRelationship _Relationship);

/*----------------------------------------------------------------------------------------
  Fields for class Enum.
----------------------------------------------------------------------------------------*/
struct dvEnumFields {
    utSym *Sym;
    utSym *PrefixSym;
    uint16 *NumEntries;
    dvModule *Module;
    dvEnum *NextModuleEnum;
    dvEnum *PrevModuleEnum;
    dvEnum *NextTableModuleEnum;
    dvEntry *FirstEntry;
    dvEntry *LastEntry;
    uint32 *EntryTableIndex;
    uint32 *NumEntryTable;
    dvEntry *EntryTable;
    uint32 *NumEntry;
};
extern struct dvEnumFields dvEnums;

#define dvEnumGetSym(_Enum) (dvEnums.Sym[dvEnum2ValidIndex(_Enum)])
#define dvEnumSetSym(_Enum, value) ((dvEnums.Sym)[dvEnum2ValidIndex(_Enum)] = (value))
#define dvEnumGetPrefixSym(_Enum) (dvEnums.PrefixSym[dvEnum2ValidIndex(_Enum)])
#define dvEnumSetPrefixSym(_Enum, value) ((dvEnums.PrefixSym)[dvEnum2ValidIndex(_Enum)] = (value))
#define dvEnumGetNumEntries(_Enum) (dvEnums.NumEntries[dvEnum2ValidIndex(_Enum)])
#define dvEnumSetNumEntries(_Enum, value) ((dvEnums.NumEntries)[dvEnum2ValidIndex(_Enum)] = (value))
#define dvEnumGetModule(_Enum) (dvEnums.Module[dvEnum2ValidIndex(_Enum)])
#define dvEnumSetModule(_Enum, value) ((dvEnums.Module)[dvEnum2ValidIndex(_Enum)] = (value))
#define dvEnumGetNextModuleEnum(_Enum) (dvEnums.NextModuleEnum[dvEnum2ValidIndex(_Enum)])
#define dvEnumSetNextModuleEnum(_Enum, value) ((dvEnums.NextModuleEnum)[dvEnum2ValidIndex(_Enum)] = (value))
#define dvEnumGetPrevModuleEnum(_Enum) (dvEnums.PrevModuleEnum[dvEnum2ValidIndex(_Enum)])
#define dvEnumSetPrevModuleEnum(_Enum, value) ((dvEnums.PrevModuleEnum)[dvEnum2ValidIndex(_Enum)] = (value))
#define dvEnumGetNextTableModuleEnum(_Enum) (dvEnums.NextTableModuleEnum[dvEnum2ValidIndex(_Enum)])
#define dvEnumSetNextTableModuleEnum(_Enum, value) ((dvEnums.NextTableModuleEnum)[dvEnum2ValidIndex(_Enum)] = (value))
#define dvEnumGetFirstEntry(_Enum) (dvEnums.FirstEntry[dvEnum2ValidIndex(_Enum)])
#define dvEnumSetFirstEntry(_Enum, value) ((dvEnums.FirstEntry)[dvEnum2ValidIndex(_Enum)] = (value))
#define dvEnumGetLastEntry(_Enum) (dvEnums.LastEntry[dvEnum2ValidIndex(_Enum)])
#define dvEnumSetLastEntry(_Enum, value) ((dvEnums.LastEntry)[dvEnum2ValidIndex(_Enum)] = (value))
#define dvEnumGetEntryTableIndex(_Enum) (dvEnums.EntryTableIndex[dvEnum2ValidIndex(_Enum)])
#define dvEnumSetEntryTableIndex(_Enum, value) ((dvEnums.EntryTableIndex)[dvEnum2ValidIndex(_Enum)] = (value))
#define dvEnumGetNumEntryTable(_Enum) (dvEnums.NumEntryTable[dvEnum2ValidIndex(_Enum)])
#define dvEnumSetNumEntryTable(_Enum, value) ((dvEnums.NumEntryTable)[dvEnum2ValidIndex(_Enum)] = (value))
#if defined(DD_DEBUG)
#define dvEnumCheckEntryTableIndex(Enum, x) ((uint32)(x) < dvEnumGetNumEntryTable(Enum)? (x) : \
    (utAssert(false),(x)))
#else
#define dvEnumCheckEntryTableIndex(Enum, x) (x)
#endif
#define dvEnumGetiEntryTable(_Enum, x) ((dvEnums.EntryTable)[ \
    dvEnumGetEntryTableIndex(_Enum) + dvEnumCheckEntryTableIndex(_Enum, (x))])
#define dvEnumGetEntryTable(Enum) (dvEnums.EntryTable + dvEnumGetEntryTableIndex(Enum))
#define dvEnumGetEntryTables dvEnumGetEntryTable
#define dvEnumSetEntryTable(Enum, valuePtr, numEntryTable) (dvEnumResizeEntryTables(Enum, numEntryTable), memcpy(dvEnumGetEntryTables(Enum), valuePtr, \
    numEntryTable*sizeof(dvEntry)))
#define dvEnumSetiEntryTable(Enum, x, value) ((dvEnums.EntryTable)[ \
    dvEnumGetEntryTableIndex(Enum) + dvEnumCheckEntryTableIndex(Enum, (x))] = (value))
#define dvEnumGetNumEntry(_Enum) (dvEnums.NumEntry[dvEnum2ValidIndex(_Enum)])
#define dvEnumSetNumEntry(_Enum, value) ((dvEnums.NumEntry)[dvEnum2ValidIndex(_Enum)] = (value))
dvEntry dvEnumFindEntry(dvEnum Enum, utSym Sym);
void dvEnumRenameEntry(dvEnum Enum, dvEntry _Entry, utSym sym);
#define dvEntryGetName(Entry) utSymGetName(dvEntryGetSym(Entry))
#define dvForeachEnumEntry(pVar, cVar) \
    for(cVar = dvEnumGetFirstEntry(pVar); cVar != dvEntryNull; \
        cVar = dvEntryGetNextEnumEntry(cVar))
#define dvEndEnumEntry
#define dvSafeForeachEnumEntry(pVar, cVar) { \
    dvEntry _nextEntry; \
    for(cVar = dvEnumGetFirstEntry(pVar); cVar != dvEntryNull; cVar = _nextEntry) { \
        _nextEntry = dvEntryGetNextEnumEntry(cVar);
#define dvEndSafeEnumEntry }}
#define dvEnumSetConstructorCallback(func) (dvEnumConstructorCallback = (func))
#define dvEnumGetConstructorCallback() (dvEnumConstructorCallback)
#define dvFirstEnum() (dvRootData.usedEnum == 0? dvEnumNull : dvIndex2Enum(0))
#define dvLastEnum() (dvRootData.usedEnum == 0? dvEnumNull : \
    dvIndex2Enum(dvRootData.usedEnum - 1))
#define dvNextEnum(Enum) (dvEnum2ValidIndex(Enum) + 1 == dvRootData.usedEnum? dvEnumNull : \
    (Enum) + 1)
#define dvPrevEnum(Enum) (dvEnum2ValidIndex(Enum) == 0? dvEnumNull : (Enum) - 1)
#define dvForeachEnum(var) \
    for(var = dvIndex2Enum(0); dvEnum2Index(var) != dvRootData.usedEnum; var++)
#define dvEndEnum
#define dvEnumFreeAll() (dvSetUsedEnum(0), dvSetUsedEnumEntryTable(0))
#define dvEnumAllocRaw() ( \
    dvRootData.usedEnum == dvRootData.allocatedEnum && (dvEnumAllocMore(), true), \
    dvTemp_.Enum = dvIndex2Enum(dvRootData.usedEnum), \
    dvSetUsedEnum(dvUsedEnum() + 1), \
    dvTemp_.Enum)
#define dvEnumAlloc() ( \
    dvRootData.usedEnum == dvRootData.allocatedEnum && (dvEnumAllocMore(), true), \
    dvTemp_.Enum = dvIndex2Enum(dvRootData.usedEnum), \
    dvSetUsedEnum(dvUsedEnum() + 1), \
    dvEnumSetSym(dvTemp_.Enum, utSymNull), \
    dvEnumSetPrefixSym(dvTemp_.Enum, utSymNull), \
    dvEnumSetNumEntries(dvTemp_.Enum, 0), \
    dvEnumSetModule(dvTemp_.Enum, dvModuleNull), \
    dvEnumSetNextModuleEnum(dvTemp_.Enum, dvEnumNull), \
    dvEnumSetPrevModuleEnum(dvTemp_.Enum, dvEnumNull), \
    dvEnumSetNextTableModuleEnum(dvTemp_.Enum, dvEnumNull), \
    dvEnumSetFirstEntry(dvTemp_.Enum, dvEntryNull), \
    dvEnumSetLastEntry(dvTemp_.Enum, dvEntryNull), \
    dvEnumSetEntryTableIndex(dvTemp_.Enum, 0), \
    dvEnumSetNumEntryTable(dvTemp_.Enum, 0), \
    dvEnumSetNumEntryTable(dvTemp_.Enum, 0), \
    dvEnumSetNumEntry(dvTemp_.Enum, 0), \
    dvEnumConstructorCallback != NULL && (dvEnumConstructorCallback(dvTemp_.Enum), true), \
    dvTemp_.Enum)

void dvEnumAllocMore(void);
void dvEnumCopyProps(dvEnum dvOldEnum, dvEnum dvNewEnum);
void dvEnumAllocEntryTables(dvEnum Enum, uint32 numEntryTables);
void dvEnumResizeEntryTables(dvEnum Enum, uint32 numEntryTables);
void dvEnumFreeEntryTables(dvEnum Enum);
void dvCompactEnumEntryTables(void);
void dvEnumInsertEntry(dvEnum Enum, dvEntry _Entry);
void dvEnumRemoveEntry(dvEnum Enum, dvEntry _Entry);
void dvEnumInsertAfterEntry(dvEnum Enum, dvEntry prevEntry, dvEntry _Entry);
void dvEnumAppendEntry(dvEnum Enum, dvEntry _Entry);

/*----------------------------------------------------------------------------------------
  Fields for class Entry.
----------------------------------------------------------------------------------------*/
struct dvEntryFields {
    utSym *Sym;
    uint32 *Value;
    dvEnum *Enum;
    dvEntry *NextEnumEntry;
    dvEntry *PrevEnumEntry;
    dvEntry *NextTableEnumEntry;
    dvCase *FirstCase;
    dvCase *LastCase;
};
extern struct dvEntryFields dvEntrys;

#define dvEntryGetSym(_Entry) (dvEntrys.Sym[dvEntry2ValidIndex(_Entry)])
#define dvEntrySetSym(_Entry, value) ((dvEntrys.Sym)[dvEntry2ValidIndex(_Entry)] = (value))
#define dvEntryGetValue(_Entry) (dvEntrys.Value[dvEntry2ValidIndex(_Entry)])
#define dvEntrySetValue(_Entry, value) ((dvEntrys.Value)[dvEntry2ValidIndex(_Entry)] = (value))
#define dvEntryGetEnum(_Entry) (dvEntrys.Enum[dvEntry2ValidIndex(_Entry)])
#define dvEntrySetEnum(_Entry, value) ((dvEntrys.Enum)[dvEntry2ValidIndex(_Entry)] = (value))
#define dvEntryGetNextEnumEntry(_Entry) (dvEntrys.NextEnumEntry[dvEntry2ValidIndex(_Entry)])
#define dvEntrySetNextEnumEntry(_Entry, value) ((dvEntrys.NextEnumEntry)[dvEntry2ValidIndex(_Entry)] = (value))
#define dvEntryGetPrevEnumEntry(_Entry) (dvEntrys.PrevEnumEntry[dvEntry2ValidIndex(_Entry)])
#define dvEntrySetPrevEnumEntry(_Entry, value) ((dvEntrys.PrevEnumEntry)[dvEntry2ValidIndex(_Entry)] = (value))
#define dvEntryGetNextTableEnumEntry(_Entry) (dvEntrys.NextTableEnumEntry[dvEntry2ValidIndex(_Entry)])
#define dvEntrySetNextTableEnumEntry(_Entry, value) ((dvEntrys.NextTableEnumEntry)[dvEntry2ValidIndex(_Entry)] = (value))
#define dvEntryGetFirstCase(_Entry) (dvEntrys.FirstCase[dvEntry2ValidIndex(_Entry)])
#define dvEntrySetFirstCase(_Entry, value) ((dvEntrys.FirstCase)[dvEntry2ValidIndex(_Entry)] = (value))
#define dvEntryGetLastCase(_Entry) (dvEntrys.LastCase[dvEntry2ValidIndex(_Entry)])
#define dvEntrySetLastCase(_Entry, value) ((dvEntrys.LastCase)[dvEntry2ValidIndex(_Entry)] = (value))
#define dvForeachEntryCase(pVar, cVar) \
    for(cVar = dvEntryGetFirstCase(pVar); cVar != dvCaseNull; \
        cVar = dvCaseGetNextEntryCase(cVar))
#define dvEndEntryCase
#define dvSafeForeachEntryCase(pVar, cVar) { \
    dvCase _nextCase; \
    for(cVar = dvEntryGetFirstCase(pVar); cVar != dvCaseNull; cVar = _nextCase) { \
        _nextCase = dvCaseGetNextEntryCase(cVar);
#define dvEndSafeEntryCase }}
#define dvEntrySetConstructorCallback(func) (dvEntryConstructorCallback = (func))
#define dvEntryGetConstructorCallback() (dvEntryConstructorCallback)
#define dvFirstEntry() (dvRootData.usedEntry == 0? dvEntryNull : dvIndex2Entry(0))
#define dvLastEntry() (dvRootData.usedEntry == 0? dvEntryNull : \
    dvIndex2Entry(dvRootData.usedEntry - 1))
#define dvNextEntry(Entry) (dvEntry2ValidIndex(Entry) + 1 == dvRootData.usedEntry? dvEntryNull : \
    (Entry) + 1)
#define dvPrevEntry(Entry) (dvEntry2ValidIndex(Entry) == 0? dvEntryNull : (Entry) - 1)
#define dvForeachEntry(var) \
    for(var = dvIndex2Entry(0); dvEntry2Index(var) != dvRootData.usedEntry; var++)
#define dvEndEntry
#define dvEntryFreeAll() (dvSetUsedEntry(0))
#define dvEntryAllocRaw() ( \
    dvRootData.usedEntry == dvRootData.allocatedEntry && (dvEntryAllocMore(), true), \
    dvTemp_.Entry = dvIndex2Entry(dvRootData.usedEntry), \
    dvSetUsedEntry(dvUsedEntry() + 1), \
    dvTemp_.Entry)
#define dvEntryAlloc() ( \
    dvRootData.usedEntry == dvRootData.allocatedEntry && (dvEntryAllocMore(), true), \
    dvTemp_.Entry = dvIndex2Entry(dvRootData.usedEntry), \
    dvSetUsedEntry(dvUsedEntry() + 1), \
    dvEntrySetSym(dvTemp_.Entry, utSymNull), \
    dvEntrySetValue(dvTemp_.Entry, 0), \
    dvEntrySetEnum(dvTemp_.Entry, dvEnumNull), \
    dvEntrySetNextEnumEntry(dvTemp_.Entry, dvEntryNull), \
    dvEntrySetPrevEnumEntry(dvTemp_.Entry, dvEntryNull), \
    dvEntrySetNextTableEnumEntry(dvTemp_.Entry, dvEntryNull), \
    dvEntrySetFirstCase(dvTemp_.Entry, dvCaseNull), \
    dvEntrySetLastCase(dvTemp_.Entry, dvCaseNull), \
    dvEntryConstructorCallback != NULL && (dvEntryConstructorCallback(dvTemp_.Entry), true), \
    dvTemp_.Entry)

void dvEntryAllocMore(void);
void dvEntryCopyProps(dvEntry dvOldEntry, dvEntry dvNewEntry);
void dvEntryInsertCase(dvEntry Entry, dvCase _Case);
void dvEntryRemoveCase(dvEntry Entry, dvCase _Case);
void dvEntryInsertAfterCase(dvEntry Entry, dvCase prevCase, dvCase _Case);
void dvEntryAppendCase(dvEntry Entry, dvCase _Case);

/*----------------------------------------------------------------------------------------
  Fields for class Typedef.
----------------------------------------------------------------------------------------*/
struct dvTypedefFields {
    utSym *Sym;
    uint32 *InitializerIndex;
    uint32 *NumInitializer;
    char *Initializer;
    dvModule *Module;
    dvTypedef *NextModuleTypedef;
    dvTypedef *PrevModuleTypedef;
    dvTypedef *NextTableModuleTypedef;
};
extern struct dvTypedefFields dvTypedefs;

#define dvTypedefGetSym(_Typedef) (dvTypedefs.Sym[dvTypedef2ValidIndex(_Typedef)])
#define dvTypedefSetSym(_Typedef, value) ((dvTypedefs.Sym)[dvTypedef2ValidIndex(_Typedef)] = (value))
#define dvTypedefGetInitializerIndex(_Typedef) (dvTypedefs.InitializerIndex[dvTypedef2ValidIndex(_Typedef)])
#define dvTypedefSetInitializerIndex(_Typedef, value) ((dvTypedefs.InitializerIndex)[dvTypedef2ValidIndex(_Typedef)] = (value))
#define dvTypedefGetNumInitializer(_Typedef) (dvTypedefs.NumInitializer[dvTypedef2ValidIndex(_Typedef)])
#define dvTypedefSetNumInitializer(_Typedef, value) ((dvTypedefs.NumInitializer)[dvTypedef2ValidIndex(_Typedef)] = (value))
#if defined(DD_DEBUG)
#define dvTypedefCheckInitializerIndex(Typedef, x) ((uint32)(x) < dvTypedefGetNumInitializer(Typedef)? (x) : \
    (utAssert(false),(x)))
#else
#define dvTypedefCheckInitializerIndex(Typedef, x) (x)
#endif
#define dvTypedefGetiInitializer(_Typedef, x) ((dvTypedefs.Initializer)[ \
    dvTypedefGetInitializerIndex(_Typedef) + dvTypedefCheckInitializerIndex(_Typedef, (x))])
#define dvTypedefGetInitializer(Typedef) (dvTypedefs.Initializer + dvTypedefGetInitializerIndex(Typedef))
#define dvTypedefGetInitializers dvTypedefGetInitializer
#define dvTypedefSetInitializer(Typedef, valuePtr, numInitializer) (dvTypedefResizeInitializers(Typedef, numInitializer), memcpy(dvTypedefGetInitializers(Typedef), valuePtr, \
    numInitializer*sizeof(char)))
#define dvTypedefSetiInitializer(Typedef, x, value) ((dvTypedefs.Initializer)[ \
    dvTypedefGetInitializerIndex(Typedef) + dvTypedefCheckInitializerIndex(Typedef, (x))] = (value))
#define dvTypedefGetModule(_Typedef) (dvTypedefs.Module[dvTypedef2ValidIndex(_Typedef)])
#define dvTypedefSetModule(_Typedef, value) ((dvTypedefs.Module)[dvTypedef2ValidIndex(_Typedef)] = (value))
#define dvTypedefGetNextModuleTypedef(_Typedef) (dvTypedefs.NextModuleTypedef[dvTypedef2ValidIndex(_Typedef)])
#define dvTypedefSetNextModuleTypedef(_Typedef, value) ((dvTypedefs.NextModuleTypedef)[dvTypedef2ValidIndex(_Typedef)] = (value))
#define dvTypedefGetPrevModuleTypedef(_Typedef) (dvTypedefs.PrevModuleTypedef[dvTypedef2ValidIndex(_Typedef)])
#define dvTypedefSetPrevModuleTypedef(_Typedef, value) ((dvTypedefs.PrevModuleTypedef)[dvTypedef2ValidIndex(_Typedef)] = (value))
#define dvTypedefGetNextTableModuleTypedef(_Typedef) (dvTypedefs.NextTableModuleTypedef[dvTypedef2ValidIndex(_Typedef)])
#define dvTypedefSetNextTableModuleTypedef(_Typedef, value) ((dvTypedefs.NextTableModuleTypedef)[dvTypedef2ValidIndex(_Typedef)] = (value))
#define dvTypedefSetConstructorCallback(func) (dvTypedefConstructorCallback = (func))
#define dvTypedefGetConstructorCallback() (dvTypedefConstructorCallback)
#define dvFirstTypedef() (dvRootData.usedTypedef == 0? dvTypedefNull : dvIndex2Typedef(0))
#define dvLastTypedef() (dvRootData.usedTypedef == 0? dvTypedefNull : \
    dvIndex2Typedef(dvRootData.usedTypedef - 1))
#define dvNextTypedef(Typedef) (dvTypedef2ValidIndex(Typedef) + 1 == dvRootData.usedTypedef? dvTypedefNull : \
    (Typedef) + 1)
#define dvPrevTypedef(Typedef) (dvTypedef2ValidIndex(Typedef) == 0? dvTypedefNull : (Typedef) - 1)
#define dvForeachTypedef(var) \
    for(var = dvIndex2Typedef(0); dvTypedef2Index(var) != dvRootData.usedTypedef; var++)
#define dvEndTypedef
#define dvTypedefFreeAll() (dvSetUsedTypedef(0), dvSetUsedTypedefInitializer(0))
#define dvTypedefAllocRaw() ( \
    dvRootData.usedTypedef == dvRootData.allocatedTypedef && (dvTypedefAllocMore(), true), \
    dvTemp_.Typedef = dvIndex2Typedef(dvRootData.usedTypedef), \
    dvSetUsedTypedef(dvUsedTypedef() + 1), \
    dvTemp_.Typedef)
#define dvTypedefAlloc() ( \
    dvRootData.usedTypedef == dvRootData.allocatedTypedef && (dvTypedefAllocMore(), true), \
    dvTemp_.Typedef = dvIndex2Typedef(dvRootData.usedTypedef), \
    dvSetUsedTypedef(dvUsedTypedef() + 1), \
    dvTypedefSetSym(dvTemp_.Typedef, utSymNull), \
    dvTypedefSetInitializerIndex(dvTemp_.Typedef, 0), \
    dvTypedefSetNumInitializer(dvTemp_.Typedef, 0), \
    dvTypedefSetNumInitializer(dvTemp_.Typedef, 0), \
    dvTypedefSetModule(dvTemp_.Typedef, dvModuleNull), \
    dvTypedefSetNextModuleTypedef(dvTemp_.Typedef, dvTypedefNull), \
    dvTypedefSetPrevModuleTypedef(dvTemp_.Typedef, dvTypedefNull), \
    dvTypedefSetNextTableModuleTypedef(dvTemp_.Typedef, dvTypedefNull), \
    dvTypedefConstructorCallback != NULL && (dvTypedefConstructorCallback(dvTemp_.Typedef), true), \
    dvTemp_.Typedef)

void dvTypedefAllocMore(void);
void dvTypedefCopyProps(dvTypedef dvOldTypedef, dvTypedef dvNewTypedef);
void dvTypedefAllocInitializers(dvTypedef Typedef, uint32 numInitializers);
void dvTypedefResizeInitializers(dvTypedef Typedef, uint32 numInitializers);
void dvTypedefFreeInitializers(dvTypedef Typedef);
void dvCompactTypedefInitializers(void);

/*----------------------------------------------------------------------------------------
  Fields for class Class.
----------------------------------------------------------------------------------------*/
struct dvClassFields {
    utSym *Sym;
    dvMemoryStyle *MemoryStyle;
    uint8 *ReferenceSize;
    uint8 *GenerateArrayClass;
    uint8 *GenerateAttributes;
    uint8 *Sparse;
    uint16 *NumFields;
    uint16 *Number;
    dvModule *Module;
    dvClass *NextModuleClass;
    dvClass *PrevModuleClass;
    dvClass *NextTableModuleClass;
    dvProperty *FirstProperty;
    dvProperty *LastProperty;
    uint32 *PropertyTableIndex;
    uint32 *NumPropertyTable;
    dvProperty *PropertyTable;
    uint32 *NumProperty;
    dvProperty *FreeListProperty;
    dvSparsegroup *FirstSparsegroup;
    dvSparsegroup *LastSparsegroup;
    uint32 *SparsegroupTableIndex;
    uint32 *NumSparsegroupTable;
    dvSparsegroup *SparsegroupTable;
    uint32 *NumSparsegroup;
    dvClass *BaseClass;
    dvClass *FirstDerivedClass;
    dvClass *NextClassDerivedClass;
    dvClass *LastDerivedClass;
    dvRelationship *FirstChildRelationship;
    dvRelationship *LastChildRelationship;
    dvRelationship *FirstParentRelationship;
    dvRelationship *LastParentRelationship;
    dvUnion *FirstUnion;
    dvUnion *LastUnion;
};
extern struct dvClassFields dvClasss;

#define dvClassGetSym(_Class) (dvClasss.Sym[dvClass2ValidIndex(_Class)])
#define dvClassSetSym(_Class, value) ((dvClasss.Sym)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetMemoryStyle(_Class) (dvClasss.MemoryStyle[dvClass2ValidIndex(_Class)])
#define dvClassSetMemoryStyle(_Class, value) ((dvClasss.MemoryStyle)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetReferenceSize(_Class) (dvClasss.ReferenceSize[dvClass2ValidIndex(_Class)])
#define dvClassSetReferenceSize(_Class, value) ((dvClasss.ReferenceSize)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGenerateArrayClass(_Class) (((dvClasss.GenerateArrayClass)[dvClass2ValidIndex(_Class) >> 3] >> \
    (dvClass2ValidIndex(_Class) & 7)) & 1)
#define dvClassSetGenerateArrayClass(_Class, value) ((dvClasss.GenerateArrayClass)[dvClass2ValidIndex(_Class) >> 3] = \
    (uint8)(((dvClasss.GenerateArrayClass)[dvClass2ValidIndex(_Class) >> 3] & ~(1 << (dvClass2ValidIndex(_Class) & 7))) | \
    (((value) != 0) << (dvClass2ValidIndex(_Class) & 7))))
#define dvClassGenerateAttributes(_Class) (((dvClasss.GenerateAttributes)[dvClass2ValidIndex(_Class) >> 3] >> \
    (dvClass2ValidIndex(_Class) & 7)) & 1)
#define dvClassSetGenerateAttributes(_Class, value) ((dvClasss.GenerateAttributes)[dvClass2ValidIndex(_Class) >> 3] = \
    (uint8)(((dvClasss.GenerateAttributes)[dvClass2ValidIndex(_Class) >> 3] & ~(1 << (dvClass2ValidIndex(_Class) & 7))) | \
    (((value) != 0) << (dvClass2ValidIndex(_Class) & 7))))
#define dvClassSparse(_Class) (((dvClasss.Sparse)[dvClass2ValidIndex(_Class) >> 3] >> \
    (dvClass2ValidIndex(_Class) & 7)) & 1)
#define dvClassSetSparse(_Class, value) ((dvClasss.Sparse)[dvClass2ValidIndex(_Class) >> 3] = \
    (uint8)(((dvClasss.Sparse)[dvClass2ValidIndex(_Class) >> 3] & ~(1 << (dvClass2ValidIndex(_Class) & 7))) | \
    (((value) != 0) << (dvClass2ValidIndex(_Class) & 7))))
#define dvClassGetNumFields(_Class) (dvClasss.NumFields[dvClass2ValidIndex(_Class)])
#define dvClassSetNumFields(_Class, value) ((dvClasss.NumFields)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetNumber(_Class) (dvClasss.Number[dvClass2ValidIndex(_Class)])
#define dvClassSetNumber(_Class, value) ((dvClasss.Number)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetModule(_Class) (dvClasss.Module[dvClass2ValidIndex(_Class)])
#define dvClassSetModule(_Class, value) ((dvClasss.Module)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetNextModuleClass(_Class) (dvClasss.NextModuleClass[dvClass2ValidIndex(_Class)])
#define dvClassSetNextModuleClass(_Class, value) ((dvClasss.NextModuleClass)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetPrevModuleClass(_Class) (dvClasss.PrevModuleClass[dvClass2ValidIndex(_Class)])
#define dvClassSetPrevModuleClass(_Class, value) ((dvClasss.PrevModuleClass)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetNextTableModuleClass(_Class) (dvClasss.NextTableModuleClass[dvClass2ValidIndex(_Class)])
#define dvClassSetNextTableModuleClass(_Class, value) ((dvClasss.NextTableModuleClass)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetFirstProperty(_Class) (dvClasss.FirstProperty[dvClass2ValidIndex(_Class)])
#define dvClassSetFirstProperty(_Class, value) ((dvClasss.FirstProperty)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetLastProperty(_Class) (dvClasss.LastProperty[dvClass2ValidIndex(_Class)])
#define dvClassSetLastProperty(_Class, value) ((dvClasss.LastProperty)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetPropertyTableIndex(_Class) (dvClasss.PropertyTableIndex[dvClass2ValidIndex(_Class)])
#define dvClassSetPropertyTableIndex(_Class, value) ((dvClasss.PropertyTableIndex)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetNumPropertyTable(_Class) (dvClasss.NumPropertyTable[dvClass2ValidIndex(_Class)])
#define dvClassSetNumPropertyTable(_Class, value) ((dvClasss.NumPropertyTable)[dvClass2ValidIndex(_Class)] = (value))
#if defined(DD_DEBUG)
#define dvClassCheckPropertyTableIndex(Class, x) ((uint32)(x) < dvClassGetNumPropertyTable(Class)? (x) : \
    (utAssert(false),(x)))
#else
#define dvClassCheckPropertyTableIndex(Class, x) (x)
#endif
#define dvClassGetiPropertyTable(_Class, x) ((dvClasss.PropertyTable)[ \
    dvClassGetPropertyTableIndex(_Class) + dvClassCheckPropertyTableIndex(_Class, (x))])
#define dvClassGetPropertyTable(Class) (dvClasss.PropertyTable + dvClassGetPropertyTableIndex(Class))
#define dvClassGetPropertyTables dvClassGetPropertyTable
#define dvClassSetPropertyTable(Class, valuePtr, numPropertyTable) (dvClassResizePropertyTables(Class, numPropertyTable), memcpy(dvClassGetPropertyTables(Class), valuePtr, \
    numPropertyTable*sizeof(dvProperty)))
#define dvClassSetiPropertyTable(Class, x, value) ((dvClasss.PropertyTable)[ \
    dvClassGetPropertyTableIndex(Class) + dvClassCheckPropertyTableIndex(Class, (x))] = (value))
#define dvClassGetNumProperty(_Class) (dvClasss.NumProperty[dvClass2ValidIndex(_Class)])
#define dvClassSetNumProperty(_Class, value) ((dvClasss.NumProperty)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetFreeListProperty(_Class) (dvClasss.FreeListProperty[dvClass2ValidIndex(_Class)])
#define dvClassSetFreeListProperty(_Class, value) ((dvClasss.FreeListProperty)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetFirstSparsegroup(_Class) (dvClasss.FirstSparsegroup[dvClass2ValidIndex(_Class)])
#define dvClassSetFirstSparsegroup(_Class, value) ((dvClasss.FirstSparsegroup)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetLastSparsegroup(_Class) (dvClasss.LastSparsegroup[dvClass2ValidIndex(_Class)])
#define dvClassSetLastSparsegroup(_Class, value) ((dvClasss.LastSparsegroup)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetSparsegroupTableIndex(_Class) (dvClasss.SparsegroupTableIndex[dvClass2ValidIndex(_Class)])
#define dvClassSetSparsegroupTableIndex(_Class, value) ((dvClasss.SparsegroupTableIndex)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetNumSparsegroupTable(_Class) (dvClasss.NumSparsegroupTable[dvClass2ValidIndex(_Class)])
#define dvClassSetNumSparsegroupTable(_Class, value) ((dvClasss.NumSparsegroupTable)[dvClass2ValidIndex(_Class)] = (value))
#if defined(DD_DEBUG)
#define dvClassCheckSparsegroupTableIndex(Class, x) ((uint32)(x) < dvClassGetNumSparsegroupTable(Class)? (x) : \
    (utAssert(false),(x)))
#else
#define dvClassCheckSparsegroupTableIndex(Class, x) (x)
#endif
#define dvClassGetiSparsegroupTable(_Class, x) ((dvClasss.SparsegroupTable)[ \
    dvClassGetSparsegroupTableIndex(_Class) + dvClassCheckSparsegroupTableIndex(_Class, (x))])
#define dvClassGetSparsegroupTable(Class) (dvClasss.SparsegroupTable + dvClassGetSparsegroupTableIndex(Class))
#define dvClassGetSparsegroupTables dvClassGetSparsegroupTable
#define dvClassSetSparsegroupTable(Class, valuePtr, numSparsegroupTable) (dvClassResizeSparsegroupTables(Class, numSparsegroupTable), memcpy(dvClassGetSparsegroupTables(Class), valuePtr, \
    numSparsegroupTable*sizeof(dvSparsegroup)))
#define dvClassSetiSparsegroupTable(Class, x, value) ((dvClasss.SparsegroupTable)[ \
    dvClassGetSparsegroupTableIndex(Class) + dvClassCheckSparsegroupTableIndex(Class, (x))] = (value))
#define dvClassGetNumSparsegroup(_Class) (dvClasss.NumSparsegroup[dvClass2ValidIndex(_Class)])
#define dvClassSetNumSparsegroup(_Class, value) ((dvClasss.NumSparsegroup)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetBaseClass(_Class) (dvClasss.BaseClass[dvClass2ValidIndex(_Class)])
#define dvClassSetBaseClass(_Class, value) ((dvClasss.BaseClass)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetFirstDerivedClass(_Class) (dvClasss.FirstDerivedClass[dvClass2ValidIndex(_Class)])
#define dvClassSetFirstDerivedClass(_Class, value) ((dvClasss.FirstDerivedClass)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetNextClassDerivedClass(_Class) (dvClasss.NextClassDerivedClass[dvClass2ValidIndex(_Class)])
#define dvClassSetNextClassDerivedClass(_Class, value) ((dvClasss.NextClassDerivedClass)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetLastDerivedClass(_Class) (dvClasss.LastDerivedClass[dvClass2ValidIndex(_Class)])
#define dvClassSetLastDerivedClass(_Class, value) ((dvClasss.LastDerivedClass)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetFirstChildRelationship(_Class) (dvClasss.FirstChildRelationship[dvClass2ValidIndex(_Class)])
#define dvClassSetFirstChildRelationship(_Class, value) ((dvClasss.FirstChildRelationship)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetLastChildRelationship(_Class) (dvClasss.LastChildRelationship[dvClass2ValidIndex(_Class)])
#define dvClassSetLastChildRelationship(_Class, value) ((dvClasss.LastChildRelationship)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetFirstParentRelationship(_Class) (dvClasss.FirstParentRelationship[dvClass2ValidIndex(_Class)])
#define dvClassSetFirstParentRelationship(_Class, value) ((dvClasss.FirstParentRelationship)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetLastParentRelationship(_Class) (dvClasss.LastParentRelationship[dvClass2ValidIndex(_Class)])
#define dvClassSetLastParentRelationship(_Class, value) ((dvClasss.LastParentRelationship)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetFirstUnion(_Class) (dvClasss.FirstUnion[dvClass2ValidIndex(_Class)])
#define dvClassSetFirstUnion(_Class, value) ((dvClasss.FirstUnion)[dvClass2ValidIndex(_Class)] = (value))
#define dvClassGetLastUnion(_Class) (dvClasss.LastUnion[dvClass2ValidIndex(_Class)])
#define dvClassSetLastUnion(_Class, value) ((dvClasss.LastUnion)[dvClass2ValidIndex(_Class)] = (value))
dvProperty dvClassFindProperty(dvClass Class, utSym Sym);
void dvClassRenameProperty(dvClass Class, dvProperty _Property, utSym sym);
#define dvPropertyGetName(Property) utSymGetName(dvPropertyGetSym(Property))
#define dvForeachClassProperty(pVar, cVar) \
    for(cVar = dvClassGetFirstProperty(pVar); cVar != dvPropertyNull; \
        cVar = dvPropertyGetNextClassProperty(cVar))
#define dvEndClassProperty
#define dvSafeForeachClassProperty(pVar, cVar) { \
    dvProperty _nextProperty; \
    for(cVar = dvClassGetFirstProperty(pVar); cVar != dvPropertyNull; cVar = _nextProperty) { \
        _nextProperty = dvPropertyGetNextClassProperty(cVar);
#define dvEndSafeClassProperty }}
dvSparsegroup dvClassFindSparsegroup(dvClass Class, utSym Sym);
void dvClassRenameSparsegroup(dvClass Class, dvSparsegroup _Sparsegroup, utSym sym);
#define dvSparsegroupGetName(Sparsegroup) utSymGetName(dvSparsegroupGetSym(Sparsegroup))
#define dvForeachClassSparsegroup(pVar, cVar) \
    for(cVar = dvClassGetFirstSparsegroup(pVar); cVar != dvSparsegroupNull; \
        cVar = dvSparsegroupGetNextClassSparsegroup(cVar))
#define dvEndClassSparsegroup
#define dvSafeForeachClassSparsegroup(pVar, cVar) { \
    dvSparsegroup _nextSparsegroup; \
    for(cVar = dvClassGetFirstSparsegroup(pVar); cVar != dvSparsegroupNull; cVar = _nextSparsegroup) { \
        _nextSparsegroup = dvSparsegroupGetNextClassSparsegroup(cVar);
#define dvEndSafeClassSparsegroup }}
#define dvForeachClassDerivedClass(pVar, cVar) \
    for(cVar = dvClassGetFirstDerivedClass(pVar); cVar != dvClassNull; \
        cVar = dvClassGetNextClassDerivedClass(cVar))
#define dvEndClassDerivedClass
#define dvSafeForeachClassDerivedClass(pVar, cVar) { \
    dvClass _nextClass; \
    for(cVar = dvClassGetFirstDerivedClass(pVar); cVar != dvClassNull; cVar = _nextClass) { \
        _nextClass = dvClassGetNextClassDerivedClass(cVar);
#define dvEndSafeClassDerivedClass }}
#define dvForeachClassChildRelationship(pVar, cVar) \
    for(cVar = dvClassGetFirstChildRelationship(pVar); cVar != dvRelationshipNull; \
        cVar = dvRelationshipGetNextClassChildRelationship(cVar))
#define dvEndClassChildRelationship
#define dvSafeForeachClassChildRelationship(pVar, cVar) { \
    dvRelationship _nextRelationship; \
    for(cVar = dvClassGetFirstChildRelationship(pVar); cVar != dvRelationshipNull; cVar = _nextRelationship) { \
        _nextRelationship = dvRelationshipGetNextClassChildRelationship(cVar);
#define dvEndSafeClassChildRelationship }}
#define dvForeachClassParentRelationship(pVar, cVar) \
    for(cVar = dvClassGetFirstParentRelationship(pVar); cVar != dvRelationshipNull; \
        cVar = dvRelationshipGetNextClassParentRelationship(cVar))
#define dvEndClassParentRelationship
#define dvSafeForeachClassParentRelationship(pVar, cVar) { \
    dvRelationship _nextRelationship; \
    for(cVar = dvClassGetFirstParentRelationship(pVar); cVar != dvRelationshipNull; cVar = _nextRelationship) { \
        _nextRelationship = dvRelationshipGetNextClassParentRelationship(cVar);
#define dvEndSafeClassParentRelationship }}
#define dvForeachClassUnion(pVar, cVar) \
    for(cVar = dvClassGetFirstUnion(pVar); cVar != dvUnionNull; \
        cVar = dvUnionGetNextClassUnion(cVar))
#define dvEndClassUnion
#define dvSafeForeachClassUnion(pVar, cVar) { \
    dvUnion _nextUnion; \
    for(cVar = dvClassGetFirstUnion(pVar); cVar != dvUnionNull; cVar = _nextUnion) { \
        _nextUnion = dvUnionGetNextClassUnion(cVar);
#define dvEndSafeClassUnion }}
#define dvClassSetConstructorCallback(func) (dvClassConstructorCallback = (func))
#define dvClassGetConstructorCallback() (dvClassConstructorCallback)
#define dvFirstClass() (dvRootData.usedClass == 0? dvClassNull : dvIndex2Class(0))
#define dvLastClass() (dvRootData.usedClass == 0? dvClassNull : \
    dvIndex2Class(dvRootData.usedClass - 1))
#define dvNextClass(Class) (dvClass2ValidIndex(Class) + 1 == dvRootData.usedClass? dvClassNull : \
    (Class) + 1)
#define dvPrevClass(Class) (dvClass2ValidIndex(Class) == 0? dvClassNull : (Class) - 1)
#define dvForeachClass(var) \
    for(var = dvIndex2Class(0); dvClass2Index(var) != dvRootData.usedClass; var++)
#define dvEndClass
#define dvClassFreeAll() (dvSetUsedClass(0), dvSetUsedClassPropertyTable(0), dvSetUsedClassSparsegroupTable(0))
#define dvClassAllocRaw() ( \
    dvRootData.usedClass == dvRootData.allocatedClass && (dvClassAllocMore(), true), \
    dvTemp_.Class = dvIndex2Class(dvRootData.usedClass), \
    dvSetUsedClass(dvUsedClass() + 1), \
    dvTemp_.Class)
#define dvClassAlloc() ( \
    dvRootData.usedClass == dvRootData.allocatedClass && (dvClassAllocMore(), true), \
    dvTemp_.Class = dvIndex2Class(dvRootData.usedClass), \
    dvSetUsedClass(dvUsedClass() + 1), \
    dvClassSetSym(dvTemp_.Class, utSymNull), \
    dvClassSetMemoryStyle(dvTemp_.Class, 0), \
    dvClassSetReferenceSize(dvTemp_.Class, 0), \
    dvClassSetGenerateArrayClass(dvTemp_.Class, 0), \
    dvClassSetGenerateAttributes(dvTemp_.Class, 0), \
    dvClassSetSparse(dvTemp_.Class, 0), \
    dvClassSetNumFields(dvTemp_.Class, 0), \
    dvClassSetNumber(dvTemp_.Class, 0), \
    dvClassSetModule(dvTemp_.Class, dvModuleNull), \
    dvClassSetNextModuleClass(dvTemp_.Class, dvClassNull), \
    dvClassSetPrevModuleClass(dvTemp_.Class, dvClassNull), \
    dvClassSetNextTableModuleClass(dvTemp_.Class, dvClassNull), \
    dvClassSetFirstProperty(dvTemp_.Class, dvPropertyNull), \
    dvClassSetLastProperty(dvTemp_.Class, dvPropertyNull), \
    dvClassSetPropertyTableIndex(dvTemp_.Class, 0), \
    dvClassSetNumPropertyTable(dvTemp_.Class, 0), \
    dvClassSetNumPropertyTable(dvTemp_.Class, 0), \
    dvClassSetNumProperty(dvTemp_.Class, 0), \
    dvClassSetFreeListProperty(dvTemp_.Class, dvPropertyNull), \
    dvClassSetFirstSparsegroup(dvTemp_.Class, dvSparsegroupNull), \
    dvClassSetLastSparsegroup(dvTemp_.Class, dvSparsegroupNull), \
    dvClassSetSparsegroupTableIndex(dvTemp_.Class, 0), \
    dvClassSetNumSparsegroupTable(dvTemp_.Class, 0), \
    dvClassSetNumSparsegroupTable(dvTemp_.Class, 0), \
    dvClassSetNumSparsegroup(dvTemp_.Class, 0), \
    dvClassSetBaseClass(dvTemp_.Class, dvClassNull), \
    dvClassSetFirstDerivedClass(dvTemp_.Class, dvClassNull), \
    dvClassSetNextClassDerivedClass(dvTemp_.Class, dvClassNull), \
    dvClassSetLastDerivedClass(dvTemp_.Class, dvClassNull), \
    dvClassSetFirstChildRelationship(dvTemp_.Class, dvRelationshipNull), \
    dvClassSetLastChildRelationship(dvTemp_.Class, dvRelationshipNull), \
    dvClassSetFirstParentRelationship(dvTemp_.Class, dvRelationshipNull), \
    dvClassSetLastParentRelationship(dvTemp_.Class, dvRelationshipNull), \
    dvClassSetFirstUnion(dvTemp_.Class, dvUnionNull), \
    dvClassSetLastUnion(dvTemp_.Class, dvUnionNull), \
    dvClassConstructorCallback != NULL && (dvClassConstructorCallback(dvTemp_.Class), true), \
    dvTemp_.Class)

void dvClassAllocMore(void);
void dvClassCopyProps(dvClass dvOldClass, dvClass dvNewClass);
void dvClassSetBitfield(dvClass _Class, uint32 bitfield);
uint32 dvClassGetBitfield(dvClass _Class);
void dvClassAllocPropertyTables(dvClass Class, uint32 numPropertyTables);
void dvClassResizePropertyTables(dvClass Class, uint32 numPropertyTables);
void dvClassFreePropertyTables(dvClass Class);
void dvCompactClassPropertyTables(void);
void dvClassAllocSparsegroupTables(dvClass Class, uint32 numSparsegroupTables);
void dvClassResizeSparsegroupTables(dvClass Class, uint32 numSparsegroupTables);
void dvClassFreeSparsegroupTables(dvClass Class);
void dvCompactClassSparsegroupTables(void);
void dvClassInsertProperty(dvClass Class, dvProperty _Property);
void dvClassRemoveProperty(dvClass Class, dvProperty _Property);
void dvClassInsertAfterProperty(dvClass Class, dvProperty prevProperty, dvProperty _Property);
void dvClassAppendProperty(dvClass Class, dvProperty _Property);
void dvClassInsertSparsegroup(dvClass Class, dvSparsegroup _Sparsegroup);
void dvClassRemoveSparsegroup(dvClass Class, dvSparsegroup _Sparsegroup);
void dvClassInsertAfterSparsegroup(dvClass Class, dvSparsegroup prevSparsegroup, dvSparsegroup _Sparsegroup);
void dvClassAppendSparsegroup(dvClass Class, dvSparsegroup _Sparsegroup);
void dvClassInsertDerivedClass(dvClass Class, dvClass _Class);
void dvClassRemoveDerivedClass(dvClass Class, dvClass _Class);
void dvClassInsertAfterDerivedClass(dvClass Class, dvClass prevClass, dvClass _Class);
void dvClassAppendDerivedClass(dvClass Class, dvClass _Class);
void dvClassInsertChildRelationship(dvClass Class, dvRelationship _Relationship);
void dvClassRemoveChildRelationship(dvClass Class, dvRelationship _Relationship);
void dvClassInsertAfterChildRelationship(dvClass Class, dvRelationship prevRelationship, dvRelationship _Relationship);
void dvClassAppendChildRelationship(dvClass Class, dvRelationship _Relationship);
void dvClassInsertParentRelationship(dvClass Class, dvRelationship _Relationship);
void dvClassRemoveParentRelationship(dvClass Class, dvRelationship _Relationship);
void dvClassInsertAfterParentRelationship(dvClass Class, dvRelationship prevRelationship, dvRelationship _Relationship);
void dvClassAppendParentRelationship(dvClass Class, dvRelationship _Relationship);
void dvClassInsertUnion(dvClass Class, dvUnion _Union);
void dvClassRemoveUnion(dvClass Class, dvUnion _Union);
void dvClassInsertAfterUnion(dvClass Class, dvUnion prevUnion, dvUnion _Union);
void dvClassAppendUnion(dvClass Class, dvUnion _Union);

/*----------------------------------------------------------------------------------------
  Unions for class Property.
----------------------------------------------------------------------------------------*/
typedef union {
    dvEnum EnumProp;
    dvTypedef TypedefProp;
    dvClass ClassProp;
    utSym TypeSym;
    uint8 Width;
} dvPropertyUnion1;

/*----------------------------------------------------------------------------------------
  Fields for class Property.
----------------------------------------------------------------------------------------*/
struct dvPropertyFields {
    utSym *Sym;
    dvPropertyType *Type;
    uint8 *Array;
    uint8 *Cascade;
    uint8 *Sparse;
    uint8 *Expanded;
    uint32 *FieldNumber;
    dvProperty *FirstElementProp;
    dvProperty *NumElementsProp;
    uint8 *Hidden;
    uint32 *InitializerIndex;
    uint32 *NumInitializer;
    char *Initializer;
    uint8 *FixedSize;
    uint32 *IndexIndex;
    uint32 *NumIndex;
    char *Index;
    uint32 *Line;
    dvClass *Class;
    dvProperty *NextClassProperty;
    dvProperty *PrevClassProperty;
    dvProperty *NextTableClassProperty;
    dvCase *FirstCase;
    dvCase *LastCase;
    dvKey *FirstKey;
    dvKey *LastKey;
    dvSparsegroup *Sparsegroup;
    dvProperty *NextSparsegroupProperty;
    dvRelationship *Relationship;
    dvProperty *NextRelationshipProperty;
    dvUnion *Union;
    dvProperty *NextUnionProperty;
    dvPropertyUnion1 *union1;
};
extern struct dvPropertyFields dvPropertys;

#define dvPropertyGetSym(_Property) (dvPropertys.Sym[dvProperty2ValidIndex(_Property)])
#define dvPropertySetSym(_Property, value) ((dvPropertys.Sym)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetType(_Property) (dvPropertys.Type[dvProperty2ValidIndex(_Property)])
#define dvPropertySetType(_Property, value) ((dvPropertys.Type)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyArray(_Property) (((dvPropertys.Array)[dvProperty2ValidIndex(_Property) >> 3] >> \
    (dvProperty2ValidIndex(_Property) & 7)) & 1)
#define dvPropertySetArray(_Property, value) ((dvPropertys.Array)[dvProperty2ValidIndex(_Property) >> 3] = \
    (uint8)(((dvPropertys.Array)[dvProperty2ValidIndex(_Property) >> 3] & ~(1 << (dvProperty2ValidIndex(_Property) & 7))) | \
    (((value) != 0) << (dvProperty2ValidIndex(_Property) & 7))))
#define dvPropertyCascade(_Property) (((dvPropertys.Cascade)[dvProperty2ValidIndex(_Property) >> 3] >> \
    (dvProperty2ValidIndex(_Property) & 7)) & 1)
#define dvPropertySetCascade(_Property, value) ((dvPropertys.Cascade)[dvProperty2ValidIndex(_Property) >> 3] = \
    (uint8)(((dvPropertys.Cascade)[dvProperty2ValidIndex(_Property) >> 3] & ~(1 << (dvProperty2ValidIndex(_Property) & 7))) | \
    (((value) != 0) << (dvProperty2ValidIndex(_Property) & 7))))
#define dvPropertySparse(_Property) (((dvPropertys.Sparse)[dvProperty2ValidIndex(_Property) >> 3] >> \
    (dvProperty2ValidIndex(_Property) & 7)) & 1)
#define dvPropertySetSparse(_Property, value) ((dvPropertys.Sparse)[dvProperty2ValidIndex(_Property) >> 3] = \
    (uint8)(((dvPropertys.Sparse)[dvProperty2ValidIndex(_Property) >> 3] & ~(1 << (dvProperty2ValidIndex(_Property) & 7))) | \
    (((value) != 0) << (dvProperty2ValidIndex(_Property) & 7))))
#define dvPropertyExpanded(_Property) (((dvPropertys.Expanded)[dvProperty2ValidIndex(_Property) >> 3] >> \
    (dvProperty2ValidIndex(_Property) & 7)) & 1)
#define dvPropertySetExpanded(_Property, value) ((dvPropertys.Expanded)[dvProperty2ValidIndex(_Property) >> 3] = \
    (uint8)(((dvPropertys.Expanded)[dvProperty2ValidIndex(_Property) >> 3] & ~(1 << (dvProperty2ValidIndex(_Property) & 7))) | \
    (((value) != 0) << (dvProperty2ValidIndex(_Property) & 7))))
#define dvPropertyGetFieldNumber(_Property) (dvPropertys.FieldNumber[dvProperty2ValidIndex(_Property)])
#define dvPropertySetFieldNumber(_Property, value) ((dvPropertys.FieldNumber)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetFirstElementProp(_Property) (dvPropertys.FirstElementProp[dvProperty2ValidIndex(_Property)])
#define dvPropertySetFirstElementProp(_Property, value) ((dvPropertys.FirstElementProp)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetNumElementsProp(_Property) (dvPropertys.NumElementsProp[dvProperty2ValidIndex(_Property)])
#define dvPropertySetNumElementsProp(_Property, value) ((dvPropertys.NumElementsProp)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyHidden(_Property) (((dvPropertys.Hidden)[dvProperty2ValidIndex(_Property) >> 3] >> \
    (dvProperty2ValidIndex(_Property) & 7)) & 1)
#define dvPropertySetHidden(_Property, value) ((dvPropertys.Hidden)[dvProperty2ValidIndex(_Property) >> 3] = \
    (uint8)(((dvPropertys.Hidden)[dvProperty2ValidIndex(_Property) >> 3] & ~(1 << (dvProperty2ValidIndex(_Property) & 7))) | \
    (((value) != 0) << (dvProperty2ValidIndex(_Property) & 7))))
#define dvPropertyGetInitializerIndex(_Property) (dvPropertys.InitializerIndex[dvProperty2ValidIndex(_Property)])
#define dvPropertySetInitializerIndex(_Property, value) ((dvPropertys.InitializerIndex)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetNumInitializer(_Property) (dvPropertys.NumInitializer[dvProperty2ValidIndex(_Property)])
#define dvPropertySetNumInitializer(_Property, value) ((dvPropertys.NumInitializer)[dvProperty2ValidIndex(_Property)] = (value))
#if defined(DD_DEBUG)
#define dvPropertyCheckInitializerIndex(Property, x) ((uint32)(x) < dvPropertyGetNumInitializer(Property)? (x) : \
    (utAssert(false),(x)))
#else
#define dvPropertyCheckInitializerIndex(Property, x) (x)
#endif
#define dvPropertyGetiInitializer(_Property, x) ((dvPropertys.Initializer)[ \
    dvPropertyGetInitializerIndex(_Property) + dvPropertyCheckInitializerIndex(_Property, (x))])
#define dvPropertyGetInitializer(Property) (dvPropertys.Initializer + dvPropertyGetInitializerIndex(Property))
#define dvPropertyGetInitializers dvPropertyGetInitializer
#define dvPropertySetInitializer(Property, valuePtr, numInitializer) (dvPropertyResizeInitializers(Property, numInitializer), memcpy(dvPropertyGetInitializers(Property), valuePtr, \
    numInitializer*sizeof(char)))
#define dvPropertySetiInitializer(Property, x, value) ((dvPropertys.Initializer)[ \
    dvPropertyGetInitializerIndex(Property) + dvPropertyCheckInitializerIndex(Property, (x))] = (value))
#define dvPropertyFixedSize(_Property) (((dvPropertys.FixedSize)[dvProperty2ValidIndex(_Property) >> 3] >> \
    (dvProperty2ValidIndex(_Property) & 7)) & 1)
#define dvPropertySetFixedSize(_Property, value) ((dvPropertys.FixedSize)[dvProperty2ValidIndex(_Property) >> 3] = \
    (uint8)(((dvPropertys.FixedSize)[dvProperty2ValidIndex(_Property) >> 3] & ~(1 << (dvProperty2ValidIndex(_Property) & 7))) | \
    (((value) != 0) << (dvProperty2ValidIndex(_Property) & 7))))
#define dvPropertyGetIndexIndex(_Property) (dvPropertys.IndexIndex[dvProperty2ValidIndex(_Property)])
#define dvPropertySetIndexIndex(_Property, value) ((dvPropertys.IndexIndex)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetNumIndex(_Property) (dvPropertys.NumIndex[dvProperty2ValidIndex(_Property)])
#define dvPropertySetNumIndex(_Property, value) ((dvPropertys.NumIndex)[dvProperty2ValidIndex(_Property)] = (value))
#if defined(DD_DEBUG)
#define dvPropertyCheckIndexIndex(Property, x) ((uint32)(x) < dvPropertyGetNumIndex(Property)? (x) : \
    (utAssert(false),(x)))
#else
#define dvPropertyCheckIndexIndex(Property, x) (x)
#endif
#define dvPropertyGetiIndex(_Property, x) ((dvPropertys.Index)[ \
    dvPropertyGetIndexIndex(_Property) + dvPropertyCheckIndexIndex(_Property, (x))])
#define dvPropertyGetIndex(Property) (dvPropertys.Index + dvPropertyGetIndexIndex(Property))
#define dvPropertyGetIndexs dvPropertyGetIndex
#define dvPropertySetIndex(Property, valuePtr, numIndex) (dvPropertyResizeIndexs(Property, numIndex), memcpy(dvPropertyGetIndexs(Property), valuePtr, \
    numIndex*sizeof(char)))
#define dvPropertySetiIndex(Property, x, value) ((dvPropertys.Index)[ \
    dvPropertyGetIndexIndex(Property) + dvPropertyCheckIndexIndex(Property, (x))] = (value))
#define dvPropertyGetEnumProp(_Property) (dvPropertys.union1[dvProperty2ValidIndex(_Property)].EnumProp)
#define dvPropertySetEnumProp(_Property, value) \
    (dvPropertys.union1[dvProperty2ValidIndex(_Property)].EnumProp = (value))
#define dvPropertyGetTypedefProp(_Property) (dvPropertys.union1[dvProperty2ValidIndex(_Property)].TypedefProp)
#define dvPropertySetTypedefProp(_Property, value) \
    (dvPropertys.union1[dvProperty2ValidIndex(_Property)].TypedefProp = (value))
#define dvPropertyGetClassProp(_Property) (dvPropertys.union1[dvProperty2ValidIndex(_Property)].ClassProp)
#define dvPropertySetClassProp(_Property, value) \
    (dvPropertys.union1[dvProperty2ValidIndex(_Property)].ClassProp = (value))
#define dvPropertyGetTypeSym(_Property) (dvPropertys.union1[dvProperty2ValidIndex(_Property)].TypeSym)
#define dvPropertySetTypeSym(_Property, value) \
    (dvPropertys.union1[dvProperty2ValidIndex(_Property)].TypeSym = (value))
#define dvPropertyGetWidth(_Property) (dvPropertys.union1[dvProperty2ValidIndex(_Property)].Width)
#define dvPropertySetWidth(_Property, value) \
    (dvPropertys.union1[dvProperty2ValidIndex(_Property)].Width = (value))
#define dvPropertyGetLine(_Property) (dvPropertys.Line[dvProperty2ValidIndex(_Property)])
#define dvPropertySetLine(_Property, value) ((dvPropertys.Line)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetClass(_Property) (dvPropertys.Class[dvProperty2ValidIndex(_Property)])
#define dvPropertySetClass(_Property, value) ((dvPropertys.Class)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetNextClassProperty(_Property) (dvPropertys.NextClassProperty[dvProperty2ValidIndex(_Property)])
#define dvPropertySetNextClassProperty(_Property, value) ((dvPropertys.NextClassProperty)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetPrevClassProperty(_Property) (dvPropertys.PrevClassProperty[dvProperty2ValidIndex(_Property)])
#define dvPropertySetPrevClassProperty(_Property, value) ((dvPropertys.PrevClassProperty)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetNextTableClassProperty(_Property) (dvPropertys.NextTableClassProperty[dvProperty2ValidIndex(_Property)])
#define dvPropertySetNextTableClassProperty(_Property, value) ((dvPropertys.NextTableClassProperty)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetFirstCase(_Property) (dvPropertys.FirstCase[dvProperty2ValidIndex(_Property)])
#define dvPropertySetFirstCase(_Property, value) ((dvPropertys.FirstCase)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetLastCase(_Property) (dvPropertys.LastCase[dvProperty2ValidIndex(_Property)])
#define dvPropertySetLastCase(_Property, value) ((dvPropertys.LastCase)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetFirstKey(_Property) (dvPropertys.FirstKey[dvProperty2ValidIndex(_Property)])
#define dvPropertySetFirstKey(_Property, value) ((dvPropertys.FirstKey)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetLastKey(_Property) (dvPropertys.LastKey[dvProperty2ValidIndex(_Property)])
#define dvPropertySetLastKey(_Property, value) ((dvPropertys.LastKey)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetSparsegroup(_Property) (dvPropertys.Sparsegroup[dvProperty2ValidIndex(_Property)])
#define dvPropertySetSparsegroup(_Property, value) ((dvPropertys.Sparsegroup)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetNextSparsegroupProperty(_Property) (dvPropertys.NextSparsegroupProperty[dvProperty2ValidIndex(_Property)])
#define dvPropertySetNextSparsegroupProperty(_Property, value) ((dvPropertys.NextSparsegroupProperty)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetRelationship(_Property) (dvPropertys.Relationship[dvProperty2ValidIndex(_Property)])
#define dvPropertySetRelationship(_Property, value) ((dvPropertys.Relationship)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetNextRelationshipProperty(_Property) (dvPropertys.NextRelationshipProperty[dvProperty2ValidIndex(_Property)])
#define dvPropertySetNextRelationshipProperty(_Property, value) ((dvPropertys.NextRelationshipProperty)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetUnion(_Property) (dvPropertys.Union[dvProperty2ValidIndex(_Property)])
#define dvPropertySetUnion(_Property, value) ((dvPropertys.Union)[dvProperty2ValidIndex(_Property)] = (value))
#define dvPropertyGetNextUnionProperty(_Property) (dvPropertys.NextUnionProperty[dvProperty2ValidIndex(_Property)])
#define dvPropertySetNextUnionProperty(_Property, value) ((dvPropertys.NextUnionProperty)[dvProperty2ValidIndex(_Property)] = (value))
#define dvForeachPropertyCase(pVar, cVar) \
    for(cVar = dvPropertyGetFirstCase(pVar); cVar != dvCaseNull; \
        cVar = dvCaseGetNextPropertyCase(cVar))
#define dvEndPropertyCase
#define dvSafeForeachPropertyCase(pVar, cVar) { \
    dvCase _nextCase; \
    for(cVar = dvPropertyGetFirstCase(pVar); cVar != dvCaseNull; cVar = _nextCase) { \
        _nextCase = dvCaseGetNextPropertyCase(cVar);
#define dvEndSafePropertyCase }}
#define dvForeachPropertyKey(pVar, cVar) \
    for(cVar = dvPropertyGetFirstKey(pVar); cVar != dvKeyNull; \
        cVar = dvKeyGetNextPropertyKey(cVar))
#define dvEndPropertyKey
#define dvSafeForeachPropertyKey(pVar, cVar) { \
    dvKey _nextKey; \
    for(cVar = dvPropertyGetFirstKey(pVar); cVar != dvKeyNull; cVar = _nextKey) { \
        _nextKey = dvKeyGetNextPropertyKey(cVar);
#define dvEndSafePropertyKey }}
#define dvPropertySetConstructorCallback(func) (dvPropertyConstructorCallback = (func))
#define dvPropertyGetConstructorCallback() (dvPropertyConstructorCallback)
#define dvFirstProperty() (dvRootData.usedProperty == 0? dvPropertyNull : dvIndex2Property(0))
#define dvLastProperty() (dvRootData.usedProperty == 0? dvPropertyNull : \
    dvIndex2Property(dvRootData.usedProperty - 1))
#define dvNextProperty(Property) (dvProperty2ValidIndex(Property) + 1 == dvRootData.usedProperty? dvPropertyNull : \
    (Property) + 1)
#define dvPrevProperty(Property) (dvProperty2ValidIndex(Property) == 0? dvPropertyNull : (Property) - 1)
#define dvForeachProperty(var) \
    for(var = dvIndex2Property(0); dvProperty2Index(var) != dvRootData.usedProperty; var++)
#define dvEndProperty
#define dvPropertyFreeAll() (dvSetUsedProperty(0), dvSetUsedPropertyInitializer(0), dvSetUsedPropertyIndex(0))
#define dvPropertyAllocRaw() ( \
    dvRootData.usedProperty == dvRootData.allocatedProperty && (dvPropertyAllocMore(), true), \
    dvTemp_.Property = dvIndex2Property(dvRootData.usedProperty), \
    dvSetUsedProperty(dvUsedProperty() + 1), \
    dvTemp_.Property)
#define dvPropertyAlloc() ( \
    dvRootData.usedProperty == dvRootData.allocatedProperty && (dvPropertyAllocMore(), true), \
    dvTemp_.Property = dvIndex2Property(dvRootData.usedProperty), \
    dvSetUsedProperty(dvUsedProperty() + 1), \
    dvPropertySetSym(dvTemp_.Property, utSymNull), \
    dvPropertySetType(dvTemp_.Property, 0), \
    dvPropertySetArray(dvTemp_.Property, 0), \
    dvPropertySetCascade(dvTemp_.Property, 0), \
    dvPropertySetSparse(dvTemp_.Property, 0), \
    dvPropertySetExpanded(dvTemp_.Property, 0), \
    dvPropertySetFieldNumber(dvTemp_.Property, 0), \
    dvPropertySetFirstElementProp(dvTemp_.Property, dvPropertyNull), \
    dvPropertySetNumElementsProp(dvTemp_.Property, dvPropertyNull), \
    dvPropertySetHidden(dvTemp_.Property, 0), \
    dvPropertySetInitializerIndex(dvTemp_.Property, 0), \
    dvPropertySetNumInitializer(dvTemp_.Property, 0), \
    dvPropertySetNumInitializer(dvTemp_.Property, 0), \
    dvPropertySetFixedSize(dvTemp_.Property, 0), \
    dvPropertySetIndexIndex(dvTemp_.Property, 0), \
    dvPropertySetNumIndex(dvTemp_.Property, 0), \
    dvPropertySetNumIndex(dvTemp_.Property, 0), \
    dvPropertySetEnumProp(dvTemp_.Property, dvEnumNull), \
    dvPropertySetLine(dvTemp_.Property, 0), \
    dvPropertySetClass(dvTemp_.Property, dvClassNull), \
    dvPropertySetNextClassProperty(dvTemp_.Property, dvPropertyNull), \
    dvPropertySetPrevClassProperty(dvTemp_.Property, dvPropertyNull), \
    dvPropertySetNextTableClassProperty(dvTemp_.Property, dvPropertyNull), \
    dvPropertySetFirstCase(dvTemp_.Property, dvCaseNull), \
    dvPropertySetLastCase(dvTemp_.Property, dvCaseNull), \
    dvPropertySetFirstKey(dvTemp_.Property, dvKeyNull), \
    dvPropertySetLastKey(dvTemp_.Property, dvKeyNull), \
    dvPropertySetSparsegroup(dvTemp_.Property, dvSparsegroupNull), \
    dvPropertySetNextSparsegroupProperty(dvTemp_.Property, dvPropertyNull), \
    dvPropertySetRelationship(dvTemp_.Property, dvRelationshipNull), \
    dvPropertySetNextRelationshipProperty(dvTemp_.Property, dvPropertyNull), \
    dvPropertySetUnion(dvTemp_.Property, dvUnionNull), \
    dvPropertySetNextUnionProperty(dvTemp_.Property, dvPropertyNull), \
    dvPropertyConstructorCallback != NULL && (dvPropertyConstructorCallback(dvTemp_.Property), true), \
    dvTemp_.Property)

void dvPropertyAllocMore(void);
void dvPropertyCopyProps(dvProperty dvOldProperty, dvProperty dvNewProperty);
void dvPropertySetBitfield(dvProperty _Property, uint32 bitfield);
uint32 dvPropertyGetBitfield(dvProperty _Property);
void dvPropertyAllocInitializers(dvProperty Property, uint32 numInitializers);
void dvPropertyResizeInitializers(dvProperty Property, uint32 numInitializers);
void dvPropertyFreeInitializers(dvProperty Property);
void dvCompactPropertyInitializers(void);
void dvPropertyAllocIndexs(dvProperty Property, uint32 numIndexs);
void dvPropertyResizeIndexs(dvProperty Property, uint32 numIndexs);
void dvPropertyFreeIndexs(dvProperty Property);
void dvCompactPropertyIndexs(void);
void dvPropertyInsertCase(dvProperty Property, dvCase _Case);
void dvPropertyRemoveCase(dvProperty Property, dvCase _Case);
void dvPropertyInsertAfterCase(dvProperty Property, dvCase prevCase, dvCase _Case);
void dvPropertyAppendCase(dvProperty Property, dvCase _Case);
void dvPropertyInsertKey(dvProperty Property, dvKey _Key);
void dvPropertyRemoveKey(dvProperty Property, dvKey _Key);
void dvPropertyInsertAfterKey(dvProperty Property, dvKey prevKey, dvKey _Key);
void dvPropertyAppendKey(dvProperty Property, dvKey _Key);

/*----------------------------------------------------------------------------------------
  Fields for class Sparsegroup.
----------------------------------------------------------------------------------------*/
struct dvSparsegroupFields {
    utSym *Sym;
    dvClass *Class;
    dvSparsegroup *NextClassSparsegroup;
    dvSparsegroup *PrevClassSparsegroup;
    dvSparsegroup *NextTableClassSparsegroup;
    dvProperty *FirstProperty;
    dvProperty *LastProperty;
    dvRelationship *Relationship;
};
extern struct dvSparsegroupFields dvSparsegroups;

#define dvSparsegroupGetSym(_Sparsegroup) (dvSparsegroups.Sym[dvSparsegroup2ValidIndex(_Sparsegroup)])
#define dvSparsegroupSetSym(_Sparsegroup, value) ((dvSparsegroups.Sym)[dvSparsegroup2ValidIndex(_Sparsegroup)] = (value))
#define dvSparsegroupGetClass(_Sparsegroup) (dvSparsegroups.Class[dvSparsegroup2ValidIndex(_Sparsegroup)])
#define dvSparsegroupSetClass(_Sparsegroup, value) ((dvSparsegroups.Class)[dvSparsegroup2ValidIndex(_Sparsegroup)] = (value))
#define dvSparsegroupGetNextClassSparsegroup(_Sparsegroup) (dvSparsegroups.NextClassSparsegroup[dvSparsegroup2ValidIndex(_Sparsegroup)])
#define dvSparsegroupSetNextClassSparsegroup(_Sparsegroup, value) ((dvSparsegroups.NextClassSparsegroup)[dvSparsegroup2ValidIndex(_Sparsegroup)] = (value))
#define dvSparsegroupGetPrevClassSparsegroup(_Sparsegroup) (dvSparsegroups.PrevClassSparsegroup[dvSparsegroup2ValidIndex(_Sparsegroup)])
#define dvSparsegroupSetPrevClassSparsegroup(_Sparsegroup, value) ((dvSparsegroups.PrevClassSparsegroup)[dvSparsegroup2ValidIndex(_Sparsegroup)] = (value))
#define dvSparsegroupGetNextTableClassSparsegroup(_Sparsegroup) (dvSparsegroups.NextTableClassSparsegroup[dvSparsegroup2ValidIndex(_Sparsegroup)])
#define dvSparsegroupSetNextTableClassSparsegroup(_Sparsegroup, value) ((dvSparsegroups.NextTableClassSparsegroup)[dvSparsegroup2ValidIndex(_Sparsegroup)] = (value))
#define dvSparsegroupGetFirstProperty(_Sparsegroup) (dvSparsegroups.FirstProperty[dvSparsegroup2ValidIndex(_Sparsegroup)])
#define dvSparsegroupSetFirstProperty(_Sparsegroup, value) ((dvSparsegroups.FirstProperty)[dvSparsegroup2ValidIndex(_Sparsegroup)] = (value))
#define dvSparsegroupGetLastProperty(_Sparsegroup) (dvSparsegroups.LastProperty[dvSparsegroup2ValidIndex(_Sparsegroup)])
#define dvSparsegroupSetLastProperty(_Sparsegroup, value) ((dvSparsegroups.LastProperty)[dvSparsegroup2ValidIndex(_Sparsegroup)] = (value))
#define dvSparsegroupGetRelationship(_Sparsegroup) (dvSparsegroups.Relationship[dvSparsegroup2ValidIndex(_Sparsegroup)])
#define dvSparsegroupSetRelationship(_Sparsegroup, value) ((dvSparsegroups.Relationship)[dvSparsegroup2ValidIndex(_Sparsegroup)] = (value))
#define dvForeachSparsegroupProperty(pVar, cVar) \
    for(cVar = dvSparsegroupGetFirstProperty(pVar); cVar != dvPropertyNull; \
        cVar = dvPropertyGetNextSparsegroupProperty(cVar))
#define dvEndSparsegroupProperty
#define dvSafeForeachSparsegroupProperty(pVar, cVar) { \
    dvProperty _nextProperty; \
    for(cVar = dvSparsegroupGetFirstProperty(pVar); cVar != dvPropertyNull; cVar = _nextProperty) { \
        _nextProperty = dvPropertyGetNextSparsegroupProperty(cVar);
#define dvEndSafeSparsegroupProperty }}
#define dvSparsegroupSetConstructorCallback(func) (dvSparsegroupConstructorCallback = (func))
#define dvSparsegroupGetConstructorCallback() (dvSparsegroupConstructorCallback)
#define dvSparsegroupSetDestructorCallback(func) (dvSparsegroupDestructorCallback = (func))
#define dvSparsegroupGetDestructorCallback() (dvSparsegroupDestructorCallback)
#define dvSparsegroupNextFree(_Sparsegroup) (((dvSparsegroup *)(void *)(dvSparsegroups.Class))[dvSparsegroup2ValidIndex(_Sparsegroup)])
#define dvSparsegroupSetNextFree(_Sparsegroup, value) (((dvSparsegroup *)(void *)(dvSparsegroups.Class)) \
    [dvSparsegroup2ValidIndex(_Sparsegroup)] = (value))
#define dvSparsegroupAllocRaw() ( \
    dvRootData.firstFreeSparsegroup != dvSparsegroupNull? \
        (dvTemp_.Sparsegroup = dvRootData.firstFreeSparsegroup, \
        dvSetFirstFreeSparsegroup(dvSparsegroupNextFree(dvTemp_.Sparsegroup)), true) \
    : (dvRootData.usedSparsegroup == dvRootData.allocatedSparsegroup && (dvSparsegroupAllocMore(), true), \
        dvTemp_.Sparsegroup = dvIndex2Sparsegroup(dvRootData.usedSparsegroup), \
        dvSetUsedSparsegroup(dvUsedSparsegroup() + 1)), \
    dvTemp_.Sparsegroup)
#define dvSparsegroupAlloc() ( \
    dvRootData.firstFreeSparsegroup != dvSparsegroupNull? \
        (dvTemp_.Sparsegroup = dvRootData.firstFreeSparsegroup, \
        dvSetFirstFreeSparsegroup(dvSparsegroupNextFree(dvTemp_.Sparsegroup)), true) \
    : (dvRootData.usedSparsegroup == dvRootData.allocatedSparsegroup && (dvSparsegroupAllocMore(), true), \
        dvTemp_.Sparsegroup = dvIndex2Sparsegroup(dvRootData.usedSparsegroup), \
        dvSetUsedSparsegroup(dvUsedSparsegroup() + 1)), \
    dvSparsegroupSetSym(dvTemp_.Sparsegroup, utSymNull), \
    dvSparsegroupSetClass(dvTemp_.Sparsegroup, dvClassNull), \
    dvSparsegroupSetNextClassSparsegroup(dvTemp_.Sparsegroup, dvSparsegroupNull), \
    dvSparsegroupSetPrevClassSparsegroup(dvTemp_.Sparsegroup, dvSparsegroupNull), \
    dvSparsegroupSetNextTableClassSparsegroup(dvTemp_.Sparsegroup, dvSparsegroupNull), \
    dvSparsegroupSetFirstProperty(dvTemp_.Sparsegroup, dvPropertyNull), \
    dvSparsegroupSetLastProperty(dvTemp_.Sparsegroup, dvPropertyNull), \
    dvSparsegroupSetRelationship(dvTemp_.Sparsegroup, dvRelationshipNull), \
    dvSparsegroupConstructorCallback != NULL && (dvSparsegroupConstructorCallback(dvTemp_.Sparsegroup), true), \
    dvTemp_.Sparsegroup)

#define dvSparsegroupFree(Sparsegroup) (dvSparsegroupSetNextFree(Sparsegroup, dvRootData.firstFreeSparsegroup), \
    dvSetFirstFreeSparsegroup(Sparsegroup))
void dvSparsegroupDestroy(dvSparsegroup Sparsegroup);
void dvSparsegroupAllocMore(void);
void dvSparsegroupCopyProps(dvSparsegroup dvOldSparsegroup, dvSparsegroup dvNewSparsegroup);
void dvSparsegroupInsertProperty(dvSparsegroup Sparsegroup, dvProperty _Property);
void dvSparsegroupRemoveProperty(dvSparsegroup Sparsegroup, dvProperty _Property);
void dvSparsegroupInsertAfterProperty(dvSparsegroup Sparsegroup, dvProperty prevProperty, dvProperty _Property);
void dvSparsegroupAppendProperty(dvSparsegroup Sparsegroup, dvProperty _Property);

/*----------------------------------------------------------------------------------------
  Fields for class Relationship.
----------------------------------------------------------------------------------------*/
struct dvRelationshipFields {
    dvRelationshipType *Type;
    utSym *ParentLabelSym;
    utSym *ChildLabelSym;
    uint8 *Mandatory;
    uint8 *Cascade;
    uint8 *AccessChild;
    uint8 *AccessParent;
    uint8 *SharedParent;
    uint8 *Sparse;
    uint8 *Expanded;
    dvSchema *Schema;
    dvRelationship *NextSchemaRelationship;
    dvClass *ParentClass;
    dvRelationship *NextClassChildRelationship;
    dvClass *ChildClass;
    dvRelationship *NextClassParentRelationship;
    dvProperty *FirstProperty;
    dvProperty *LastProperty;
    dvKey *FirstKey;
    dvKey *LastKey;
    dvSparsegroup *ParentSparsegroup;
    dvSparsegroup *ChildSparsegroup;
};
extern struct dvRelationshipFields dvRelationships;

#define dvRelationshipGetType(_Relationship) (dvRelationships.Type[dvRelationship2ValidIndex(_Relationship)])
#define dvRelationshipSetType(_Relationship, value) ((dvRelationships.Type)[dvRelationship2ValidIndex(_Relationship)] = (value))
#define dvRelationshipGetParentLabelSym(_Relationship) (dvRelationships.ParentLabelSym[dvRelationship2ValidIndex(_Relationship)])
#define dvRelationshipSetParentLabelSym(_Relationship, value) ((dvRelationships.ParentLabelSym)[dvRelationship2ValidIndex(_Relationship)] = (value))
#define dvRelationshipGetChildLabelSym(_Relationship) (dvRelationships.ChildLabelSym[dvRelationship2ValidIndex(_Relationship)])
#define dvRelationshipSetChildLabelSym(_Relationship, value) ((dvRelationships.ChildLabelSym)[dvRelationship2ValidIndex(_Relationship)] = (value))
#define dvRelationshipMandatory(_Relationship) (((dvRelationships.Mandatory)[dvRelationship2ValidIndex(_Relationship) >> 3] >> \
    (dvRelationship2ValidIndex(_Relationship) & 7)) & 1)
#define dvRelationshipSetMandatory(_Relationship, value) ((dvRelationships.Mandatory)[dvRelationship2ValidIndex(_Relationship) >> 3] = \
    (uint8)(((dvRelationships.Mandatory)[dvRelationship2ValidIndex(_Relationship) >> 3] & ~(1 << (dvRelationship2ValidIndex(_Relationship) & 7))) | \
    (((value) != 0) << (dvRelationship2ValidIndex(_Relationship) & 7))))
#define dvRelationshipCascade(_Relationship) (((dvRelationships.Cascade)[dvRelationship2ValidIndex(_Relationship) >> 3] >> \
    (dvRelationship2ValidIndex(_Relationship) & 7)) & 1)
#define dvRelationshipSetCascade(_Relationship, value) ((dvRelationships.Cascade)[dvRelationship2ValidIndex(_Relationship) >> 3] = \
    (uint8)(((dvRelationships.Cascade)[dvRelationship2ValidIndex(_Relationship) >> 3] & ~(1 << (dvRelationship2ValidIndex(_Relationship) & 7))) | \
    (((value) != 0) << (dvRelationship2ValidIndex(_Relationship) & 7))))
#define dvRelationshipAccessChild(_Relationship) (((dvRelationships.AccessChild)[dvRelationship2ValidIndex(_Relationship) >> 3] >> \
    (dvRelationship2ValidIndex(_Relationship) & 7)) & 1)
#define dvRelationshipSetAccessChild(_Relationship, value) ((dvRelationships.AccessChild)[dvRelationship2ValidIndex(_Relationship) >> 3] = \
    (uint8)(((dvRelationships.AccessChild)[dvRelationship2ValidIndex(_Relationship) >> 3] & ~(1 << (dvRelationship2ValidIndex(_Relationship) & 7))) | \
    (((value) != 0) << (dvRelationship2ValidIndex(_Relationship) & 7))))
#define dvRelationshipAccessParent(_Relationship) (((dvRelationships.AccessParent)[dvRelationship2ValidIndex(_Relationship) >> 3] >> \
    (dvRelationship2ValidIndex(_Relationship) & 7)) & 1)
#define dvRelationshipSetAccessParent(_Relationship, value) ((dvRelationships.AccessParent)[dvRelationship2ValidIndex(_Relationship) >> 3] = \
    (uint8)(((dvRelationships.AccessParent)[dvRelationship2ValidIndex(_Relationship) >> 3] & ~(1 << (dvRelationship2ValidIndex(_Relationship) & 7))) | \
    (((value) != 0) << (dvRelationship2ValidIndex(_Relationship) & 7))))
#define dvRelationshipSharedParent(_Relationship) (((dvRelationships.SharedParent)[dvRelationship2ValidIndex(_Relationship) >> 3] >> \
    (dvRelationship2ValidIndex(_Relationship) & 7)) & 1)
#define dvRelationshipSetSharedParent(_Relationship, value) ((dvRelationships.SharedParent)[dvRelationship2ValidIndex(_Relationship) >> 3] = \
    (uint8)(((dvRelationships.SharedParent)[dvRelationship2ValidIndex(_Relationship) >> 3] & ~(1 << (dvRelationship2ValidIndex(_Relationship) & 7))) | \
    (((value) != 0) << (dvRelationship2ValidIndex(_Relationship) & 7))))
#define dvRelationshipSparse(_Relationship) (((dvRelationships.Sparse)[dvRelationship2ValidIndex(_Relationship) >> 3] >> \
    (dvRelationship2ValidIndex(_Relationship) & 7)) & 1)
#define dvRelationshipSetSparse(_Relationship, value) ((dvRelationships.Sparse)[dvRelationship2ValidIndex(_Relationship) >> 3] = \
    (uint8)(((dvRelationships.Sparse)[dvRelationship2ValidIndex(_Relationship) >> 3] & ~(1 << (dvRelationship2ValidIndex(_Relationship) & 7))) | \
    (((value) != 0) << (dvRelationship2ValidIndex(_Relationship) & 7))))
#define dvRelationshipExpanded(_Relationship) (((dvRelationships.Expanded)[dvRelationship2ValidIndex(_Relationship) >> 3] >> \
    (dvRelationship2ValidIndex(_Relationship) & 7)) & 1)
#define dvRelationshipSetExpanded(_Relationship, value) ((dvRelationships.Expanded)[dvRelationship2ValidIndex(_Relationship) >> 3] = \
    (uint8)(((dvRelationships.Expanded)[dvRelationship2ValidIndex(_Relationship) >> 3] & ~(1 << (dvRelationship2ValidIndex(_Relationship) & 7))) | \
    (((value) != 0) << (dvRelationship2ValidIndex(_Relationship) & 7))))
#define dvRelationshipGetSchema(_Relationship) (dvRelationships.Schema[dvRelationship2ValidIndex(_Relationship)])
#define dvRelationshipSetSchema(_Relationship, value) ((dvRelationships.Schema)[dvRelationship2ValidIndex(_Relationship)] = (value))
#define dvRelationshipGetNextSchemaRelationship(_Relationship) (dvRelationships.NextSchemaRelationship[dvRelationship2ValidIndex(_Relationship)])
#define dvRelationshipSetNextSchemaRelationship(_Relationship, value) ((dvRelationships.NextSchemaRelationship)[dvRelationship2ValidIndex(_Relationship)] = (value))
#define dvRelationshipGetParentClass(_Relationship) (dvRelationships.ParentClass[dvRelationship2ValidIndex(_Relationship)])
#define dvRelationshipSetParentClass(_Relationship, value) ((dvRelationships.ParentClass)[dvRelationship2ValidIndex(_Relationship)] = (value))
#define dvRelationshipGetNextClassChildRelationship(_Relationship) (dvRelationships.NextClassChildRelationship[dvRelationship2ValidIndex(_Relationship)])
#define dvRelationshipSetNextClassChildRelationship(_Relationship, value) ((dvRelationships.NextClassChildRelationship)[dvRelationship2ValidIndex(_Relationship)] = (value))
#define dvRelationshipGetChildClass(_Relationship) (dvRelationships.ChildClass[dvRelationship2ValidIndex(_Relationship)])
#define dvRelationshipSetChildClass(_Relationship, value) ((dvRelationships.ChildClass)[dvRelationship2ValidIndex(_Relationship)] = (value))
#define dvRelationshipGetNextClassParentRelationship(_Relationship) (dvRelationships.NextClassParentRelationship[dvRelationship2ValidIndex(_Relationship)])
#define dvRelationshipSetNextClassParentRelationship(_Relationship, value) ((dvRelationships.NextClassParentRelationship)[dvRelationship2ValidIndex(_Relationship)] = (value))
#define dvRelationshipGetFirstProperty(_Relationship) (dvRelationships.FirstProperty[dvRelationship2ValidIndex(_Relationship)])
#define dvRelationshipSetFirstProperty(_Relationship, value) ((dvRelationships.FirstProperty)[dvRelationship2ValidIndex(_Relationship)] = (value))
#define dvRelationshipGetLastProperty(_Relationship) (dvRelationships.LastProperty[dvRelationship2ValidIndex(_Relationship)])
#define dvRelationshipSetLastProperty(_Relationship, value) ((dvRelationships.LastProperty)[dvRelationship2ValidIndex(_Relationship)] = (value))
#define dvRelationshipGetFirstKey(_Relationship) (dvRelationships.FirstKey[dvRelationship2ValidIndex(_Relationship)])
#define dvRelationshipSetFirstKey(_Relationship, value) ((dvRelationships.FirstKey)[dvRelationship2ValidIndex(_Relationship)] = (value))
#define dvRelationshipGetLastKey(_Relationship) (dvRelationships.LastKey[dvRelationship2ValidIndex(_Relationship)])
#define dvRelationshipSetLastKey(_Relationship, value) ((dvRelationships.LastKey)[dvRelationship2ValidIndex(_Relationship)] = (value))
#define dvRelationshipGetParentSparsegroup(_Relationship) (dvRelationships.ParentSparsegroup[dvRelationship2ValidIndex(_Relationship)])
#define dvRelationshipSetParentSparsegroup(_Relationship, value) ((dvRelationships.ParentSparsegroup)[dvRelationship2ValidIndex(_Relationship)] = (value))
#define dvRelationshipGetChildSparsegroup(_Relationship) (dvRelationships.ChildSparsegroup[dvRelationship2ValidIndex(_Relationship)])
#define dvRelationshipSetChildSparsegroup(_Relationship, value) ((dvRelationships.ChildSparsegroup)[dvRelationship2ValidIndex(_Relationship)] = (value))
#define dvForeachRelationshipProperty(pVar, cVar) \
    for(cVar = dvRelationshipGetFirstProperty(pVar); cVar != dvPropertyNull; \
        cVar = dvPropertyGetNextRelationshipProperty(cVar))
#define dvEndRelationshipProperty
#define dvSafeForeachRelationshipProperty(pVar, cVar) { \
    dvProperty _nextProperty; \
    for(cVar = dvRelationshipGetFirstProperty(pVar); cVar != dvPropertyNull; cVar = _nextProperty) { \
        _nextProperty = dvPropertyGetNextRelationshipProperty(cVar);
#define dvEndSafeRelationshipProperty }}
#define dvForeachRelationshipKey(pVar, cVar) \
    for(cVar = dvRelationshipGetFirstKey(pVar); cVar != dvKeyNull; \
        cVar = dvKeyGetNextRelationshipKey(cVar))
#define dvEndRelationshipKey
#define dvSafeForeachRelationshipKey(pVar, cVar) { \
    dvKey _nextKey; \
    for(cVar = dvRelationshipGetFirstKey(pVar); cVar != dvKeyNull; cVar = _nextKey) { \
        _nextKey = dvKeyGetNextRelationshipKey(cVar);
#define dvEndSafeRelationshipKey }}
#define dvRelationshipSetConstructorCallback(func) (dvRelationshipConstructorCallback = (func))
#define dvRelationshipGetConstructorCallback() (dvRelationshipConstructorCallback)
#define dvFirstRelationship() (dvRootData.usedRelationship == 0? dvRelationshipNull : dvIndex2Relationship(0))
#define dvLastRelationship() (dvRootData.usedRelationship == 0? dvRelationshipNull : \
    dvIndex2Relationship(dvRootData.usedRelationship - 1))
#define dvNextRelationship(Relationship) (dvRelationship2ValidIndex(Relationship) + 1 == dvRootData.usedRelationship? dvRelationshipNull : \
    (Relationship) + 1)
#define dvPrevRelationship(Relationship) (dvRelationship2ValidIndex(Relationship) == 0? dvRelationshipNull : (Relationship) - 1)
#define dvForeachRelationship(var) \
    for(var = dvIndex2Relationship(0); dvRelationship2Index(var) != dvRootData.usedRelationship; var++)
#define dvEndRelationship
#define dvRelationshipFreeAll() (dvSetUsedRelationship(0))
#define dvRelationshipAllocRaw() ( \
    dvRootData.usedRelationship == dvRootData.allocatedRelationship && (dvRelationshipAllocMore(), true), \
    dvTemp_.Relationship = dvIndex2Relationship(dvRootData.usedRelationship), \
    dvSetUsedRelationship(dvUsedRelationship() + 1), \
    dvTemp_.Relationship)
#define dvRelationshipAlloc() ( \
    dvRootData.usedRelationship == dvRootData.allocatedRelationship && (dvRelationshipAllocMore(), true), \
    dvTemp_.Relationship = dvIndex2Relationship(dvRootData.usedRelationship), \
    dvSetUsedRelationship(dvUsedRelationship() + 1), \
    dvRelationshipSetType(dvTemp_.Relationship, 0), \
    dvRelationshipSetParentLabelSym(dvTemp_.Relationship, utSymNull), \
    dvRelationshipSetChildLabelSym(dvTemp_.Relationship, utSymNull), \
    dvRelationshipSetMandatory(dvTemp_.Relationship, 0), \
    dvRelationshipSetCascade(dvTemp_.Relationship, 0), \
    dvRelationshipSetAccessChild(dvTemp_.Relationship, 0), \
    dvRelationshipSetAccessParent(dvTemp_.Relationship, 0), \
    dvRelationshipSetSharedParent(dvTemp_.Relationship, 0), \
    dvRelationshipSetSparse(dvTemp_.Relationship, 0), \
    dvRelationshipSetExpanded(dvTemp_.Relationship, 0), \
    dvRelationshipSetSchema(dvTemp_.Relationship, dvSchemaNull), \
    dvRelationshipSetNextSchemaRelationship(dvTemp_.Relationship, dvRelationshipNull), \
    dvRelationshipSetParentClass(dvTemp_.Relationship, dvClassNull), \
    dvRelationshipSetNextClassChildRelationship(dvTemp_.Relationship, dvRelationshipNull), \
    dvRelationshipSetChildClass(dvTemp_.Relationship, dvClassNull), \
    dvRelationshipSetNextClassParentRelationship(dvTemp_.Relationship, dvRelationshipNull), \
    dvRelationshipSetFirstProperty(dvTemp_.Relationship, dvPropertyNull), \
    dvRelationshipSetLastProperty(dvTemp_.Relationship, dvPropertyNull), \
    dvRelationshipSetFirstKey(dvTemp_.Relationship, dvKeyNull), \
    dvRelationshipSetLastKey(dvTemp_.Relationship, dvKeyNull), \
    dvRelationshipSetParentSparsegroup(dvTemp_.Relationship, dvSparsegroupNull), \
    dvRelationshipSetChildSparsegroup(dvTemp_.Relationship, dvSparsegroupNull), \
    dvRelationshipConstructorCallback != NULL && (dvRelationshipConstructorCallback(dvTemp_.Relationship), true), \
    dvTemp_.Relationship)

void dvRelationshipAllocMore(void);
void dvRelationshipCopyProps(dvRelationship dvOldRelationship, dvRelationship dvNewRelationship);
void dvRelationshipSetBitfield(dvRelationship _Relationship, uint32 bitfield);
uint32 dvRelationshipGetBitfield(dvRelationship _Relationship);
void dvRelationshipInsertProperty(dvRelationship Relationship, dvProperty _Property);
void dvRelationshipRemoveProperty(dvRelationship Relationship, dvProperty _Property);
void dvRelationshipInsertAfterProperty(dvRelationship Relationship, dvProperty prevProperty, dvProperty _Property);
void dvRelationshipAppendProperty(dvRelationship Relationship, dvProperty _Property);
void dvRelationshipInsertKey(dvRelationship Relationship, dvKey _Key);
void dvRelationshipRemoveKey(dvRelationship Relationship, dvKey _Key);
void dvRelationshipInsertAfterKey(dvRelationship Relationship, dvKey prevKey, dvKey _Key);
void dvRelationshipAppendKey(dvRelationship Relationship, dvKey _Key);

/*----------------------------------------------------------------------------------------
  Fields for class Key.
----------------------------------------------------------------------------------------*/
struct dvKeyFields {
    utSym *PropertySym;
    uint32 *LineNum;
    dvProperty *Property;
    dvKey *NextPropertyKey;
    dvRelationship *Relationship;
    dvKey *NextRelationshipKey;
};
extern struct dvKeyFields dvKeys;

#define dvKeyGetPropertySym(_Key) (dvKeys.PropertySym[dvKey2ValidIndex(_Key)])
#define dvKeySetPropertySym(_Key, value) ((dvKeys.PropertySym)[dvKey2ValidIndex(_Key)] = (value))
#define dvKeyGetLineNum(_Key) (dvKeys.LineNum[dvKey2ValidIndex(_Key)])
#define dvKeySetLineNum(_Key, value) ((dvKeys.LineNum)[dvKey2ValidIndex(_Key)] = (value))
#define dvKeyGetProperty(_Key) (dvKeys.Property[dvKey2ValidIndex(_Key)])
#define dvKeySetProperty(_Key, value) ((dvKeys.Property)[dvKey2ValidIndex(_Key)] = (value))
#define dvKeyGetNextPropertyKey(_Key) (dvKeys.NextPropertyKey[dvKey2ValidIndex(_Key)])
#define dvKeySetNextPropertyKey(_Key, value) ((dvKeys.NextPropertyKey)[dvKey2ValidIndex(_Key)] = (value))
#define dvKeyGetRelationship(_Key) (dvKeys.Relationship[dvKey2ValidIndex(_Key)])
#define dvKeySetRelationship(_Key, value) ((dvKeys.Relationship)[dvKey2ValidIndex(_Key)] = (value))
#define dvKeyGetNextRelationshipKey(_Key) (dvKeys.NextRelationshipKey[dvKey2ValidIndex(_Key)])
#define dvKeySetNextRelationshipKey(_Key, value) ((dvKeys.NextRelationshipKey)[dvKey2ValidIndex(_Key)] = (value))
#define dvKeySetConstructorCallback(func) (dvKeyConstructorCallback = (func))
#define dvKeyGetConstructorCallback() (dvKeyConstructorCallback)
#define dvKeySetDestructorCallback(func) (dvKeyDestructorCallback = (func))
#define dvKeyGetDestructorCallback() (dvKeyDestructorCallback)
#define dvKeyNextFree(_Key) (((dvKey *)(void *)(dvKeys.Property))[dvKey2ValidIndex(_Key)])
#define dvKeySetNextFree(_Key, value) (((dvKey *)(void *)(dvKeys.Property)) \
    [dvKey2ValidIndex(_Key)] = (value))
#define dvKeyAllocRaw() ( \
    dvRootData.firstFreeKey != dvKeyNull? \
        (dvTemp_.Key = dvRootData.firstFreeKey, \
        dvSetFirstFreeKey(dvKeyNextFree(dvTemp_.Key)), true) \
    : (dvRootData.usedKey == dvRootData.allocatedKey && (dvKeyAllocMore(), true), \
        dvTemp_.Key = dvIndex2Key(dvRootData.usedKey), \
        dvSetUsedKey(dvUsedKey() + 1)), \
    dvTemp_.Key)
#define dvKeyAlloc() ( \
    dvRootData.firstFreeKey != dvKeyNull? \
        (dvTemp_.Key = dvRootData.firstFreeKey, \
        dvSetFirstFreeKey(dvKeyNextFree(dvTemp_.Key)), true) \
    : (dvRootData.usedKey == dvRootData.allocatedKey && (dvKeyAllocMore(), true), \
        dvTemp_.Key = dvIndex2Key(dvRootData.usedKey), \
        dvSetUsedKey(dvUsedKey() + 1)), \
    dvKeySetPropertySym(dvTemp_.Key, utSymNull), \
    dvKeySetLineNum(dvTemp_.Key, 0), \
    dvKeySetProperty(dvTemp_.Key, dvPropertyNull), \
    dvKeySetNextPropertyKey(dvTemp_.Key, dvKeyNull), \
    dvKeySetRelationship(dvTemp_.Key, dvRelationshipNull), \
    dvKeySetNextRelationshipKey(dvTemp_.Key, dvKeyNull), \
    dvKeyConstructorCallback != NULL && (dvKeyConstructorCallback(dvTemp_.Key), true), \
    dvTemp_.Key)

#define dvKeyFree(Key) (dvKeySetNextFree(Key, dvRootData.firstFreeKey), \
    dvSetFirstFreeKey(Key))
void dvKeyDestroy(dvKey Key);
void dvKeyAllocMore(void);
void dvKeyCopyProps(dvKey dvOldKey, dvKey dvNewKey);

/*----------------------------------------------------------------------------------------
  Fields for class Union.
----------------------------------------------------------------------------------------*/
struct dvUnionFields {
    utSym *PropertySym;
    dvProperty *TypeProperty;
    uint32 *Line;
    uint16 *Number;
    uint32 *FieldNumber;
    uint16 *NumCases;
    dvClass *Class;
    dvUnion *NextClassUnion;
    dvProperty *FirstProperty;
    dvProperty *LastProperty;
};
extern struct dvUnionFields dvUnions;

#define dvUnionGetPropertySym(_Union) (dvUnions.PropertySym[dvUnion2ValidIndex(_Union)])
#define dvUnionSetPropertySym(_Union, value) ((dvUnions.PropertySym)[dvUnion2ValidIndex(_Union)] = (value))
#define dvUnionGetTypeProperty(_Union) (dvUnions.TypeProperty[dvUnion2ValidIndex(_Union)])
#define dvUnionSetTypeProperty(_Union, value) ((dvUnions.TypeProperty)[dvUnion2ValidIndex(_Union)] = (value))
#define dvUnionGetLine(_Union) (dvUnions.Line[dvUnion2ValidIndex(_Union)])
#define dvUnionSetLine(_Union, value) ((dvUnions.Line)[dvUnion2ValidIndex(_Union)] = (value))
#define dvUnionGetNumber(_Union) (dvUnions.Number[dvUnion2ValidIndex(_Union)])
#define dvUnionSetNumber(_Union, value) ((dvUnions.Number)[dvUnion2ValidIndex(_Union)] = (value))
#define dvUnionGetFieldNumber(_Union) (dvUnions.FieldNumber[dvUnion2ValidIndex(_Union)])
#define dvUnionSetFieldNumber(_Union, value) ((dvUnions.FieldNumber)[dvUnion2ValidIndex(_Union)] = (value))
#define dvUnionGetNumCases(_Union) (dvUnions.NumCases[dvUnion2ValidIndex(_Union)])
#define dvUnionSetNumCases(_Union, value) ((dvUnions.NumCases)[dvUnion2ValidIndex(_Union)] = (value))
#define dvUnionGetClass(_Union) (dvUnions.Class[dvUnion2ValidIndex(_Union)])
#define dvUnionSetClass(_Union, value) ((dvUnions.Class)[dvUnion2ValidIndex(_Union)] = (value))
#define dvUnionGetNextClassUnion(_Union) (dvUnions.NextClassUnion[dvUnion2ValidIndex(_Union)])
#define dvUnionSetNextClassUnion(_Union, value) ((dvUnions.NextClassUnion)[dvUnion2ValidIndex(_Union)] = (value))
#define dvUnionGetFirstProperty(_Union) (dvUnions.FirstProperty[dvUnion2ValidIndex(_Union)])
#define dvUnionSetFirstProperty(_Union, value) ((dvUnions.FirstProperty)[dvUnion2ValidIndex(_Union)] = (value))
#define dvUnionGetLastProperty(_Union) (dvUnions.LastProperty[dvUnion2ValidIndex(_Union)])
#define dvUnionSetLastProperty(_Union, value) ((dvUnions.LastProperty)[dvUnion2ValidIndex(_Union)] = (value))
#define dvForeachUnionProperty(pVar, cVar) \
    for(cVar = dvUnionGetFirstProperty(pVar); cVar != dvPropertyNull; \
        cVar = dvPropertyGetNextUnionProperty(cVar))
#define dvEndUnionProperty
#define dvSafeForeachUnionProperty(pVar, cVar) { \
    dvProperty _nextProperty; \
    for(cVar = dvUnionGetFirstProperty(pVar); cVar != dvPropertyNull; cVar = _nextProperty) { \
        _nextProperty = dvPropertyGetNextUnionProperty(cVar);
#define dvEndSafeUnionProperty }}
#define dvUnionSetConstructorCallback(func) (dvUnionConstructorCallback = (func))
#define dvUnionGetConstructorCallback() (dvUnionConstructorCallback)
#define dvUnionSetDestructorCallback(func) (dvUnionDestructorCallback = (func))
#define dvUnionGetDestructorCallback() (dvUnionDestructorCallback)
#define dvUnionNextFree(_Union) (((dvUnion *)(void *)(dvUnions.TypeProperty))[dvUnion2ValidIndex(_Union)])
#define dvUnionSetNextFree(_Union, value) (((dvUnion *)(void *)(dvUnions.TypeProperty)) \
    [dvUnion2ValidIndex(_Union)] = (value))
#define dvUnionAllocRaw() ( \
    dvRootData.firstFreeUnion != dvUnionNull? \
        (dvTemp_.Union = dvRootData.firstFreeUnion, \
        dvSetFirstFreeUnion(dvUnionNextFree(dvTemp_.Union)), true) \
    : (dvRootData.usedUnion == dvRootData.allocatedUnion && (dvUnionAllocMore(), true), \
        dvTemp_.Union = dvIndex2Union(dvRootData.usedUnion), \
        dvSetUsedUnion(dvUsedUnion() + 1)), \
    dvTemp_.Union)
#define dvUnionAlloc() ( \
    dvRootData.firstFreeUnion != dvUnionNull? \
        (dvTemp_.Union = dvRootData.firstFreeUnion, \
        dvSetFirstFreeUnion(dvUnionNextFree(dvTemp_.Union)), true) \
    : (dvRootData.usedUnion == dvRootData.allocatedUnion && (dvUnionAllocMore(), true), \
        dvTemp_.Union = dvIndex2Union(dvRootData.usedUnion), \
        dvSetUsedUnion(dvUsedUnion() + 1)), \
    dvUnionSetPropertySym(dvTemp_.Union, utSymNull), \
    dvUnionSetTypeProperty(dvTemp_.Union, dvPropertyNull), \
    dvUnionSetLine(dvTemp_.Union, 0), \
    dvUnionSetNumber(dvTemp_.Union, 0), \
    dvUnionSetFieldNumber(dvTemp_.Union, 0), \
    dvUnionSetNumCases(dvTemp_.Union, 0), \
    dvUnionSetClass(dvTemp_.Union, dvClassNull), \
    dvUnionSetNextClassUnion(dvTemp_.Union, dvUnionNull), \
    dvUnionSetFirstProperty(dvTemp_.Union, dvPropertyNull), \
    dvUnionSetLastProperty(dvTemp_.Union, dvPropertyNull), \
    dvUnionConstructorCallback != NULL && (dvUnionConstructorCallback(dvTemp_.Union), true), \
    dvTemp_.Union)

#define dvUnionFree(Union) (dvUnionSetNextFree(Union, dvRootData.firstFreeUnion), \
    dvSetFirstFreeUnion(Union))
void dvUnionDestroy(dvUnion Union);
void dvUnionAllocMore(void);
void dvUnionCopyProps(dvUnion dvOldUnion, dvUnion dvNewUnion);
void dvUnionInsertProperty(dvUnion Union, dvProperty _Property);
void dvUnionRemoveProperty(dvUnion Union, dvProperty _Property);
void dvUnionInsertAfterProperty(dvUnion Union, dvProperty prevProperty, dvProperty _Property);
void dvUnionAppendProperty(dvUnion Union, dvProperty _Property);

/*----------------------------------------------------------------------------------------
  Fields for class Case.
----------------------------------------------------------------------------------------*/
struct dvCaseFields {
    utSym *EntrySym;
    dvEntry *Entry;
    dvCase *NextEntryCase;
    dvProperty *Property;
    dvCase *NextPropertyCase;
};
extern struct dvCaseFields dvCases;

#define dvCaseGetEntrySym(_Case) (dvCases.EntrySym[dvCase2ValidIndex(_Case)])
#define dvCaseSetEntrySym(_Case, value) ((dvCases.EntrySym)[dvCase2ValidIndex(_Case)] = (value))
#define dvCaseGetEntry(_Case) (dvCases.Entry[dvCase2ValidIndex(_Case)])
#define dvCaseSetEntry(_Case, value) ((dvCases.Entry)[dvCase2ValidIndex(_Case)] = (value))
#define dvCaseGetNextEntryCase(_Case) (dvCases.NextEntryCase[dvCase2ValidIndex(_Case)])
#define dvCaseSetNextEntryCase(_Case, value) ((dvCases.NextEntryCase)[dvCase2ValidIndex(_Case)] = (value))
#define dvCaseGetProperty(_Case) (dvCases.Property[dvCase2ValidIndex(_Case)])
#define dvCaseSetProperty(_Case, value) ((dvCases.Property)[dvCase2ValidIndex(_Case)] = (value))
#define dvCaseGetNextPropertyCase(_Case) (dvCases.NextPropertyCase[dvCase2ValidIndex(_Case)])
#define dvCaseSetNextPropertyCase(_Case, value) ((dvCases.NextPropertyCase)[dvCase2ValidIndex(_Case)] = (value))
#define dvCaseSetConstructorCallback(func) (dvCaseConstructorCallback = (func))
#define dvCaseGetConstructorCallback() (dvCaseConstructorCallback)
#define dvCaseSetDestructorCallback(func) (dvCaseDestructorCallback = (func))
#define dvCaseGetDestructorCallback() (dvCaseDestructorCallback)
#define dvCaseNextFree(_Case) (((dvCase *)(void *)(dvCases.Entry))[dvCase2ValidIndex(_Case)])
#define dvCaseSetNextFree(_Case, value) (((dvCase *)(void *)(dvCases.Entry)) \
    [dvCase2ValidIndex(_Case)] = (value))
#define dvCaseAllocRaw() ( \
    dvRootData.firstFreeCase != dvCaseNull? \
        (dvTemp_.Case = dvRootData.firstFreeCase, \
        dvSetFirstFreeCase(dvCaseNextFree(dvTemp_.Case)), true) \
    : (dvRootData.usedCase == dvRootData.allocatedCase && (dvCaseAllocMore(), true), \
        dvTemp_.Case = dvIndex2Case(dvRootData.usedCase), \
        dvSetUsedCase(dvUsedCase() + 1)), \
    dvTemp_.Case)
#define dvCaseAlloc() ( \
    dvRootData.firstFreeCase != dvCaseNull? \
        (dvTemp_.Case = dvRootData.firstFreeCase, \
        dvSetFirstFreeCase(dvCaseNextFree(dvTemp_.Case)), true) \
    : (dvRootData.usedCase == dvRootData.allocatedCase && (dvCaseAllocMore(), true), \
        dvTemp_.Case = dvIndex2Case(dvRootData.usedCase), \
        dvSetUsedCase(dvUsedCase() + 1)), \
    dvCaseSetEntrySym(dvTemp_.Case, utSymNull), \
    dvCaseSetEntry(dvTemp_.Case, dvEntryNull), \
    dvCaseSetNextEntryCase(dvTemp_.Case, dvCaseNull), \
    dvCaseSetProperty(dvTemp_.Case, dvPropertyNull), \
    dvCaseSetNextPropertyCase(dvTemp_.Case, dvCaseNull), \
    dvCaseConstructorCallback != NULL && (dvCaseConstructorCallback(dvTemp_.Case), true), \
    dvTemp_.Case)

#define dvCaseFree(Case) (dvCaseSetNextFree(Case, dvRootData.firstFreeCase), \
    dvSetFirstFreeCase(Case))
void dvCaseDestroy(dvCase Case);
void dvCaseAllocMore(void);
void dvCaseCopyProps(dvCase dvOldCase, dvCase dvNewCase);

/*----------------------------------------------------------------------------------------
  Temp Union structure - Macro temp variables, use only one
----------------------------------------------------------------------------------------*/
union dvTempType_ {
    dvRoot Root;
    dvModpath Modpath;
    dvModule Module;
    dvLink Link;
    dvSchema Schema;
    dvEnum Enum;
    dvEntry Entry;
    dvTypedef Typedef;
    dvClass Class;
    dvProperty Property;
    dvSparsegroup Sparsegroup;
    dvRelationship Relationship;
    dvKey Key;
    dvUnion Union;
    dvCase Case;
};

extern union dvTempType_ dvTemp_;

/*----------------------------------------------------------------------------------------
  Constructor/Destructor hooks.
----------------------------------------------------------------------------------------*/
extern void(*dvRootConstructorCallback)(dvRoot);
extern void(*dvModpathConstructorCallback)(dvModpath);
extern void(*dvModuleConstructorCallback)(dvModule);
extern void(*dvLinkConstructorCallback)(dvLink);
extern void(*dvSchemaConstructorCallback)(dvSchema);
extern void(*dvEnumConstructorCallback)(dvEnum);
extern void(*dvEntryConstructorCallback)(dvEntry);
extern void(*dvTypedefConstructorCallback)(dvTypedef);
extern void(*dvClassConstructorCallback)(dvClass);
extern void(*dvPropertyConstructorCallback)(dvProperty);
extern void(*dvSparsegroupConstructorCallback)(dvSparsegroup);
extern void(*dvSparsegroupDestructorCallback)(dvSparsegroup);
extern void(*dvRelationshipConstructorCallback)(dvRelationship);
extern void(*dvKeyConstructorCallback)(dvKey);
extern void(*dvKeyDestructorCallback)(dvKey);
extern void(*dvUnionConstructorCallback)(dvUnion);
extern void(*dvUnionDestructorCallback)(dvUnion);
extern void(*dvCaseConstructorCallback)(dvCase);
extern void(*dvCaseDestructorCallback)(dvCase);

/*----------------------------------------------------------------------------------------
  Root structure
----------------------------------------------------------------------------------------*/
struct dvRootType_ {
    uint32 hash; /* This depends only on the structure of the database */
    uint32 usedRoot, allocatedRoot;
    uint32 usedRootModpathTable, allocatedRootModpathTable, freeRootModpathTable;
    uint32 usedRootModuleTable, allocatedRootModuleTable, freeRootModuleTable;
    uint32 usedModpath, allocatedModpath;
    uint32 usedModule, allocatedModule;
    uint32 usedModuleClassTable, allocatedModuleClassTable, freeModuleClassTable;
    uint32 usedModuleEnumTable, allocatedModuleEnumTable, freeModuleEnumTable;
    uint32 usedModuleTypedefTable, allocatedModuleTypedefTable, freeModuleTypedefTable;
    uint32 usedModuleSchemaTable, allocatedModuleSchemaTable, freeModuleSchemaTable;
    uint32 usedLink, allocatedLink;
    uint32 usedSchema, allocatedSchema;
    uint32 usedEnum, allocatedEnum;
    uint32 usedEnumEntryTable, allocatedEnumEntryTable, freeEnumEntryTable;
    uint32 usedEntry, allocatedEntry;
    uint32 usedTypedef, allocatedTypedef;
    uint32 usedTypedefInitializer, allocatedTypedefInitializer, freeTypedefInitializer;
    uint32 usedClass, allocatedClass;
    uint32 usedClassPropertyTable, allocatedClassPropertyTable, freeClassPropertyTable;
    uint32 usedClassSparsegroupTable, allocatedClassSparsegroupTable, freeClassSparsegroupTable;
    uint32 usedProperty, allocatedProperty;
    uint32 usedPropertyInitializer, allocatedPropertyInitializer, freePropertyInitializer;
    uint32 usedPropertyIndex, allocatedPropertyIndex, freePropertyIndex;
    dvSparsegroup firstFreeSparsegroup;
    uint32 usedSparsegroup, allocatedSparsegroup;
    uint32 usedRelationship, allocatedRelationship;
    dvKey firstFreeKey;
    uint32 usedKey, allocatedKey;
    dvUnion firstFreeUnion;
    uint32 usedUnion, allocatedUnion;
    dvCase firstFreeCase;
    uint32 usedCase, allocatedCase;
};
extern struct dvRootType_ dvRootData;

#define dvHash() (dvRootData.hash)
#define dvUsedRoot() dvRootData.usedRoot
#define dvAllocatedRoot() dvRootData.allocatedRoot
#define dvSetUsedRoot(value) (dvRootData.usedRoot = (value))
#define dvSetAllocatedRoot(value) (dvRootData.allocatedRoot = (value))
#define dvUsedRootModpathTable() dvRootData.usedRootModpathTable
#define dvAllocatedRootModpathTable() dvRootData.allocatedRootModpathTable
#define dvFreeRootModpathTable() dvRootData.freeRootModpathTable
#define dvSetUsedRootModpathTable(value) (dvRootData.usedRootModpathTable = (value))
#define dvSetAllocatedRootModpathTable(value) (dvRootData.allocatedRootModpathTable = (value))
#define dvSetFreeRootModpathTable(value) (dvRootData.freeRootModpathTable = (value))
#define dvUsedRootModuleTable() dvRootData.usedRootModuleTable
#define dvAllocatedRootModuleTable() dvRootData.allocatedRootModuleTable
#define dvFreeRootModuleTable() dvRootData.freeRootModuleTable
#define dvSetUsedRootModuleTable(value) (dvRootData.usedRootModuleTable = (value))
#define dvSetAllocatedRootModuleTable(value) (dvRootData.allocatedRootModuleTable = (value))
#define dvSetFreeRootModuleTable(value) (dvRootData.freeRootModuleTable = (value))
#define dvUsedModpath() dvRootData.usedModpath
#define dvAllocatedModpath() dvRootData.allocatedModpath
#define dvSetUsedModpath(value) (dvRootData.usedModpath = (value))
#define dvSetAllocatedModpath(value) (dvRootData.allocatedModpath = (value))
#define dvUsedModule() dvRootData.usedModule
#define dvAllocatedModule() dvRootData.allocatedModule
#define dvSetUsedModule(value) (dvRootData.usedModule = (value))
#define dvSetAllocatedModule(value) (dvRootData.allocatedModule = (value))
#define dvUsedModuleClassTable() dvRootData.usedModuleClassTable
#define dvAllocatedModuleClassTable() dvRootData.allocatedModuleClassTable
#define dvFreeModuleClassTable() dvRootData.freeModuleClassTable
#define dvSetUsedModuleClassTable(value) (dvRootData.usedModuleClassTable = (value))
#define dvSetAllocatedModuleClassTable(value) (dvRootData.allocatedModuleClassTable = (value))
#define dvSetFreeModuleClassTable(value) (dvRootData.freeModuleClassTable = (value))
#define dvUsedModuleEnumTable() dvRootData.usedModuleEnumTable
#define dvAllocatedModuleEnumTable() dvRootData.allocatedModuleEnumTable
#define dvFreeModuleEnumTable() dvRootData.freeModuleEnumTable
#define dvSetUsedModuleEnumTable(value) (dvRootData.usedModuleEnumTable = (value))
#define dvSetAllocatedModuleEnumTable(value) (dvRootData.allocatedModuleEnumTable = (value))
#define dvSetFreeModuleEnumTable(value) (dvRootData.freeModuleEnumTable = (value))
#define dvUsedModuleTypedefTable() dvRootData.usedModuleTypedefTable
#define dvAllocatedModuleTypedefTable() dvRootData.allocatedModuleTypedefTable
#define dvFreeModuleTypedefTable() dvRootData.freeModuleTypedefTable
#define dvSetUsedModuleTypedefTable(value) (dvRootData.usedModuleTypedefTable = (value))
#define dvSetAllocatedModuleTypedefTable(value) (dvRootData.allocatedModuleTypedefTable = (value))
#define dvSetFreeModuleTypedefTable(value) (dvRootData.freeModuleTypedefTable = (value))
#define dvUsedModuleSchemaTable() dvRootData.usedModuleSchemaTable
#define dvAllocatedModuleSchemaTable() dvRootData.allocatedModuleSchemaTable
#define dvFreeModuleSchemaTable() dvRootData.freeModuleSchemaTable
#define dvSetUsedModuleSchemaTable(value) (dvRootData.usedModuleSchemaTable = (value))
#define dvSetAllocatedModuleSchemaTable(value) (dvRootData.allocatedModuleSchemaTable = (value))
#define dvSetFreeModuleSchemaTable(value) (dvRootData.freeModuleSchemaTable = (value))
#define dvUsedLink() dvRootData.usedLink
#define dvAllocatedLink() dvRootData.allocatedLink
#define dvSetUsedLink(value) (dvRootData.usedLink = (value))
#define dvSetAllocatedLink(value) (dvRootData.allocatedLink = (value))
#define dvUsedSchema() dvRootData.usedSchema
#define dvAllocatedSchema() dvRootData.allocatedSchema
#define dvSetUsedSchema(value) (dvRootData.usedSchema = (value))
#define dvSetAllocatedSchema(value) (dvRootData.allocatedSchema = (value))
#define dvUsedEnum() dvRootData.usedEnum
#define dvAllocatedEnum() dvRootData.allocatedEnum
#define dvSetUsedEnum(value) (dvRootData.usedEnum = (value))
#define dvSetAllocatedEnum(value) (dvRootData.allocatedEnum = (value))
#define dvUsedEnumEntryTable() dvRootData.usedEnumEntryTable
#define dvAllocatedEnumEntryTable() dvRootData.allocatedEnumEntryTable
#define dvFreeEnumEntryTable() dvRootData.freeEnumEntryTable
#define dvSetUsedEnumEntryTable(value) (dvRootData.usedEnumEntryTable = (value))
#define dvSetAllocatedEnumEntryTable(value) (dvRootData.allocatedEnumEntryTable = (value))
#define dvSetFreeEnumEntryTable(value) (dvRootData.freeEnumEntryTable = (value))
#define dvUsedEntry() dvRootData.usedEntry
#define dvAllocatedEntry() dvRootData.allocatedEntry
#define dvSetUsedEntry(value) (dvRootData.usedEntry = (value))
#define dvSetAllocatedEntry(value) (dvRootData.allocatedEntry = (value))
#define dvUsedTypedef() dvRootData.usedTypedef
#define dvAllocatedTypedef() dvRootData.allocatedTypedef
#define dvSetUsedTypedef(value) (dvRootData.usedTypedef = (value))
#define dvSetAllocatedTypedef(value) (dvRootData.allocatedTypedef = (value))
#define dvUsedTypedefInitializer() dvRootData.usedTypedefInitializer
#define dvAllocatedTypedefInitializer() dvRootData.allocatedTypedefInitializer
#define dvFreeTypedefInitializer() dvRootData.freeTypedefInitializer
#define dvSetUsedTypedefInitializer(value) (dvRootData.usedTypedefInitializer = (value))
#define dvSetAllocatedTypedefInitializer(value) (dvRootData.allocatedTypedefInitializer = (value))
#define dvSetFreeTypedefInitializer(value) (dvRootData.freeTypedefInitializer = (value))
#define dvUsedClass() dvRootData.usedClass
#define dvAllocatedClass() dvRootData.allocatedClass
#define dvSetUsedClass(value) (dvRootData.usedClass = (value))
#define dvSetAllocatedClass(value) (dvRootData.allocatedClass = (value))
#define dvUsedClassPropertyTable() dvRootData.usedClassPropertyTable
#define dvAllocatedClassPropertyTable() dvRootData.allocatedClassPropertyTable
#define dvFreeClassPropertyTable() dvRootData.freeClassPropertyTable
#define dvSetUsedClassPropertyTable(value) (dvRootData.usedClassPropertyTable = (value))
#define dvSetAllocatedClassPropertyTable(value) (dvRootData.allocatedClassPropertyTable = (value))
#define dvSetFreeClassPropertyTable(value) (dvRootData.freeClassPropertyTable = (value))
#define dvUsedClassSparsegroupTable() dvRootData.usedClassSparsegroupTable
#define dvAllocatedClassSparsegroupTable() dvRootData.allocatedClassSparsegroupTable
#define dvFreeClassSparsegroupTable() dvRootData.freeClassSparsegroupTable
#define dvSetUsedClassSparsegroupTable(value) (dvRootData.usedClassSparsegroupTable = (value))
#define dvSetAllocatedClassSparsegroupTable(value) (dvRootData.allocatedClassSparsegroupTable = (value))
#define dvSetFreeClassSparsegroupTable(value) (dvRootData.freeClassSparsegroupTable = (value))
#define dvUsedProperty() dvRootData.usedProperty
#define dvAllocatedProperty() dvRootData.allocatedProperty
#define dvSetUsedProperty(value) (dvRootData.usedProperty = (value))
#define dvSetAllocatedProperty(value) (dvRootData.allocatedProperty = (value))
#define dvUsedPropertyInitializer() dvRootData.usedPropertyInitializer
#define dvAllocatedPropertyInitializer() dvRootData.allocatedPropertyInitializer
#define dvFreePropertyInitializer() dvRootData.freePropertyInitializer
#define dvSetUsedPropertyInitializer(value) (dvRootData.usedPropertyInitializer = (value))
#define dvSetAllocatedPropertyInitializer(value) (dvRootData.allocatedPropertyInitializer = (value))
#define dvSetFreePropertyInitializer(value) (dvRootData.freePropertyInitializer = (value))
#define dvUsedPropertyIndex() dvRootData.usedPropertyIndex
#define dvAllocatedPropertyIndex() dvRootData.allocatedPropertyIndex
#define dvFreePropertyIndex() dvRootData.freePropertyIndex
#define dvSetUsedPropertyIndex(value) (dvRootData.usedPropertyIndex = (value))
#define dvSetAllocatedPropertyIndex(value) (dvRootData.allocatedPropertyIndex = (value))
#define dvSetFreePropertyIndex(value) (dvRootData.freePropertyIndex = (value))
#define dvFirstFreeSparsegroup() dvRootData.firstFreeSparsegroup
#define dvSetFirstFreeSparsegroup(value) (dvRootData.firstFreeSparsegroup = (value))
#define dvUsedSparsegroup() dvRootData.usedSparsegroup
#define dvAllocatedSparsegroup() dvRootData.allocatedSparsegroup
#define dvSetUsedSparsegroup(value) (dvRootData.usedSparsegroup = (value))
#define dvSetAllocatedSparsegroup(value) (dvRootData.allocatedSparsegroup = (value))
#define dvUsedRelationship() dvRootData.usedRelationship
#define dvAllocatedRelationship() dvRootData.allocatedRelationship
#define dvSetUsedRelationship(value) (dvRootData.usedRelationship = (value))
#define dvSetAllocatedRelationship(value) (dvRootData.allocatedRelationship = (value))
#define dvFirstFreeKey() dvRootData.firstFreeKey
#define dvSetFirstFreeKey(value) (dvRootData.firstFreeKey = (value))
#define dvUsedKey() dvRootData.usedKey
#define dvAllocatedKey() dvRootData.allocatedKey
#define dvSetUsedKey(value) (dvRootData.usedKey = (value))
#define dvSetAllocatedKey(value) (dvRootData.allocatedKey = (value))
#define dvFirstFreeUnion() dvRootData.firstFreeUnion
#define dvSetFirstFreeUnion(value) (dvRootData.firstFreeUnion = (value))
#define dvUsedUnion() dvRootData.usedUnion
#define dvAllocatedUnion() dvRootData.allocatedUnion
#define dvSetUsedUnion(value) (dvRootData.usedUnion = (value))
#define dvSetAllocatedUnion(value) (dvRootData.allocatedUnion = (value))
#define dvFirstFreeCase() dvRootData.firstFreeCase
#define dvSetFirstFreeCase(value) (dvRootData.firstFreeCase = (value))
#define dvUsedCase() dvRootData.usedCase
#define dvAllocatedCase() dvRootData.allocatedCase
#define dvSetUsedCase(value) (dvRootData.usedCase = (value))
#define dvSetAllocatedCase(value) (dvRootData.allocatedCase = (value))

extern uint8 dvModuleID;
void dvDatabaseStart(void);
void dvDatabaseStop(void);
#if defined __cplusplus
}
#endif

#endif
