.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XcmsCIELabQueryMax __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XcmsCIELabQueryMaxC, XcmsCIELabQueryMaxL, XcmsCIELabQueryMaxLC, XcmsCIELabQueryMinL \- obtain the CIE L*a*b* coordinates
.SH SYNTAX
.HP
Status XcmsCIELabQueryMaxC\^(\^XcmsCCC \fIccc\fP\^, XcmsFloat
\fIhue_angle\fP\^, XcmsFloat \fIL_star\fP\^, XcmsColor *\fIcolor_return\fP\^);
.HP
Status XcmsCIELabQueryMaxL\^(\^XcmsCCC \fIccc\fP\^, XcmsFloat
\fIhue_angle\fP\^, XcmsFloat \fIchroma\fP\^, XcmsColor *\fIcolor_return\fP\^);
.HP
Status XcmsCIELabQueryMaxLC\^(\^XcmsCCC \fIccc\fP\^, XcmsFloat
\fIhue_angle\fP\^, XcmsColor *\fIcolor_return\fP\^);
.HP
Status XcmsCIELabQueryMinL\^(\^XcmsCCC \fIccc\fP\^, XcmsFloat
\fIhue_angle\fP\^, XcmsFloat \fIchroma\fP\^, XcmsColor *\fIcolor_return\fP\^);
.SH ARGUMENTS
.IP \fIccc\fP 1i
Specifies the CCC.
Note that the CCC's Client White Point and White Point Adjustment procedures
are ignored.
.IP \fIchroma\fP 1i
Specifies the chroma at which to find maximum lightness (MaxL) or minimum lightness (MinL).
.IP \fIcolor_return\fP 1i
Returns the CIE L*a*b* coordinates of
maximum chroma (MaxC and MaxLC), maximum lightness (MaxL),
or minimum lightness (MinL)
displayable by the screen for the given hue angle and lightness (MaxC), hue angle and chroma (MaxL and MinL), or hue angle (MaxLC).
The white point associated with the returned
color specification is the Screen White Point.
The value returned in the pixel member is undefined.
.IP \fIhue_angle\fP 1i
Specifies the hue angle (in degrees) at which to find maximum chroma (MaxC and MaxLC), maximum lightness (MaxL),
or minimum lightness (MinL).
.IP \fIL_star\fP 1i
Specifies the lightness (L*) at which to find maximum chroma (MaxC).
.SH DESCRIPTION
The
.B XcmsCIELabQueryMaxC
function, given a hue angle and lightness,
finds the point of maximum chroma displayable by the screen.
It returns this point in CIE L*a*b* coordinates.
.LP
The
.B XcmsCIELabQueryMaxL
function, given a hue angle and chroma,
finds the point in CIE L*a*b* color space of maximum
lightness (L*) displayable by the screen.
It returns this point in CIE L*a*b* coordinates.
An
.B XcmsFailure
return value usually indicates that the given chroma
is beyond maximum for the given hue angle.
.LP
The
.B XcmsCIELabQueryMaxLC
function, given a hue angle,
finds the point of maximum chroma displayable by the screen.
It returns this point in CIE L*a*b* coordinates.
.LP
The
.B XcmsCIELabQueryMinL
function, given a hue angle and chroma,
finds the point of minimum lightness (L*) displayable by the screen.
It returns this point in CIE L*a*b* coordinates.
An
.B XcmsFailure
return value usually indicates that the given chroma
is beyond maximum for the given hue angle.
.SH "SEE ALSO"
.BR XcmsCIELuvQueryMaxC (__libmansuffix__),
.BR XcmsTekHVCQueryMaxC (__libmansuffix__),
.BR XcmsQueryBlack (__libmansuffix__)
.br
\fI\*(xL\fP
