.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetKeyModifierMap __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetKeyModifierMap \- Update the modifier map for one or more of the keys in a
keyboard description
.SH SYNOPSIS
.HP
.B Status XkbGetKeyModifierMap
.BI "(\^Display *" "dpy" "\^,"
.BI "unsigned int " "first" "\^,"
.BI "unsigned int " "num" "\^,"
.BI "XkbDescPtr " "xkb" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I dpy
connection to X server
.TP
.I first
keycode of first key to get
.TP
.I num
number of keys for which information is desired
.TP
.I xkb
keyboard description to update
.SH DESCRIPTION
.LP
The
.I modmap
entry of the client map is an array, indexed by keycode, specifying the real
modifiers bound to a key. Each entry is a mask composed of a bitwise inclusive
OR of the legal real modifiers: ShiftMask, LockMask, ControlMask, Mod1Mask,
Mod2Mask, Mod3Mask, Mod4Mask, and Mod5Mask. If a bit is set in a
.I modmap
entry, the corresponding key is bound to that modifier.

Pressing or releasing the key bound to a modifier changes the modifier set and
unset state. The particular manner in which the modifier set and unset state
changes is determined by the behavior and actions assigned to the key.

.I XkbGetKeyModifierMap
sends a request to the server for the modifier mappings for
.I num
keys starting with the key whose keycode is
.I first.
It waits for a reply and places the results in the
.I xkb->map->modmap
array. If successful,
.I XkbGetKeyModifier
returns Success.

If the map component of the
.I xkb
parameter has not been allocated,
.I XkbGetKeyModifierMap
allocates and initializes it.

If a compatible version of Xkb is not available in the server or the Xkb
extension has not been properly initialized,
.I XkbGetKeySyms
returns BadAccess. If any allocation errors occur while obtaining the modifier
map,
.I XkbGetKeyModifierMap
returns BadAlloc.
.SH DIAGNOSTICS
.TP 15
.B BadAccess
The Xkb extension has not been properly initialized
.TP 15
.B BadAlloc
Unable to allocate storage
