'\" t
.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbSetDeviceButtonActions __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbSetDeviceButtonActions \- Change only the button actions for an input extension device
.SH SYNOPSIS
.HP
.B Bool XkbSetDeviceButtonActions
.BI "(\^Display *" "dpy" "\^,"
.BI "XkbDeviceInfoPtr " "device" "\^,"
.BI "unsigned int " "first_button" "\^,"
.BI "unsigned int " "num_buttons" "\^);"
.SH ARGUMENTS
.TP
.I dpy
connection to X server
.TP
.I device
structure defining the device and modifications
.TP
.I first_button
number of first button to update, 0 relative
.TP
.I num_buttons
number of buttons to update
.SH DESCRIPTION
.LP
.I XkbSetDeviceButtonActions
assigns actions to the buttons of the device specified in
.I device_info->device_spec.
Actions are assigned to
.I num_buttons
buttons beginning with
.I first_button
and are taken from the actions specified in
.I device_info->btn_acts.

If the server does not support assignment of Xkb actions to extension device buttons,
.I XkbSetDeviceButtonActions
has no effect and returns False. If the device has no buttons or if
.I first_button
or
.I num_buttons
specify buttons outside of the valid range as determined by
.I device_info->num_btns,
the function has no effect and returns False. Otherwise,
.I XkbSetDeviceButtonActions
sends a request to the server to change the actions for the specified buttons and returns
True.

If the actual request sent to the server involved illegal button numbers, a BadValue protocol
error is generated. If an invalid device identifier is specified in
.I device_info->device_spec,
a BadKeyboard protocol error results. If the actual device specified in
.I device_info->device_spec
does not contain buttons and a request affecting buttons is made, a BadMatch protocol error is
generated.
.SH DIAGNOSTICS
.TP 15
.B BadKeyboard
The device specified was not a valid core or input extension device
.TP 15
.B BadMatch
A compatible version of Xkb was not available in the server or an argument has correct type
and range, but is otherwise invalid
.TP 15
.B BadValue
An argument is out of range
