// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test_request_id.proto

#ifndef GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_REQUEST_ID_CLIENT_H
#define GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_REQUEST_ID_CLIENT_H

#include "generator/integration_tests/golden/v1/request_id_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace golden_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Test generation of request ids.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class RequestIdServiceClient {
 public:
  explicit RequestIdServiceClient(std::shared_ptr<RequestIdServiceConnection> connection, Options opts = {});
  ~RequestIdServiceClient();

  ///@{
  /// @name Copy and move support
  RequestIdServiceClient(RequestIdServiceClient const&) = default;
  RequestIdServiceClient& operator=(RequestIdServiceClient const&) = default;
  RequestIdServiceClient(RequestIdServiceClient&&) = default;
  RequestIdServiceClient& operator=(RequestIdServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(RequestIdServiceClient const& a, RequestIdServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(RequestIdServiceClient const& a, RequestIdServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a `Foo` resource.
  ///
  /// @param parent  Required. Name of the `parent` in which the `foo` will reside.
  /// @param foo_id  Required. The id of the `Foo`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.test.requestid.v1.Foo])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.test.requestid.v1.CreateFooRequest]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L79}
  /// [google.test.requestid.v1.Foo]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L65}
  ///
  // clang-format on
  StatusOr<google::test::requestid::v1::Foo>
  CreateFoo(std::string const& parent, std::string const& foo_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a `Foo` resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.test.requestid.v1.CreateFooRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.test.requestid.v1.Foo])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.test.requestid.v1.CreateFooRequest]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L79}
  /// [google.test.requestid.v1.Foo]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L65}
  ///
  // clang-format on
  StatusOr<google::test::requestid::v1::Foo>
  CreateFoo(google::test::requestid::v1::CreateFooRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Renames a `Foo`.
  ///
  /// @param name  Required. Name of the source foo being renamed.
  ///  Format: `projects/{project}/parents/{parent}/foos/{foo}`
  /// @param destination_foo_id  Required. The destination foo ID, e.g. `foo/bar/`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.test.requestid.v1.Foo] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.test.requestid.v1.Foo]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L65}
  /// [google.test.requestid.v1.RenameFooRequest]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L99}
  ///
  // clang-format on
  future<StatusOr<google::test::requestid::v1::Foo>>
  RenameFoo(std::string const& name, std::string const& destination_foo_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief RenameFoo
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation>
  RenameFoo(NoAwaitTag, std::string const& name, std::string const& destination_foo_id, Options opts = {});

  // clang-format off
  ///
  /// Renames a `Foo`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.test.requestid.v1.RenameFooRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.test.requestid.v1.Foo] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.test.requestid.v1.Foo]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L65}
  /// [google.test.requestid.v1.RenameFooRequest]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L99}
  ///
  // clang-format on
  future<StatusOr<google::test::requestid::v1::Foo>>
  RenameFoo(google::test::requestid::v1::RenameFooRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// @copybrief RenameFoo
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation>
  RenameFoo(NoAwaitTag, google::test::requestid::v1::RenameFooRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// @copybrief RenameFoo
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::test::requestid::v1::Foo>>
  RenameFoo(google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a list of foos for a given parent.
  ///
  /// @param parent  Required. Name of the parent in which to look for foos.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.test.requestid.v1.Foo], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.test.requestid.v1.Foo]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L65}
  /// [google.test.requestid.v1.ListFoosRequest]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L134}
  ///
  // clang-format on
  StreamRange<google::test::requestid::v1::Foo>
  ListFoos(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a list of foos for a given parent.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.test.requestid.v1.ListFoosRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.test.requestid.v1.Foo], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.test.requestid.v1.Foo]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L65}
  /// [google.test.requestid.v1.ListFoosRequest]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L134}
  ///
  // clang-format on
  StreamRange<google::test::requestid::v1::Foo>
  ListFoos(google::test::requestid::v1::ListFoosRequest request, Options opts = {});

  // clang-format off
  ///
  /// Creates a `Foo` resource.
  ///
  /// @param parent  Required. Name of the `parent` in which the `foo` will reside.
  /// @param foo_id  Required. The id of the `Foo`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.test.requestid.v1.Foo])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.test.requestid.v1.CreateFooRequest]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L79}
  /// [google.test.requestid.v1.Foo]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L65}
  ///
  // clang-format on
  future<StatusOr<google::test::requestid::v1::Foo>>
  AsyncCreateFoo(std::string const& parent, std::string const& foo_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a `Foo` resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.test.requestid.v1.CreateFooRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.test.requestid.v1.Foo])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.test.requestid.v1.CreateFooRequest]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L79}
  /// [google.test.requestid.v1.Foo]: @googleapis_reference_link{generator/integration_tests/test_request_id.proto#L65}
  ///
  // clang-format on
  future<StatusOr<google::test::requestid::v1::Foo>>
  AsyncCreateFoo(google::test::requestid::v1::CreateFooRequest const& request, Options opts = {});

 private:
  std::shared_ptr<RequestIdServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_REQUEST_ID_CLIENT_H
