// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "generator/internal/sources_generator.h"
#include <algorithm>

namespace google {
namespace cloud {
namespace generator_internal {
namespace {

// This generator was added in 2024. We do not want to create new files with a
// copyright date in the past.
VarsDictionary ModifyCopyrightYear(VarsDictionary service_vars) {
  // This string comparison will be incorrect in 8000 years. I don't care.
  service_vars["copyright_year"] =
      std::max<std::string>("2024", service_vars["copyright_year"]);
  return service_vars;
}

}  // namespace

SourcesGenerator::SourcesGenerator(
    google::protobuf::ServiceDescriptor const* service_descriptor,
    VarsDictionary service_vars,
    std::map<std::string, VarsDictionary> service_method_vars,
    google::protobuf::compiler::GeneratorContext* context,
    std::vector<std::string> sources,
    std::vector<MixinMethod> const& mixin_methods)
    : ServiceCodeGenerator("sources_cc_path", service_descriptor,
                           ModifyCopyrightYear(std::move(service_vars)),
                           std::move(service_method_vars), context,
                           mixin_methods),
      sources_(std::move(sources)) {}

Status SourcesGenerator::GenerateHeader() {
  HeaderPrint(CopyrightLicenseFileHeader());
  HeaderPrint(R"""(
// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: $proto_file_name$

)""");
  HeaderPrint(R"""(// NOLINTBEGIN(bugprone-suspicious-include)
  )""");
  HeaderLocalIncludes(sources_);
  HeaderPrint(R"""(// NOLINTEND(bugprone-suspicious-include)
  )""");
  return Status();
}

}  // namespace generator_internal
}  // namespace cloud
}  // namespace google
