// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/feature_registry_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURE_REGISTRY_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURE_REGISTRY_CONNECTION_IMPL_H

#include "google/cloud/aiplatform/v1/feature_registry_connection.h"
#include "google/cloud/aiplatform/v1/feature_registry_connection_idempotency_policy.h"
#include "google/cloud/aiplatform/v1/feature_registry_options.h"
#include "google/cloud/aiplatform/v1/internal/feature_registry_retry_traits.h"
#include "google/cloud/aiplatform/v1/internal/feature_registry_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class FeatureRegistryServiceConnectionImpl
    : public aiplatform_v1::FeatureRegistryServiceConnection {
 public:
  ~FeatureRegistryServiceConnectionImpl() override = default;

  FeatureRegistryServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<aiplatform_v1_internal::FeatureRegistryServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
  CreateFeatureGroup(
      google::cloud::aiplatform::v1::CreateFeatureGroupRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateFeatureGroup(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateFeatureGroupRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
  CreateFeatureGroup(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::FeatureGroup> GetFeatureGroup(
      google::cloud::aiplatform::v1::GetFeatureGroupRequest const& request)
      override;

  StreamRange<google::cloud::aiplatform::v1::FeatureGroup> ListFeatureGroups(
      google::cloud::aiplatform::v1::ListFeatureGroupsRequest request) override;

  future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
  UpdateFeatureGroup(
      google::cloud::aiplatform::v1::UpdateFeatureGroupRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateFeatureGroup(
      NoAwaitTag,
      google::cloud::aiplatform::v1::UpdateFeatureGroupRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
  UpdateFeatureGroup(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeatureGroup(
      google::cloud::aiplatform::v1::DeleteFeatureGroupRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteFeatureGroup(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteFeatureGroupRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeatureGroup(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::Feature>> CreateFeature(
      google::cloud::aiplatform::v1::CreateFeatureRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateFeature(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateFeatureRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::Feature>> CreateFeature(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::Feature> GetFeature(
      google::cloud::aiplatform::v1::GetFeatureRequest const& request) override;

  StreamRange<google::cloud::aiplatform::v1::Feature> ListFeatures(
      google::cloud::aiplatform::v1::ListFeaturesRequest request) override;

  future<StatusOr<google::cloud::aiplatform::v1::Feature>> UpdateFeature(
      google::cloud::aiplatform::v1::UpdateFeatureRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateFeature(
      NoAwaitTag,
      google::cloud::aiplatform::v1::UpdateFeatureRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::Feature>> UpdateFeature(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeature(google::cloud::aiplatform::v1::DeleteFeatureRequest const&
                    request) override;

  StatusOr<google::longrunning::Operation> DeleteFeature(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteFeatureRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeature(google::longrunning::Operation const& operation) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<aiplatform_v1_internal::FeatureRegistryServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURE_REGISTRY_CONNECTION_IMPL_H
