// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/tensorboard_service.proto

#include "google/cloud/aiplatform/v1/internal/tensorboard_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/aiplatform/v1/tensorboard_service.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TensorboardServiceMetadata::TensorboardServiceMetadata(
    std::shared_ptr<TensorboardServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

future<StatusOr<google::longrunning::Operation>>
TensorboardServiceMetadata::AsyncCreateTensorboard(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::CreateTensorboardRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateTensorboard(cq, std::move(context),
                                        std::move(options), request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceMetadata::CreateTensorboard(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::CreateTensorboardRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateTensorboard(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::Tensorboard>
TensorboardServiceMetadata::GetTensorboard(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::GetTensorboardRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetTensorboard(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
TensorboardServiceMetadata::AsyncUpdateTensorboard(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::UpdateTensorboardRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("tensorboard.name=",
                           internal::UrlEncode(request.tensorboard().name())));
  return child_->AsyncUpdateTensorboard(cq, std::move(context),
                                        std::move(options), request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceMetadata::UpdateTensorboard(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::UpdateTensorboardRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("tensorboard.name=",
                           internal::UrlEncode(request.tensorboard().name())));
  return child_->UpdateTensorboard(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::ListTensorboardsResponse>
TensorboardServiceMetadata::ListTensorboards(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ListTensorboardsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListTensorboards(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
TensorboardServiceMetadata::AsyncDeleteTensorboard(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::DeleteTensorboardRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteTensorboard(cq, std::move(context),
                                        std::move(options), request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceMetadata::DeleteTensorboard(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::DeleteTensorboardRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteTensorboard(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::ReadTensorboardUsageResponse>
TensorboardServiceMetadata::ReadTensorboardUsage(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ReadTensorboardUsageRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("tensorboard=", internal::UrlEncode(request.tensorboard())));
  return child_->ReadTensorboardUsage(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::ReadTensorboardSizeResponse>
TensorboardServiceMetadata::ReadTensorboardSize(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ReadTensorboardSizeRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("tensorboard=", internal::UrlEncode(request.tensorboard())));
  return child_->ReadTensorboardSize(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
TensorboardServiceMetadata::CreateTensorboardExperiment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::CreateTensorboardExperimentRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateTensorboardExperiment(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
TensorboardServiceMetadata::GetTensorboardExperiment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::GetTensorboardExperimentRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetTensorboardExperiment(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
TensorboardServiceMetadata::UpdateTensorboardExperiment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::UpdateTensorboardExperimentRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("tensorboard_experiment.name=",
                           internal::UrlEncode(
                               request.tensorboard_experiment().name())));
  return child_->UpdateTensorboardExperiment(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::ListTensorboardExperimentsResponse>
TensorboardServiceMetadata::ListTensorboardExperiments(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ListTensorboardExperimentsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListTensorboardExperiments(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
TensorboardServiceMetadata::AsyncDeleteTensorboardExperiment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::DeleteTensorboardExperimentRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteTensorboardExperiment(cq, std::move(context),
                                                  std::move(options), request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceMetadata::DeleteTensorboardExperiment(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::DeleteTensorboardExperimentRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteTensorboardExperiment(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardRun>
TensorboardServiceMetadata::CreateTensorboardRun(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::CreateTensorboardRunRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateTensorboardRun(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::BatchCreateTensorboardRunsResponse>
TensorboardServiceMetadata::BatchCreateTensorboardRuns(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::BatchCreateTensorboardRunsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->BatchCreateTensorboardRuns(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardRun>
TensorboardServiceMetadata::GetTensorboardRun(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::GetTensorboardRunRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetTensorboardRun(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardRun>
TensorboardServiceMetadata::UpdateTensorboardRun(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::UpdateTensorboardRunRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("tensorboard_run.name=",
                   internal::UrlEncode(request.tensorboard_run().name())));
  return child_->UpdateTensorboardRun(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::ListTensorboardRunsResponse>
TensorboardServiceMetadata::ListTensorboardRuns(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ListTensorboardRunsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListTensorboardRuns(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
TensorboardServiceMetadata::AsyncDeleteTensorboardRun(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::DeleteTensorboardRunRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteTensorboardRun(cq, std::move(context),
                                           std::move(options), request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceMetadata::DeleteTensorboardRun(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::DeleteTensorboardRunRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteTensorboardRun(context, options, request);
}

StatusOr<
    google::cloud::aiplatform::v1::BatchCreateTensorboardTimeSeriesResponse>
TensorboardServiceMetadata::BatchCreateTensorboardTimeSeries(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::
        BatchCreateTensorboardTimeSeriesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->BatchCreateTensorboardTimeSeries(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
TensorboardServiceMetadata::CreateTensorboardTimeSeries(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::CreateTensorboardTimeSeriesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateTensorboardTimeSeries(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
TensorboardServiceMetadata::GetTensorboardTimeSeries(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::GetTensorboardTimeSeriesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetTensorboardTimeSeries(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
TensorboardServiceMetadata::UpdateTensorboardTimeSeries(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::UpdateTensorboardTimeSeriesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("tensorboard_time_series.name=",
                           internal::UrlEncode(
                               request.tensorboard_time_series().name())));
  return child_->UpdateTensorboardTimeSeries(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::ListTensorboardTimeSeriesResponse>
TensorboardServiceMetadata::ListTensorboardTimeSeries(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ListTensorboardTimeSeriesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListTensorboardTimeSeries(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
TensorboardServiceMetadata::AsyncDeleteTensorboardTimeSeries(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::DeleteTensorboardTimeSeriesRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteTensorboardTimeSeries(cq, std::move(context),
                                                  std::move(options), request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceMetadata::DeleteTensorboardTimeSeries(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::DeleteTensorboardTimeSeriesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteTensorboardTimeSeries(context, options, request);
}

StatusOr<
    google::cloud::aiplatform::v1::BatchReadTensorboardTimeSeriesDataResponse>
TensorboardServiceMetadata::BatchReadTensorboardTimeSeriesData(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::
        BatchReadTensorboardTimeSeriesDataRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("tensorboard=", internal::UrlEncode(request.tensorboard())));
  return child_->BatchReadTensorboardTimeSeriesData(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataResponse>
TensorboardServiceMetadata::ReadTensorboardTimeSeriesData(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataRequest const&
        request) {
  SetMetadata(
      context, options,
      absl::StrCat("tensorboard_time_series=",
                   internal::UrlEncode(request.tensorboard_time_series())));
  return child_->ReadTensorboardTimeSeriesData(context, options, request);
}

std::unique_ptr<google::cloud::internal::StreamingReadRpc<
    google::cloud::aiplatform::v1::ReadTensorboardBlobDataResponse>>
TensorboardServiceMetadata::ReadTensorboardBlobData(
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::aiplatform::v1::ReadTensorboardBlobDataRequest const&
        request) {
  SetMetadata(
      *context, options,
      absl::StrCat("time_series=", internal::UrlEncode(request.time_series())));
  return child_->ReadTensorboardBlobData(std::move(context), options, request);
}

StatusOr<google::cloud::aiplatform::v1::WriteTensorboardExperimentDataResponse>
TensorboardServiceMetadata::WriteTensorboardExperimentData(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::WriteTensorboardExperimentDataRequest const&
        request) {
  SetMetadata(
      context, options,
      absl::StrCat("tensorboard_experiment=",
                   internal::UrlEncode(request.tensorboard_experiment())));
  return child_->WriteTensorboardExperimentData(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::WriteTensorboardRunDataResponse>
TensorboardServiceMetadata::WriteTensorboardRunData(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::WriteTensorboardRunDataRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("tensorboard_run=",
                           internal::UrlEncode(request.tensorboard_run())));
  return child_->WriteTensorboardRunData(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::ExportTensorboardTimeSeriesDataResponse>
TensorboardServiceMetadata::ExportTensorboardTimeSeriesData(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ExportTensorboardTimeSeriesDataRequest const&
        request) {
  SetMetadata(
      context, options,
      absl::StrCat("tensorboard_time_series=",
                   internal::UrlEncode(request.tensorboard_time_series())));
  return child_->ExportTensorboardTimeSeriesData(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
TensorboardServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> TensorboardServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void TensorboardServiceMetadata::SetMetadata(
    grpc::ClientContext& context, Options const& options,
    std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void TensorboardServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                             Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
