// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/asset/v1/asset_service.proto

#include "google/cloud/asset/v1/internal/asset_connection_impl.h"
#include "google/cloud/asset/v1/internal/asset_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace asset_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<asset_v1::AssetServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<asset_v1::AssetServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<asset_v1::AssetServiceBackoffPolicyOption>()->clone();
}

std::unique_ptr<asset_v1::AssetServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options.get<asset_v1::AssetServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<asset_v1::AssetServicePollingPolicyOption>()->clone();
}

}  // namespace

AssetServiceConnectionImpl::AssetServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<asset_v1_internal::AssetServiceStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      AssetServiceConnection::options())) {}

future<StatusOr<google::cloud::asset::v1::ExportAssetsResponse>>
AssetServiceConnectionImpl::ExportAssets(
    google::cloud::asset::v1::ExportAssetsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->ExportAssets(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::asset::v1::ExportAssetsResponse>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::asset::v1::ExportAssetsRequest const& request) {
        return stub->AsyncExportAssets(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::asset::v1::ExportAssetsResponse>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
AssetServiceConnectionImpl::ExportAssets(
    NoAwaitTag, google::cloud::asset::v1::ExportAssetsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ExportAssets(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::asset::v1::ExportAssetsRequest const& request) {
        return stub_->ExportAssets(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::asset::v1::ExportAssetsResponse>>
AssetServiceConnectionImpl::ExportAssets(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::asset::v1::ExportAssetsRequest>()) {
    return make_ready_future<
        StatusOr<google::cloud::asset::v1::ExportAssetsResponse>>(
        internal::InvalidArgumentError(
            "operation does not correspond to ExportAssets",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::asset::v1::ExportAssetsResponse>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::asset::v1::ExportAssetsResponse>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::asset::v1::Asset>
AssetServiceConnectionImpl::ListAssets(
    google::cloud::asset::v1::ListAssetsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListAssets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::asset::v1::Asset>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<asset_v1::AssetServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::asset::v1::ListAssetsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::asset::v1::ListAssetsRequest const& request) {
              return stub->ListAssets(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::asset::v1::ListAssetsResponse r) {
        std::vector<google::cloud::asset::v1::Asset> result(r.assets().size());
        auto& messages = *r.mutable_assets();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::asset::v1::BatchGetAssetsHistoryResponse>
AssetServiceConnectionImpl::BatchGetAssetsHistory(
    google::cloud::asset::v1::BatchGetAssetsHistoryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BatchGetAssetsHistory(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::asset::v1::BatchGetAssetsHistoryRequest const&
                 request) {
        return stub_->BatchGetAssetsHistory(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::asset::v1::Feed> AssetServiceConnectionImpl::CreateFeed(
    google::cloud::asset::v1::CreateFeedRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateFeed(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::asset::v1::CreateFeedRequest const& request) {
        return stub_->CreateFeed(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::asset::v1::Feed> AssetServiceConnectionImpl::GetFeed(
    google::cloud::asset::v1::GetFeedRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetFeed(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::asset::v1::GetFeedRequest const& request) {
        return stub_->GetFeed(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::asset::v1::ListFeedsResponse>
AssetServiceConnectionImpl::ListFeeds(
    google::cloud::asset::v1::ListFeedsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ListFeeds(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::asset::v1::ListFeedsRequest const& request) {
        return stub_->ListFeeds(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::asset::v1::Feed> AssetServiceConnectionImpl::UpdateFeed(
    google::cloud::asset::v1::UpdateFeedRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateFeed(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::asset::v1::UpdateFeedRequest const& request) {
        return stub_->UpdateFeed(context, options, request);
      },
      *current, request, __func__);
}

Status AssetServiceConnectionImpl::DeleteFeed(
    google::cloud::asset::v1::DeleteFeedRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteFeed(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::asset::v1::DeleteFeedRequest const& request) {
        return stub_->DeleteFeed(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::asset::v1::ResourceSearchResult>
AssetServiceConnectionImpl::SearchAllResources(
    google::cloud::asset::v1::SearchAllResourcesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->SearchAllResources(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::asset::v1::ResourceSearchResult>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<asset_v1::AssetServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::asset::v1::SearchAllResourcesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::asset::v1::SearchAllResourcesRequest const&
                       request) {
              return stub->SearchAllResources(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::asset::v1::SearchAllResourcesResponse r) {
        std::vector<google::cloud::asset::v1::ResourceSearchResult> result(
            r.results().size());
        auto& messages = *r.mutable_results();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::asset::v1::IamPolicySearchResult>
AssetServiceConnectionImpl::SearchAllIamPolicies(
    google::cloud::asset::v1::SearchAllIamPoliciesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->SearchAllIamPolicies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::asset::v1::IamPolicySearchResult>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<asset_v1::AssetServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::asset::v1::SearchAllIamPoliciesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::asset::v1::SearchAllIamPoliciesRequest const&
                       request) {
              return stub->SearchAllIamPolicies(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::asset::v1::SearchAllIamPoliciesResponse r) {
        std::vector<google::cloud::asset::v1::IamPolicySearchResult> result(
            r.results().size());
        auto& messages = *r.mutable_results();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::asset::v1::AnalyzeIamPolicyResponse>
AssetServiceConnectionImpl::AnalyzeIamPolicy(
    google::cloud::asset::v1::AnalyzeIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->AnalyzeIamPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::asset::v1::AnalyzeIamPolicyRequest const& request) {
        return stub_->AnalyzeIamPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::asset::v1::AnalyzeIamPolicyLongrunningResponse>>
AssetServiceConnectionImpl::AnalyzeIamPolicyLongrunning(
    google::cloud::asset::v1::AnalyzeIamPolicyLongrunningRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->AnalyzeIamPolicyLongrunning(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::asset::v1::AnalyzeIamPolicyLongrunningResponse>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::asset::v1::AnalyzeIamPolicyLongrunningRequest const&
              request) {
        return stub->AsyncAnalyzeIamPolicyLongrunning(
            cq, std::move(context), std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::asset::v1::AnalyzeIamPolicyLongrunningResponse>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
AssetServiceConnectionImpl::AnalyzeIamPolicyLongrunning(
    NoAwaitTag,
    google::cloud::asset::v1::AnalyzeIamPolicyLongrunningRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->AnalyzeIamPolicyLongrunning(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::asset::v1::AnalyzeIamPolicyLongrunningRequest const&
                 request) {
        return stub_->AnalyzeIamPolicyLongrunning(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::asset::v1::AnalyzeIamPolicyLongrunningResponse>>
AssetServiceConnectionImpl::AnalyzeIamPolicyLongrunning(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::asset::v1::
                   AnalyzeIamPolicyLongrunningMetadata>()) {
    return make_ready_future<StatusOr<
        google::cloud::asset::v1::AnalyzeIamPolicyLongrunningResponse>>(
        internal::InvalidArgumentError(
            "operation does not correspond to AnalyzeIamPolicyLongrunning",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::asset::v1::AnalyzeIamPolicyLongrunningResponse>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::asset::v1::AnalyzeIamPolicyLongrunningResponse>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::asset::v1::AnalyzeMoveResponse>
AssetServiceConnectionImpl::AnalyzeMove(
    google::cloud::asset::v1::AnalyzeMoveRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->AnalyzeMove(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::asset::v1::AnalyzeMoveRequest const& request) {
        return stub_->AnalyzeMove(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::asset::v1::QueryAssetsResponse>
AssetServiceConnectionImpl::QueryAssets(
    google::cloud::asset::v1::QueryAssetsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->QueryAssets(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::asset::v1::QueryAssetsRequest const& request) {
        return stub_->QueryAssets(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::asset::v1::SavedQuery>
AssetServiceConnectionImpl::CreateSavedQuery(
    google::cloud::asset::v1::CreateSavedQueryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateSavedQuery(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::asset::v1::CreateSavedQueryRequest const& request) {
        return stub_->CreateSavedQuery(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::asset::v1::SavedQuery>
AssetServiceConnectionImpl::GetSavedQuery(
    google::cloud::asset::v1::GetSavedQueryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSavedQuery(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::asset::v1::GetSavedQueryRequest const& request) {
        return stub_->GetSavedQuery(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::asset::v1::SavedQuery>
AssetServiceConnectionImpl::ListSavedQueries(
    google::cloud::asset::v1::ListSavedQueriesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListSavedQueries(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::asset::v1::SavedQuery>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<asset_v1::AssetServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::asset::v1::ListSavedQueriesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::asset::v1::ListSavedQueriesRequest const&
                       request) {
              return stub->ListSavedQueries(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::asset::v1::ListSavedQueriesResponse r) {
        std::vector<google::cloud::asset::v1::SavedQuery> result(
            r.saved_queries().size());
        auto& messages = *r.mutable_saved_queries();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::asset::v1::SavedQuery>
AssetServiceConnectionImpl::UpdateSavedQuery(
    google::cloud::asset::v1::UpdateSavedQueryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateSavedQuery(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::asset::v1::UpdateSavedQueryRequest const& request) {
        return stub_->UpdateSavedQuery(context, options, request);
      },
      *current, request, __func__);
}

Status AssetServiceConnectionImpl::DeleteSavedQuery(
    google::cloud::asset::v1::DeleteSavedQueryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteSavedQuery(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::asset::v1::DeleteSavedQueryRequest const& request) {
        return stub_->DeleteSavedQuery(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::asset::v1::BatchGetEffectiveIamPoliciesResponse>
AssetServiceConnectionImpl::BatchGetEffectiveIamPolicies(
    google::cloud::asset::v1::BatchGetEffectiveIamPoliciesRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BatchGetEffectiveIamPolicies(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::asset::v1::BatchGetEffectiveIamPoliciesRequest const&
              request) {
        return stub_->BatchGetEffectiveIamPolicies(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<
    google::cloud::asset::v1::AnalyzeOrgPoliciesResponse::OrgPolicyResult>
AssetServiceConnectionImpl::AnalyzeOrgPolicies(
    google::cloud::asset::v1::AnalyzeOrgPoliciesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->AnalyzeOrgPolicies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::cloud::asset::v1::AnalyzeOrgPoliciesResponse::OrgPolicyResult>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<asset_v1::AssetServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::asset::v1::AnalyzeOrgPoliciesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::asset::v1::AnalyzeOrgPoliciesRequest const&
                       request) {
              return stub->AnalyzeOrgPolicies(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::asset::v1::AnalyzeOrgPoliciesResponse r) {
        std::vector<google::cloud::asset::v1::AnalyzeOrgPoliciesResponse::
                        OrgPolicyResult>
            result(r.org_policy_results().size());
        auto& messages = *r.mutable_org_policy_results();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::asset::v1::
                AnalyzeOrgPolicyGovernedContainersResponse::GovernedContainer>
AssetServiceConnectionImpl::AnalyzeOrgPolicyGovernedContainers(
    google::cloud::asset::v1::AnalyzeOrgPolicyGovernedContainersRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->AnalyzeOrgPolicyGovernedContainers(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::cloud::asset::v1::AnalyzeOrgPolicyGovernedContainersResponse::
          GovernedContainer>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<asset_v1::AssetServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::asset::v1::
              AnalyzeOrgPolicyGovernedContainersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::asset::v1::
                    AnalyzeOrgPolicyGovernedContainersRequest const& request) {
              return stub->AnalyzeOrgPolicyGovernedContainers(context, options,
                                                              request);
            },
            options, r, function_name);
      },
      [](google::cloud::asset::v1::AnalyzeOrgPolicyGovernedContainersResponse
             r) {
        std::vector<
            google::cloud::asset::v1::
                AnalyzeOrgPolicyGovernedContainersResponse::GovernedContainer>
            result(r.governed_containers().size());
        auto& messages = *r.mutable_governed_containers();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::asset::v1::AnalyzeOrgPolicyGovernedAssetsResponse::
                GovernedAsset>
AssetServiceConnectionImpl::AnalyzeOrgPolicyGovernedAssets(
    google::cloud::asset::v1::AnalyzeOrgPolicyGovernedAssetsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->AnalyzeOrgPolicyGovernedAssets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::asset::v1::
                      AnalyzeOrgPolicyGovernedAssetsResponse::GovernedAsset>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<asset_v1::AssetServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::asset::v1::AnalyzeOrgPolicyGovernedAssetsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::asset::v1::
                       AnalyzeOrgPolicyGovernedAssetsRequest const& request) {
              return stub->AnalyzeOrgPolicyGovernedAssets(context, options,
                                                          request);
            },
            options, r, function_name);
      },
      [](google::cloud::asset::v1::AnalyzeOrgPolicyGovernedAssetsResponse r) {
        std::vector<google::cloud::asset::v1::
                        AnalyzeOrgPolicyGovernedAssetsResponse::GovernedAsset>
            result(r.governed_assets().size());
        auto& messages = *r.mutable_governed_assets();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace asset_v1_internal
}  // namespace cloud
}  // namespace google
