// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/backupdr/v1/backupdr.proto

#include "google/cloud/backupdr/v1/internal/backup_dr_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace backupdr_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

BackupDRTracingStub::BackupDRTracingStub(std::shared_ptr<BackupDRStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::backupdr::v1::ListManagementServersResponse>
BackupDRTracingStub::ListManagementServers(
    grpc::ClientContext& context, Options const& options,
    google::cloud::backupdr::v1::ListManagementServersRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.backupdr.v1.BackupDR",
                                     "ListManagementServers");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListManagementServers(context, options, request));
}

StatusOr<google::cloud::backupdr::v1::ManagementServer>
BackupDRTracingStub::GetManagementServer(
    grpc::ClientContext& context, Options const& options,
    google::cloud::backupdr::v1::GetManagementServerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.backupdr.v1.BackupDR",
                                     "GetManagementServer");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetManagementServer(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
BackupDRTracingStub::AsyncCreateManagementServer(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::CreateManagementServerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.backupdr.v1.BackupDR",
                                     "CreateManagementServer");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateManagementServer(cq, context, std::move(options),
                                               request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
BackupDRTracingStub::CreateManagementServer(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::CreateManagementServerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.backupdr.v1.BackupDR",
                                     "CreateManagementServer");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->CreateManagementServer(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
BackupDRTracingStub::AsyncDeleteManagementServer(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::DeleteManagementServerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.backupdr.v1.BackupDR",
                                     "DeleteManagementServer");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteManagementServer(cq, context, std::move(options),
                                               request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
BackupDRTracingStub::DeleteManagementServer(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::DeleteManagementServerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.backupdr.v1.BackupDR",
                                     "DeleteManagementServer");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->DeleteManagementServer(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
BackupDRTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> BackupDRTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<BackupDRStub> MakeBackupDRTracingStub(
    std::shared_ptr<BackupDRStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<BackupDRTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace backupdr_v1_internal
}  // namespace cloud
}  // namespace google
