// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/dataset.proto

#include "google/cloud/bigquerycontrol/v2/internal/dataset_rest_metadata_decorator.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/rest_set_metadata.h"
#include "google/cloud/status_or.h"
#include "absl/strings/str_format.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DatasetServiceRestMetadata::DatasetServiceRestMetadata(
    std::shared_ptr<DatasetServiceRestStub> child,
    std::string api_client_header)
    : child_(std::move(child)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::bigquery::v2::Dataset>
DatasetServiceRestMetadata::GetDataset(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::bigquery::v2::GetDatasetRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetDataset(rest_context, options, request);
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DatasetServiceRestMetadata::InsertDataset(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::bigquery::v2::InsertDatasetRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->InsertDataset(rest_context, options, request);
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DatasetServiceRestMetadata::PatchDataset(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::bigquery::v2::UpdateOrPatchDatasetRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->PatchDataset(rest_context, options, request);
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DatasetServiceRestMetadata::UpdateDataset(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::bigquery::v2::UpdateOrPatchDatasetRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->UpdateDataset(rest_context, options, request);
}

Status DatasetServiceRestMetadata::DeleteDataset(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::bigquery::v2::DeleteDatasetRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->DeleteDataset(rest_context, options, request);
}

StatusOr<google::cloud::bigquery::v2::DatasetList>
DatasetServiceRestMetadata::ListDatasets(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::bigquery::v2::ListDatasetsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListDatasets(rest_context, options, request);
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DatasetServiceRestMetadata::UndeleteDataset(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::bigquery::v2::UndeleteDatasetRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->UndeleteDataset(rest_context, options, request);
}

void DatasetServiceRestMetadata::SetMetadata(
    rest_internal::RestContext& rest_context, Options const& options,
    std::vector<std::string> const& params) {
  google::cloud::rest_internal::SetMetadata(rest_context, options, params,
                                            api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2_internal
}  // namespace cloud
}  // namespace google
