// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/table.proto

#include "google/cloud/bigquerycontrol/v2/table_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

TableServiceConnectionIdempotencyPolicy::
    ~TableServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<TableServiceConnectionIdempotencyPolicy>
TableServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<TableServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency TableServiceConnectionIdempotencyPolicy::GetTable(
    google::cloud::bigquery::v2::GetTableRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TableServiceConnectionIdempotencyPolicy::InsertTable(
    google::cloud::bigquery::v2::InsertTableRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TableServiceConnectionIdempotencyPolicy::PatchTable(
    google::cloud::bigquery::v2::UpdateOrPatchTableRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TableServiceConnectionIdempotencyPolicy::UpdateTable(
    google::cloud::bigquery::v2::UpdateOrPatchTableRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TableServiceConnectionIdempotencyPolicy::DeleteTable(
    google::cloud::bigquery::v2::DeleteTableRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TableServiceConnectionIdempotencyPolicy::ListTables(
    google::cloud::bigquery::v2::ListTablesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<TableServiceConnectionIdempotencyPolicy>
MakeDefaultTableServiceConnectionIdempotencyPolicy() {
  return std::make_unique<TableServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2
}  // namespace cloud
}  // namespace google
