// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/bigtable/admin/v2/bigtable_instance_admin.proto

#include "google/cloud/bigtable/admin/bigtable_instance_admin_connection.h"
#include "google/cloud/bigtable/admin/bigtable_instance_admin_options.h"
#include "google/cloud/bigtable/admin/internal/bigtable_instance_admin_connection_impl.h"
#include "google/cloud/bigtable/admin/internal/bigtable_instance_admin_option_defaults.h"
#include "google/cloud/bigtable/admin/internal/bigtable_instance_admin_stub_factory.h"
#include "google/cloud/bigtable/admin/internal/bigtable_instance_admin_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigtable_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BigtableInstanceAdminConnection::~BigtableInstanceAdminConnection() = default;

future<StatusOr<google::bigtable::admin::v2::Instance>>
BigtableInstanceAdminConnection::CreateInstance(
    google::bigtable::admin::v2::CreateInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BigtableInstanceAdminConnection::CreateInstance(
    NoAwaitTag, google::bigtable::admin::v2::CreateInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::Instance>>
BigtableInstanceAdminConnection::CreateInstance(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::bigtable::admin::v2::Instance>
BigtableInstanceAdminConnection::GetInstance(
    google::bigtable::admin::v2::GetInstanceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::bigtable::admin::v2::ListInstancesResponse>
BigtableInstanceAdminConnection::ListInstances(
    google::bigtable::admin::v2::ListInstancesRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::bigtable::admin::v2::Instance>
BigtableInstanceAdminConnection::UpdateInstance(
    google::bigtable::admin::v2::Instance const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::bigtable::admin::v2::Instance>>
BigtableInstanceAdminConnection::PartialUpdateInstance(
    google::bigtable::admin::v2::PartialUpdateInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BigtableInstanceAdminConnection::PartialUpdateInstance(
    NoAwaitTag,
    google::bigtable::admin::v2::PartialUpdateInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::Instance>>
BigtableInstanceAdminConnection::PartialUpdateInstance(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

Status BigtableInstanceAdminConnection::DeleteInstance(
    google::bigtable::admin::v2::DeleteInstanceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::bigtable::admin::v2::Cluster>>
BigtableInstanceAdminConnection::CreateCluster(
    google::bigtable::admin::v2::CreateClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Cluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BigtableInstanceAdminConnection::CreateCluster(
    NoAwaitTag, google::bigtable::admin::v2::CreateClusterRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::Cluster>>
BigtableInstanceAdminConnection::CreateCluster(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Cluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::bigtable::admin::v2::Cluster>
BigtableInstanceAdminConnection::GetCluster(
    google::bigtable::admin::v2::GetClusterRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::bigtable::admin::v2::ListClustersResponse>
BigtableInstanceAdminConnection::ListClusters(
    google::bigtable::admin::v2::ListClustersRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::bigtable::admin::v2::Cluster>>
BigtableInstanceAdminConnection::UpdateCluster(
    google::bigtable::admin::v2::Cluster const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Cluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BigtableInstanceAdminConnection::UpdateCluster(
    NoAwaitTag, google::bigtable::admin::v2::Cluster const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::Cluster>>
BigtableInstanceAdminConnection::UpdateCluster(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Cluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::Cluster>>
BigtableInstanceAdminConnection::PartialUpdateCluster(
    google::bigtable::admin::v2::PartialUpdateClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Cluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BigtableInstanceAdminConnection::PartialUpdateCluster(
    NoAwaitTag,
    google::bigtable::admin::v2::PartialUpdateClusterRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::Cluster>>
BigtableInstanceAdminConnection::PartialUpdateCluster(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Cluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

Status BigtableInstanceAdminConnection::DeleteCluster(
    google::bigtable::admin::v2::DeleteClusterRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::bigtable::admin::v2::AppProfile>
BigtableInstanceAdminConnection::CreateAppProfile(
    google::bigtable::admin::v2::CreateAppProfileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::bigtable::admin::v2::AppProfile>
BigtableInstanceAdminConnection::GetAppProfile(
    google::bigtable::admin::v2::GetAppProfileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::bigtable::admin::v2::AppProfile>
BigtableInstanceAdminConnection::ListAppProfiles(
    google::bigtable::admin::v2::
        ListAppProfilesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::bigtable::admin::v2::AppProfile>>();
}

future<StatusOr<google::bigtable::admin::v2::AppProfile>>
BigtableInstanceAdminConnection::UpdateAppProfile(
    google::bigtable::admin::v2::UpdateAppProfileRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::AppProfile>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BigtableInstanceAdminConnection::UpdateAppProfile(
    NoAwaitTag, google::bigtable::admin::v2::UpdateAppProfileRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::AppProfile>>
BigtableInstanceAdminConnection::UpdateAppProfile(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::AppProfile>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

Status BigtableInstanceAdminConnection::DeleteAppProfile(
    google::bigtable::admin::v2::DeleteAppProfileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> BigtableInstanceAdminConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> BigtableInstanceAdminConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
BigtableInstanceAdminConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::bigtable::admin::v2::HotTablet>
BigtableInstanceAdminConnection::ListHotTablets(
    google::bigtable::admin::v2::
        ListHotTabletsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::bigtable::admin::v2::HotTablet>>();
}

std::shared_ptr<BigtableInstanceAdminConnection>
MakeBigtableInstanceAdminConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 BigtableInstanceAdminPolicyOptionList>(
      options, __func__);
  options = bigtable_admin_internal::BigtableInstanceAdminDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = bigtable_admin_internal::CreateDefaultBigtableInstanceAdminStub(
      std::move(auth), options);
  return bigtable_admin_internal::MakeBigtableInstanceAdminTracingConnection(
      std::make_shared<
          bigtable_admin_internal::BigtableInstanceAdminConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigtable_admin
}  // namespace cloud
}  // namespace google
