// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/core.proto

#include "google/cloud/cloudcontrolspartner/v1/internal/cloud_controls_partner_core_connection_impl.h"
#include "google/cloud/cloudcontrolspartner/v1/internal/cloud_controls_partner_core_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<cloudcontrolspartner_v1::CloudControlsPartnerCoreRetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<cloudcontrolspartner_v1::CloudControlsPartnerCoreRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<cloudcontrolspartner_v1::
               CloudControlsPartnerCoreBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<cloudcontrolspartner_v1::
                    CloudControlsPartnerCoreConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<cloudcontrolspartner_v1::
               CloudControlsPartnerCoreConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

CloudControlsPartnerCoreConnectionImpl::CloudControlsPartnerCoreConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<
        cloudcontrolspartner_v1_internal::CloudControlsPartnerCoreStub>
        stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), CloudControlsPartnerCoreConnection::options())) {}

StatusOr<google::cloud::cloudcontrolspartner::v1::Workload>
CloudControlsPartnerCoreConnectionImpl::GetWorkload(
    google::cloud::cloudcontrolspartner::v1::GetWorkloadRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetWorkload(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::cloudcontrolspartner::v1::GetWorkloadRequest const&
                 request) {
        return stub_->GetWorkload(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::cloudcontrolspartner::v1::Workload>
CloudControlsPartnerCoreConnectionImpl::ListWorkloads(
    google::cloud::cloudcontrolspartner::v1::ListWorkloadsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListWorkloads(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::cloudcontrolspartner::v1::Workload>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           cloudcontrolspartner_v1::CloudControlsPartnerCoreRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::cloudcontrolspartner::v1::ListWorkloadsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::cloudcontrolspartner::v1::
                       ListWorkloadsRequest const& request) {
              return stub->ListWorkloads(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::cloudcontrolspartner::v1::ListWorkloadsResponse r) {
        std::vector<google::cloud::cloudcontrolspartner::v1::Workload> result(
            r.workloads().size());
        auto& messages = *r.mutable_workloads();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::cloudcontrolspartner::v1::Customer>
CloudControlsPartnerCoreConnectionImpl::GetCustomer(
    google::cloud::cloudcontrolspartner::v1::GetCustomerRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCustomer(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::cloudcontrolspartner::v1::GetCustomerRequest const&
                 request) {
        return stub_->GetCustomer(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::cloudcontrolspartner::v1::Customer>
CloudControlsPartnerCoreConnectionImpl::ListCustomers(
    google::cloud::cloudcontrolspartner::v1::ListCustomersRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListCustomers(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::cloudcontrolspartner::v1::Customer>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           cloudcontrolspartner_v1::CloudControlsPartnerCoreRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::cloudcontrolspartner::v1::ListCustomersRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::cloudcontrolspartner::v1::
                       ListCustomersRequest const& request) {
              return stub->ListCustomers(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::cloudcontrolspartner::v1::ListCustomersResponse r) {
        std::vector<google::cloud::cloudcontrolspartner::v1::Customer> result(
            r.customers().size());
        auto& messages = *r.mutable_customers();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::cloudcontrolspartner::v1::EkmConnections>
CloudControlsPartnerCoreConnectionImpl::GetEkmConnections(
    google::cloud::cloudcontrolspartner::v1::GetEkmConnectionsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetEkmConnections(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::cloudcontrolspartner::v1::
                 GetEkmConnectionsRequest const& request) {
        return stub_->GetEkmConnections(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::cloudcontrolspartner::v1::PartnerPermissions>
CloudControlsPartnerCoreConnectionImpl::GetPartnerPermissions(
    google::cloud::cloudcontrolspartner::v1::GetPartnerPermissionsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetPartnerPermissions(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::cloudcontrolspartner::v1::
                 GetPartnerPermissionsRequest const& request) {
        return stub_->GetPartnerPermissions(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::cloudcontrolspartner::v1::AccessApprovalRequest>
CloudControlsPartnerCoreConnectionImpl::ListAccessApprovalRequests(
    google::cloud::cloudcontrolspartner::v1::ListAccessApprovalRequestsRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListAccessApprovalRequests(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::cloud::cloudcontrolspartner::v1::AccessApprovalRequest>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           cloudcontrolspartner_v1::CloudControlsPartnerCoreRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::cloudcontrolspartner::v1::
              ListAccessApprovalRequestsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::cloudcontrolspartner::v1::
                       ListAccessApprovalRequestsRequest const& request) {
              return stub->ListAccessApprovalRequests(context, options,
                                                      request);
            },
            options, r, function_name);
      },
      [](google::cloud::cloudcontrolspartner::v1::
             ListAccessApprovalRequestsResponse r) {
        std::vector<
            google::cloud::cloudcontrolspartner::v1::AccessApprovalRequest>
            result(r.access_approval_requests().size());
        auto& messages = *r.mutable_access_approval_requests();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::cloudcontrolspartner::v1::Partner>
CloudControlsPartnerCoreConnectionImpl::GetPartner(
    google::cloud::cloudcontrolspartner::v1::GetPartnerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetPartner(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::cloudcontrolspartner::v1::GetPartnerRequest const&
                 request) {
        return stub_->GetPartner(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1_internal
}  // namespace cloud
}  // namespace google
