// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/instant_snapshots/v1/instant_snapshots.proto

#include "google/cloud/compute/instant_snapshots/v1/internal/instant_snapshots_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_instant_snapshots_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

InstantSnapshotsTracingConnection::InstantSnapshotsTracingConnection(
    std::shared_ptr<compute_instant_snapshots_v1::InstantSnapshotsConnection>
        child)
    : child_(std::move(child)) {}

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::InstantSnapshotsScopedList>>
InstantSnapshotsTracingConnection::AggregatedListInstantSnapshots(
    google::cloud::cpp::compute::instant_snapshots::v1::
        AggregatedListInstantSnapshotsRequest request) {
  auto span = internal::MakeSpan(
      "compute_instant_snapshots_v1::InstantSnapshotsConnection::"
      "AggregatedListInstantSnapshots");
  internal::OTelScope scope(span);
  auto sr = child_->AggregatedListInstantSnapshots(std::move(request));
  return internal::MakeTracedStreamRange<
      std::pair<std::string,
                google::cloud::cpp::compute::v1::InstantSnapshotsScopedList>>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstantSnapshotsTracingConnection::DeleteInstantSnapshot(
    google::cloud::cpp::compute::instant_snapshots::v1::
        DeleteInstantSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instant_snapshots_v1::InstantSnapshotsConnection::"
      "DeleteInstantSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteInstantSnapshot(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstantSnapshotsTracingConnection::DeleteInstantSnapshot(
    NoAwaitTag, google::cloud::cpp::compute::instant_snapshots::v1::
                    DeleteInstantSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instant_snapshots_v1::InstantSnapshotsConnection::"
      "DeleteInstantSnapshot");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteInstantSnapshot(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstantSnapshotsTracingConnection::DeleteInstantSnapshot(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_instant_snapshots_v1::InstantSnapshotsConnection::"
      "DeleteInstantSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteInstantSnapshot(operation));
}

StatusOr<google::cloud::cpp::compute::v1::InstantSnapshot>
InstantSnapshotsTracingConnection::GetInstantSnapshot(
    google::cloud::cpp::compute::instant_snapshots::v1::
        GetInstantSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instant_snapshots_v1::InstantSnapshotsConnection::"
      "GetInstantSnapshot");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInstantSnapshot(request));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
InstantSnapshotsTracingConnection::GetIamPolicy(
    google::cloud::cpp::compute::instant_snapshots::v1::
        GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instant_snapshots_v1::InstantSnapshotsConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstantSnapshotsTracingConnection::InsertInstantSnapshot(
    google::cloud::cpp::compute::instant_snapshots::v1::
        InsertInstantSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instant_snapshots_v1::InstantSnapshotsConnection::"
      "InsertInstantSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertInstantSnapshot(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstantSnapshotsTracingConnection::InsertInstantSnapshot(
    NoAwaitTag, google::cloud::cpp::compute::instant_snapshots::v1::
                    InsertInstantSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instant_snapshots_v1::InstantSnapshotsConnection::"
      "InsertInstantSnapshot");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->InsertInstantSnapshot(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstantSnapshotsTracingConnection::InsertInstantSnapshot(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_instant_snapshots_v1::InstantSnapshotsConnection::"
      "InsertInstantSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertInstantSnapshot(operation));
}

StreamRange<google::cloud::cpp::compute::v1::InstantSnapshot>
InstantSnapshotsTracingConnection::ListInstantSnapshots(
    google::cloud::cpp::compute::instant_snapshots::v1::
        ListInstantSnapshotsRequest request) {
  auto span = internal::MakeSpan(
      "compute_instant_snapshots_v1::InstantSnapshotsConnection::"
      "ListInstantSnapshots");
  internal::OTelScope scope(span);
  auto sr = child_->ListInstantSnapshots(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::InstantSnapshot>(std::move(span),
                                                        std::move(sr));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
InstantSnapshotsTracingConnection::SetIamPolicy(
    google::cloud::cpp::compute::instant_snapshots::v1::
        SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instant_snapshots_v1::InstantSnapshotsConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstantSnapshotsTracingConnection::SetLabels(
    google::cloud::cpp::compute::instant_snapshots::v1::SetLabelsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_instant_snapshots_v1::InstantSnapshotsConnection::SetLabels");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetLabels(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstantSnapshotsTracingConnection::SetLabels(
    NoAwaitTag,
    google::cloud::cpp::compute::instant_snapshots::v1::SetLabelsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_instant_snapshots_v1::InstantSnapshotsConnection::SetLabels");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->SetLabels(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstantSnapshotsTracingConnection::SetLabels(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_instant_snapshots_v1::InstantSnapshotsConnection::SetLabels");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetLabels(operation));
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
InstantSnapshotsTracingConnection::TestIamPermissions(
    google::cloud::cpp::compute::instant_snapshots::v1::
        TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instant_snapshots_v1::InstantSnapshotsConnection::"
      "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_instant_snapshots_v1::InstantSnapshotsConnection>
MakeInstantSnapshotsTracingConnection(
    std::shared_ptr<compute_instant_snapshots_v1::InstantSnapshotsConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<InstantSnapshotsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_instant_snapshots_v1_internal
}  // namespace cloud
}  // namespace google
