// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/projects/v1/projects.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_PROJECTS_V1_PROJECTS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_PROJECTS_V1_PROJECTS_CONNECTION_H

#include "google/cloud/compute/projects/v1/internal/projects_retry_traits.h"
#include "google/cloud/compute/projects/v1/projects_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/projects/v1/projects.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_projects_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `ProjectsConnection`.
class ProjectsRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<ProjectsRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `ProjectsConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ProjectsLimitedErrorCountRetryPolicy : public ProjectsRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit ProjectsLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  ProjectsLimitedErrorCountRetryPolicy(
      ProjectsLimitedErrorCountRetryPolicy&& rhs) noexcept
      : ProjectsLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  ProjectsLimitedErrorCountRetryPolicy(
      ProjectsLimitedErrorCountRetryPolicy const& rhs) noexcept
      : ProjectsLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ProjectsRetryPolicy> clone() const override {
    return std::make_unique<ProjectsLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ProjectsRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      compute_projects_v1_internal::ProjectsRetryTraits>
      impl_;
};

/**
 * A retry policy for `ProjectsConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ProjectsLimitedTimeRetryPolicy : public ProjectsRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit ProjectsLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  ProjectsLimitedTimeRetryPolicy(ProjectsLimitedTimeRetryPolicy&& rhs) noexcept
      : ProjectsLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  ProjectsLimitedTimeRetryPolicy(
      ProjectsLimitedTimeRetryPolicy const& rhs) noexcept
      : ProjectsLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ProjectsRetryPolicy> clone() const override {
    return std::make_unique<ProjectsLimitedTimeRetryPolicy>(maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ProjectsRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      compute_projects_v1_internal::ProjectsRetryTraits>
      impl_;
};

/**
 * The `ProjectsConnection` object for `ProjectsClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `ProjectsClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `ProjectsClient`.
 *
 * To create a concrete instance, see `MakeProjectsConnection()`.
 *
 * For mocking, see `compute_projects_v1_mocks::MockProjectsConnection`.
 */
class ProjectsConnection {
 public:
  virtual ~ProjectsConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DisableXpnHost(
      google::cloud::cpp::compute::projects::v1::DisableXpnHostRequest const&
          request);

  virtual StatusOr<google::cloud::cpp::compute::v1::Operation> DisableXpnHost(
      NoAwaitTag,
      google::cloud::cpp::compute::projects::v1::DisableXpnHostRequest const&
          request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DisableXpnHost(google::cloud::cpp::compute::v1::Operation const& operation);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DisableXpnResource(google::cloud::cpp::compute::projects::v1::
                         DisableXpnResourceRequest const& request);

  virtual StatusOr<google::cloud::cpp::compute::v1::Operation>
  DisableXpnResource(NoAwaitTag, google::cloud::cpp::compute::projects::v1::
                                     DisableXpnResourceRequest const& request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DisableXpnResource(
      google::cloud::cpp::compute::v1::Operation const& operation);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  EnableXpnHost(
      google::cloud::cpp::compute::projects::v1::EnableXpnHostRequest const&
          request);

  virtual StatusOr<google::cloud::cpp::compute::v1::Operation> EnableXpnHost(
      NoAwaitTag,
      google::cloud::cpp::compute::projects::v1::EnableXpnHostRequest const&
          request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  EnableXpnHost(google::cloud::cpp::compute::v1::Operation const& operation);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  EnableXpnResource(
      google::cloud::cpp::compute::projects::v1::EnableXpnResourceRequest const&
          request);

  virtual StatusOr<google::cloud::cpp::compute::v1::Operation>
  EnableXpnResource(
      NoAwaitTag,
      google::cloud::cpp::compute::projects::v1::EnableXpnResourceRequest const&
          request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  EnableXpnResource(
      google::cloud::cpp::compute::v1::Operation const& operation);

  virtual StatusOr<google::cloud::cpp::compute::v1::Project> GetProject(
      google::cloud::cpp::compute::projects::v1::GetProjectRequest const&
          request);

  virtual StatusOr<google::cloud::cpp::compute::v1::Project> GetXpnHost(
      google::cloud::cpp::compute::projects::v1::GetXpnHostRequest const&
          request);

  virtual StatusOr<google::cloud::cpp::compute::v1::ProjectsGetXpnResources>
  GetXpnResources(
      google::cloud::cpp::compute::projects::v1::GetXpnResourcesRequest const&
          request);

  virtual StreamRange<google::cloud::cpp::compute::v1::Project> ListXpnHosts(
      google::cloud::cpp::compute::projects::v1::ListXpnHostsRequest request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>> MoveDisk(
      google::cloud::cpp::compute::projects::v1::MoveDiskRequest const&
          request);

  virtual StatusOr<google::cloud::cpp::compute::v1::Operation> MoveDisk(
      NoAwaitTag,
      google::cloud::cpp::compute::projects::v1::MoveDiskRequest const&
          request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>> MoveDisk(
      google::cloud::cpp::compute::v1::Operation const& operation);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  MoveInstance(
      google::cloud::cpp::compute::projects::v1::MoveInstanceRequest const&
          request);

  virtual StatusOr<google::cloud::cpp::compute::v1::Operation> MoveInstance(
      NoAwaitTag,
      google::cloud::cpp::compute::projects::v1::MoveInstanceRequest const&
          request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  MoveInstance(google::cloud::cpp::compute::v1::Operation const& operation);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetCloudArmorTier(
      google::cloud::cpp::compute::projects::v1::SetCloudArmorTierRequest const&
          request);

  virtual StatusOr<google::cloud::cpp::compute::v1::Operation>
  SetCloudArmorTier(
      NoAwaitTag,
      google::cloud::cpp::compute::projects::v1::SetCloudArmorTierRequest const&
          request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetCloudArmorTier(
      google::cloud::cpp::compute::v1::Operation const& operation);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetCommonInstanceMetadata(
      google::cloud::cpp::compute::projects::v1::
          SetCommonInstanceMetadataRequest const& request);

  virtual StatusOr<google::cloud::cpp::compute::v1::Operation>
  SetCommonInstanceMetadata(
      NoAwaitTag, google::cloud::cpp::compute::projects::v1::
                      SetCommonInstanceMetadataRequest const& request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetCommonInstanceMetadata(
      google::cloud::cpp::compute::v1::Operation const& operation);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetDefaultNetworkTier(google::cloud::cpp::compute::projects::v1::
                            SetDefaultNetworkTierRequest const& request);

  virtual StatusOr<google::cloud::cpp::compute::v1::Operation>
  SetDefaultNetworkTier(NoAwaitTag,
                        google::cloud::cpp::compute::projects::v1::
                            SetDefaultNetworkTierRequest const& request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetDefaultNetworkTier(
      google::cloud::cpp::compute::v1::Operation const& operation);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetUsageExportBucket(google::cloud::cpp::compute::projects::v1::
                           SetUsageExportBucketRequest const& request);

  virtual StatusOr<google::cloud::cpp::compute::v1::Operation>
  SetUsageExportBucket(NoAwaitTag,
                       google::cloud::cpp::compute::projects::v1::
                           SetUsageExportBucketRequest const& request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetUsageExportBucket(
      google::cloud::cpp::compute::v1::Operation const& operation);
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_projects_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_PROJECTS_V1_PROJECTS_CONNECTION_H
