// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/region_instant_snapshots/v1/region_instant_snapshots.proto

#include "google/cloud/compute/region_instant_snapshots/v1/internal/region_instant_snapshots_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_region_instant_snapshots_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RegionInstantSnapshotsTracingConnection::
    RegionInstantSnapshotsTracingConnection(
        std::shared_ptr<compute_region_instant_snapshots_v1::
                            RegionInstantSnapshotsConnection>
            child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstantSnapshotsTracingConnection::DeleteInstantSnapshot(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        DeleteInstantSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection::"
      "DeleteInstantSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteInstantSnapshot(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionInstantSnapshotsTracingConnection::DeleteInstantSnapshot(
    NoAwaitTag, google::cloud::cpp::compute::region_instant_snapshots::v1::
                    DeleteInstantSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection::"
      "DeleteInstantSnapshot");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteInstantSnapshot(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstantSnapshotsTracingConnection::DeleteInstantSnapshot(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection::"
      "DeleteInstantSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteInstantSnapshot(operation));
}

StatusOr<google::cloud::cpp::compute::v1::InstantSnapshot>
RegionInstantSnapshotsTracingConnection::GetInstantSnapshot(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        GetInstantSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection::"
      "GetInstantSnapshot");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInstantSnapshot(request));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionInstantSnapshotsTracingConnection::GetIamPolicy(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection::"
      "GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstantSnapshotsTracingConnection::InsertInstantSnapshot(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        InsertInstantSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection::"
      "InsertInstantSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertInstantSnapshot(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionInstantSnapshotsTracingConnection::InsertInstantSnapshot(
    NoAwaitTag, google::cloud::cpp::compute::region_instant_snapshots::v1::
                    InsertInstantSnapshotRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection::"
      "InsertInstantSnapshot");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->InsertInstantSnapshot(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstantSnapshotsTracingConnection::InsertInstantSnapshot(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection::"
      "InsertInstantSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertInstantSnapshot(operation));
}

StreamRange<google::cloud::cpp::compute::v1::InstantSnapshot>
RegionInstantSnapshotsTracingConnection::ListRegionInstantSnapshots(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        ListRegionInstantSnapshotsRequest request) {
  auto span = internal::MakeSpan(
      "compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection::"
      "ListRegionInstantSnapshots");
  internal::OTelScope scope(span);
  auto sr = child_->ListRegionInstantSnapshots(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::InstantSnapshot>(std::move(span),
                                                        std::move(sr));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionInstantSnapshotsTracingConnection::SetIamPolicy(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection::"
      "SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstantSnapshotsTracingConnection::SetLabels(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        SetLabelsRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection::"
      "SetLabels");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetLabels(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionInstantSnapshotsTracingConnection::SetLabels(
    NoAwaitTag, google::cloud::cpp::compute::region_instant_snapshots::v1::
                    SetLabelsRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection::"
      "SetLabels");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->SetLabels(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstantSnapshotsTracingConnection::SetLabels(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection::"
      "SetLabels");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetLabels(operation));
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
RegionInstantSnapshotsTracingConnection::TestIamPermissions(
    google::cloud::cpp::compute::region_instant_snapshots::v1::
        TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection::"
      "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<
    compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection>
MakeRegionInstantSnapshotsTracingConnection(
    std::shared_ptr<
        compute_region_instant_snapshots_v1::RegionInstantSnapshotsConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<RegionInstantSnapshotsTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_instant_snapshots_v1_internal
}  // namespace cloud
}  // namespace google
