// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/routes/v1/routes.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_ROUTES_V1_ROUTES_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_ROUTES_V1_ROUTES_CONNECTION_H

#include "google/cloud/compute/routes/v1/internal/routes_retry_traits.h"
#include "google/cloud/compute/routes/v1/routes_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/routes/v1/routes.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_routes_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `RoutesConnection`.
class RoutesRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<RoutesRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `RoutesConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class RoutesLimitedErrorCountRetryPolicy : public RoutesRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit RoutesLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  RoutesLimitedErrorCountRetryPolicy(
      RoutesLimitedErrorCountRetryPolicy&& rhs) noexcept
      : RoutesLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  RoutesLimitedErrorCountRetryPolicy(
      RoutesLimitedErrorCountRetryPolicy const& rhs) noexcept
      : RoutesLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<RoutesRetryPolicy> clone() const override {
    return std::make_unique<RoutesLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = RoutesRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      compute_routes_v1_internal::RoutesRetryTraits>
      impl_;
};

/**
 * A retry policy for `RoutesConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class RoutesLimitedTimeRetryPolicy : public RoutesRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit RoutesLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  RoutesLimitedTimeRetryPolicy(RoutesLimitedTimeRetryPolicy&& rhs) noexcept
      : RoutesLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  RoutesLimitedTimeRetryPolicy(RoutesLimitedTimeRetryPolicy const& rhs) noexcept
      : RoutesLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<RoutesRetryPolicy> clone() const override {
    return std::make_unique<RoutesLimitedTimeRetryPolicy>(maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = RoutesRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      compute_routes_v1_internal::RoutesRetryTraits>
      impl_;
};

/**
 * The `RoutesConnection` object for `RoutesClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `RoutesClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `RoutesClient`.
 *
 * To create a concrete instance, see `MakeRoutesConnection()`.
 *
 * For mocking, see `compute_routes_v1_mocks::MockRoutesConnection`.
 */
class RoutesConnection {
 public:
  virtual ~RoutesConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteRoute(google::cloud::cpp::compute::routes::v1::DeleteRouteRequest const&
                  request);

  virtual StatusOr<google::cloud::cpp::compute::v1::Operation> DeleteRoute(
      NoAwaitTag,
      google::cloud::cpp::compute::routes::v1::DeleteRouteRequest const&
          request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteRoute(google::cloud::cpp::compute::v1::Operation const& operation);

  virtual StatusOr<google::cloud::cpp::compute::v1::Route> GetRoute(
      google::cloud::cpp::compute::routes::v1::GetRouteRequest const& request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertRoute(google::cloud::cpp::compute::routes::v1::InsertRouteRequest const&
                  request);

  virtual StatusOr<google::cloud::cpp::compute::v1::Operation> InsertRoute(
      NoAwaitTag,
      google::cloud::cpp::compute::routes::v1::InsertRouteRequest const&
          request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertRoute(google::cloud::cpp::compute::v1::Operation const& operation);

  virtual StreamRange<google::cloud::cpp::compute::v1::Route> ListRoutes(
      google::cloud::cpp::compute::routes::v1::ListRoutesRequest request);
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_routes_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_ROUTES_V1_ROUTES_CONNECTION_H
