// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/storage_pools/v1/storage_pools.proto

#include "google/cloud/compute/storage_pools/v1/storage_pools_connection.h"
#include "google/cloud/compute/storage_pools/v1/internal/storage_pools_option_defaults.h"
#include "google/cloud/compute/storage_pools/v1/internal/storage_pools_tracing_connection.h"
#include "google/cloud/compute/storage_pools/v1/storage_pools_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_storage_pools_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

StoragePoolsConnection::~StoragePoolsConnection() = default;

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::StoragePoolsScopedList>>
StoragePoolsConnection::AggregatedListStoragePools(
    google::cloud::cpp::compute::storage_pools::v1::
        AggregatedListStoragePoolsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<StreamRange<
      std::pair<std::string,
                google::cloud::cpp::compute::v1::StoragePoolsScopedList>>>();
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
StoragePoolsConnection::DeleteStoragePool(
    google::cloud::cpp::compute::storage_pools::v1::
        DeleteStoragePoolRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
StoragePoolsConnection::DeleteStoragePool(
    NoAwaitTag, google::cloud::cpp::compute::storage_pools::v1::
                    DeleteStoragePoolRequest const&) {
  return StatusOr<google::cloud::cpp::compute::v1::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
StoragePoolsConnection::DeleteStoragePool(
    google::cloud::cpp::compute::v1::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::StoragePool>
StoragePoolsConnection::GetStoragePool(
    google::cloud::cpp::compute::storage_pools::v1::
        GetStoragePoolRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
StoragePoolsConnection::GetIamPolicy(
    google::cloud::cpp::compute::storage_pools::v1::
        GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
StoragePoolsConnection::InsertStoragePool(
    google::cloud::cpp::compute::storage_pools::v1::
        InsertStoragePoolRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
StoragePoolsConnection::InsertStoragePool(
    NoAwaitTag, google::cloud::cpp::compute::storage_pools::v1::
                    InsertStoragePoolRequest const&) {
  return StatusOr<google::cloud::cpp::compute::v1::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
StoragePoolsConnection::InsertStoragePool(
    google::cloud::cpp::compute::v1::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::cpp::compute::v1::StoragePool>
StoragePoolsConnection::ListStoragePools(
    google::cloud::cpp::compute::storage_pools::v1::
        ListStoragePoolsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::cpp::compute::v1::StoragePool>>();
}

StreamRange<google::cloud::cpp::compute::v1::StoragePoolDisk>
StoragePoolsConnection::ListDisks(
    google::cloud::cpp::compute::storage_pools::v1::
        ListDisksRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::cpp::compute::v1::StoragePoolDisk>>();
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
StoragePoolsConnection::SetIamPolicy(
    google::cloud::cpp::compute::storage_pools::v1::
        SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
StoragePoolsConnection::TestIamPermissions(
    google::cloud::cpp::compute::storage_pools::v1::
        TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
StoragePoolsConnection::UpdateStoragePool(
    google::cloud::cpp::compute::storage_pools::v1::
        UpdateStoragePoolRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
StoragePoolsConnection::UpdateStoragePool(
    NoAwaitTag, google::cloud::cpp::compute::storage_pools::v1::
                    UpdateStoragePoolRequest const&) {
  return StatusOr<google::cloud::cpp::compute::v1::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
StoragePoolsConnection::UpdateStoragePool(
    google::cloud::cpp::compute::v1::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_storage_pools_v1
}  // namespace cloud
}  // namespace google
